#include "../config.h"
#include <gnome.h>
#include <gtk/gtk.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "portab.h"
#include "typedef.h"
#include "makros.h"
#include "var.h"
#include "pro.h"
#include "version.h"
#include "menu.h"
#include "child.h"
#include "board.h"
#include "ini.h"
#include "txt_load.h"

#ifdef CHESS_ENGINE_CRAFTY
#define     FIRST_CHESS_PROGRAMM CHESS_ENGINE_CRAFTY
#define     FIRST_CHESS_PROGRAMM_ARG "xboard"
#else
#ifdef CHESS_ENGINE_GNUCHESS
#define     FIRST_CHESS_PROGRAMM CHESS_ENGINE_GNUCHESS
#define     FIRST_CHESS_PROGRAMM_ARG NULL
#endif
#endif

struct engine *first_chess_programm;

int main(int argc,char *argv[])
{
     GtkWidget *box;
     GtkWidget *app;

     bindtextdomain (PACKAGE, GNOMELOCALEDIR);
     textdomain (PACKAGE);

     gnome_init ("chess", VERSION, argc, argv);


     ini_chessboard();

     //     pgn_test(); 
     //return 0;

     app = gnome_app_new ("chess", "Gnomified chess program");

     create_menus(app);
	
     first_chess_programm =new_engine(FIRST_CHESS_PROGRAMM,FIRST_CHESS_PROGRAMM_ARG);
     //     engine_write(first_chess_programm,"log off\n");
     engine_write(first_chess_programm,"post\n");
     engine_write(first_chess_programm,"easy\n");
     engine_write(first_chess_programm,"level 60 2 0\n");

     box = init_board();
     gnome_app_set_contents ( GNOME_APP (app), box);

     gtk_widget_show(box);
     gtk_widget_show (app);

     if (argc>1) pgn_open(argv[1]);

     gtk_main ();


     return 0;
}

