#include <gtk/gtkclist.h>
#include <glib.h>
 
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include "portab.h"
#include "typedef.h"
#include "makros.h"
#include "var.h"
#include "pro.h"
#include "partie.h"
#include "cho1.h"
#include "board.h"
#include "ini.h"
#include "child.h"


#define WHITE 0
#define BLACK 1

static GList *score;
static GList *current;
static GList *last;

struct _move
{
  int  number;
  char piece;
  char from;
  char to;
  int  check : 1;
  int  mate  : 1;
  int  take  : 1;
  int  color  : 1;
  int  reserved: 4;
  char ascii[8];
};

typedef struct _move move;

#define DEBUG 
/*#define DEBUG  do { GList *ll; \
               printf("DEBUG:\n");\
               printf("sc %p cu %p la %p\n",score,current,last); \
               for ( ll = score; ll; ll=ll->next) \
                   printf("%p->",ll);\
                   printf("NULL\n",ll);\
               for ( ll = score; ll; ll=ll->next) \
                   { \
                   move *mm=ll->data; \
                   if (mm)  \
                     printf("%d %d %d\n",mm->number,mm->from,mm->to); \
                   else \
                     printf("(nil)\n"); } \
} while (0) 
*/

static void clist_update(move *m)
{
  char    *text[3] = { "", "","" };
  char p[10];

  GtkWidget *clist = board.movelist;

  piece_move_to_ascii(m->ascii,m->piece,m->from,m->to);
  if ( m->color == WHITE)
    {
      gint row;

      sprintf(p,"%d",m->number);
      row=gtk_clist_append (GTK_CLIST(clist), text);
      gtk_clist_set_text (GTK_CLIST(clist), row, 0, p);
      gtk_clist_set_text (GTK_CLIST(clist), row, 1, m->ascii);
      if ( GTK_VISIBILITY_FULL != gtk_clist_row_is_visible(GTK_CLIST(clist),row))
            gtk_clist_moveto (GTK_CLIST(clist), row , -1 , 1.0, 0.0); 
    }
  else
    gtk_clist_set_text (GTK_CLIST(clist), m->number-1, 2, m->ascii);
}

void ini_notation()
{
        ini_position();
	score =  NULL;
	score = current = last =  g_list_append(score,NULL);
	if (board.movelist) gtk_clist_clear( GTK_CLIST(board.movelist));
}

void move_forward()
{
  move *m;

  if (current == last) return;

  current = current->next;
  m= current->data;
  make_move(m->from,m->to);
  clist_update(m);

  DEBUG;
}

void move_back()
{
  GList *l;
  int piece;
  GtkWidget *clist = board.movelist;

  if ( current  == score ) return;

  ini_position();
  gtk_clist_freeze( GTK_CLIST(clist));
  gtk_clist_clear( GTK_CLIST(clist));

  for(l=score->next; l !=current ; l = l->next)
    {
      move *m=l->data;
      piece = m->piece;
      make_move(m->from,m->to);
      clist_update(m);
    }

  current=current->prev;
  gtk_clist_thaw( GTK_CLIST(clist));

  DEBUG;
}

void move_to_end()
{
  move *m;
  GList *l;
  GtkWidget *clist = board.movelist;

  if (current == last) return;
  gtk_clist_freeze( GTK_CLIST(clist));

  for (l=current->next; l; l=l->next)
    {
      m = l->data;
      make_move(m->from,m->to);
      clist_update(m);
    }
  current = last;
  gtk_clist_thaw( GTK_CLIST(clist));
}

void move_to_start() 
{
  GtkWidget *clist = board.movelist;

  if (current==score) return;
	
  ini_position();
  current = score;
  gtk_clist_clear( GTK_CLIST(clist));
}
 
void notation_update(int piece,int von, int nach)
{
  GList *l;
  move *m= (move *) malloc (sizeof(move));
  if (!m) abort();

  m->piece= piece;
  m->from = von;
  m->to   = nach;
  m->color = WFIGUR(piece) ? WHITE : BLACK;

  // printf("notation_update");
  DEBUG;  
  if (current != last)
    {
      while(( l=current->next))
	{
	  score = g_list_remove(score,l->data);
	  printf("remove %p\n",l);
	  DEBUG;;
	}
    }
  // printf("update: %p %p %p\n",current,score,last);

  DEBUG;
  if (current == score) m->number=1;
  else
    {
      move *s = current->data;
      m->number=s->number;
      if (WFIGUR(piece))
	m->number++;
    }

  score = g_list_append(score,m);
  last = current = current->next;
  clist_update(m);

  DEBUG;
}

void notation_erzeugen(char *buf)
{
        int nummer;
        char str1[10];
	GList *l;
	move *m;

        nummer = 1;
        buf[0]='\0';

        if (score == current) return;

	ini_position();

        for( l= score;  l != last; l=l->next)
        {
	    m = l->data;
            snprintf(str1,10,"%d",nummer);
            strcat(buf,str1);
            strcat(buf,". ");
            nummer++;
            make_move(m->from,m->to);
            strcat(buf,m->ascii);
            strcat(buf,"\n");
        }
}
#if 1
static void position_to_engine(void)
{
  int i;
  char s[10];
  char *p;

  engine_write(first_chess_programm,"edit\n");
  engine_write(first_chess_programm,"#\n");

  for (i=A1; i<= H8;i++)
    {
      p = s;
      switch (feld[i])
	{
	case WB:  *p++='P';break;
	case WS:  *p++='N';break;
	case WL:  *p++='B';break;
	case WT:  *p++='R';break;
	case WD:  *p++='Q';break;
	case WK:  *p++='K';break;
	default:   continue;
	}

      *p++   = i - i / 10 * 10 + 96;   /*  a - h       */
      *p++   = i / 10 + 47 ;              /*  1 - 8       */
      *p=0;
      printf("%s\n",s);  
      engine_write(first_chess_programm,"%s\n",s);  
    }

  engine_write(first_chess_programm,"c\n");  
  
  for (i=A1; i<= H8;i++)
    {
      p = s;
      switch (feld[i])
	{
	case SB:  *p++='P';break;
	case SS:  *p++='N';break;
	case SL:  *p++='B';break;
	case ST:  *p++='R';break;
	case SD:  *p++='Q';break;
	case SK:  *p++='K';break;
	default:   continue;
	}

      *p++   = i - i / 10 * 10 + 96;   /*  a - h       */
      *p++   = i / 10 + 47 ;              /*  1 - 8       */
      *p=0;
      printf("%s\n",s);  
      engine_write(first_chess_programm,"%s\n",s);  
    }

  engine_write(first_chess_programm,".\n");
}
#endif
void move_to_engine(int ff1, int ff)
{
  char s[100];
  if (current != last)
       position_to_engine();

  move_to_ascii(s,ff1,ff);
  engine_write(first_chess_programm,"%s\n",s);
}
