#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include "portab.h"
#include "makros.h"
#include "typedef.h"
#include "var.h"
#include "pro.h"
#include "cho1.h"

static int norm_piece(int piece);
static char piece_to_ascii[]= {' ','N','B','R','Q','K'};


char * move_to_ascii(char *p, int from, int to)
{
  int a;

  *p++   = from - from / 10 * 10 + 96;   /*  a - h       */
  *p++   = from / 10 + 47 ;              /*  1 - 8       */
  //  *p++   = '-'; 

  if (to & 128) 
    {       // promotion
      a=to;

      if ( from > E4)     // white
	a = (a & 7) + A8;
      else                // black
	a = (a & 7) + A1;

      *p++    = a - a / 10 * 10 + 96;     /*  a - h       */
      *p++    = a / 10 + 47 ;             /*  1 - 8       */
      *p++ = piece_to_ascii[((to >> 3) & 7)-1];
      //      *p++ = ' ';
    }
  else 
    {
      *p++   = to - to / 10 * 10 + 96;     /*  a - h       */
      *p++   = to / 10 + 47 ;              /*  1 - 8       */
      // *p++   = ' ';
    }

  *p='\0';
  return p;
}

static int ascii_to_piece(int p)
{
  if (p == 'q') return WD-WB;
  if (p == 'r') return WT-WB;
  if (p == 'b') return WL-WB;
  if (p == 'n') return WS-WB;
  if (p == 'Q') return WD-WB;
  if (p == 'R') return WT-WB;
  if (p == 'B') return WL-WB;
  if (p == 'N') return WS-WB;
  abort();
}

void ascii_to_move(char *p, int *from, int *to)
{
  if (*p=='o')
    {
      if (!strcmp(p,"o-o-o"))
	{
	  if (stp->amzug == WAZ)
	    {
	      *from = E1;
	      *to   = C1;
	    }
	  else
	    {
	      *from = E8;
	      *to   = C8;
	    }
	}
      else
	if (stp->amzug == WAZ)
	  {
	    *from = E1;
	    *to   = G1;
	  }
	else
	  {
	    *from = E8;
	    *to   = G8;
	  }
    }
  else if (*(p+4)=='q' || *(p+4)=='r' || *(p+4)=='b' || *(p+4)=='n' ||
	   *(p+4)=='Q' || *(p+4)=='R' || *(p+4)=='B' || *(p+4)=='N' )
    { // promotion
      *from = (*p - 'a' + 1) + (*(p+1) - '1' + 2 ) * 10;
      p+=2;
      *to = (*p - 'a' + 1) + (*(p+1) - '1' + 2 ) * 10;
      if (*(p+1) == '1')
	  *to = 128 +  *to - A1 + ( ascii_to_piece(*(p+2)) + 1) * 8;
      else
      if (*(p+1) == '8')
	  *to = 128 +  *to - A8 + ( ascii_to_piece(*(p+2)) + 1) * 8;
      else abort();
    }
  else
    {
      *from = (*p - 'a' + 1) + (*(p+1) - '1' + 2 ) * 10;
      p+=2;
      *to   = (*p - 'a' + 1) + (*(p+1) - '1' + 2 ) * 10;
    }
}

void piece_move_to_ascii(char *p,int  piece, int  from, int to)
{
  int i;

        if ( (piece == WK || piece == SK) && abs(from-to) == 2)
	  {
	    if (to % 10 == 3)
	      {
		strcpy(p,"O-O-O");
		return;
	      }
	    if (to % 10 == 7)
	      {
		strcpy(p,"O-O");
		return;
	      }
	    abort();
	  }

        i = norm_piece(piece);
        *p++ = piece_to_ascii[i];
        move_to_ascii(p,from,to);
}

static int norm_piece(int piece)
{
   if (WFIGUR(piece))
         return piece-WB;
   if (SFIGUR(piece))
         return piece-SB;

   return piece;
}
