#include <config.h>
#include <gnome.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "portab.h"
#include "makros.h"
#include "typedef.h"
#include "var.h"
#include "pro.h"
#include "partie.h"
#include "disk.h"
#include "txt_load.h"

static void open_st(const char *fname)
{
  pgn_open(fname);
}

static void write_txt(const char *file)
{
  FILE *fp;
  BYTE newbuf[1024]; 

  notation_erzeugen(newbuf);
  
  fp = fopen(file,"w");
  if(fp == NULL) 
    {
      abort();
      return;
    }

  if(fputs(newbuf,fp)==EOF)
    {
      abort();
    }

  if(fclose(fp))
      abort();
}

static void
set_ok (GtkWidget *widget, gboolean *dialog_result)
{
	*dialog_result = TRUE;
	gtk_main_quit ();
}


static void filesel (const char *what,const char *filename, void func() )
{
	GtkFileSelection *fsel;
	gboolean accepted = FALSE;
	
	fsel = (GtkFileSelection *)gtk_file_selection_new (what);
	gtk_file_selection_set_filename (fsel, filename);
	
	/* Connect the signals for Ok and Cancel */
	gtk_signal_connect (GTK_OBJECT (fsel->ok_button), "clicked",
			    GTK_SIGNAL_FUNC (set_ok), &accepted);
	gtk_signal_connect (GTK_OBJECT (fsel->cancel_button), "clicked",
			    GTK_SIGNAL_FUNC (gtk_main_quit), NULL);
	
	/* Run the dialog */
	gtk_widget_show (GTK_WIDGET (fsel));
	gtk_grab_add (GTK_WIDGET (fsel));
	gtk_main ();

	if (accepted)
	  {
	    char *name = gtk_file_selection_get_filename (fsel);
	    func(name);
	  }
	gtk_widget_destroy (GTK_WIDGET (fsel));
}

void save_game()
{
  filesel(_("Save game as"), "noname.pgn", write_txt);
}

void load_game()
{
  filesel(_("Load game"), "noname.pgn", open_st);
}
