#include "gnome_chess.h"
#include <ctype.h>
#include "portab.h"
#include "makros.h"
#include "pro.h"
#include "cho1.h"

static int norm_piece(int piece);
static char piece_to_ascii[]= {' ','N','B','R','Q','K'};

static void file_to_ascii(char **move, int square) {
	*(*move)++ = square - square / 10 * 10 + 96;	/* a - h */
}

static void rank_to_ascii(char **move, int square) {
	*(*move)++ = square / 10 + 47 ;			/* 1 - 8 */
}

static void square_to_ascii(char **move, int square) {
	file_to_ascii(move, square);
	rank_to_ascii(move, square);
}


static int same_rank(int square, int square2) {
	char *s1;
	char *s2;
	char same1;
	char same2;

	s1 = &same1;
	s2 = &same2;
	rank_to_ascii(&s1, square);
	rank_to_ascii(&s2, square2);
	if (same1 == same2)
		return 1;
	else
		return 0;
}

static int same_file(int square, int square2) {
	char *s1;
	char *s2;
	char same1;
	char same2;

	s1 = &same1;
	s2 = &same2;
	file_to_ascii(&s1, square);
	file_to_ascii(&s2, square2);
	if (same1 == same2)
		return 1;
	else
		return 0;
}

char * move_to_ascii(char *p, int from, int to)
{
  int a;

  *p++   = from - from / 10 * 10 + 96;   /*  a - h       */
  *p++   = from / 10 + 47 ;              /*  1 - 8       */
  //  *p++   = '-'; 

  if (to & 128) 
    {       // promotion
      a=to;

      if ( from > E4)     // white
	a = (a & 7) + A8;
      else                // black
	a = (a & 7) + A1;

      *p++    = a - a / 10 * 10 + 96;     /*  a - h       */
      *p++    = a / 10 + 47 ;             /*  1 - 8       */
      *p++ = piece_to_ascii[((to >> 3) & 7)-1];
      //      *p++ = ' ';
    }
  else 
    {
      *p++   = to - to / 10 * 10 + 96;     /*  a - h       */
      *p++   = to / 10 + 47 ;              /*  1 - 8       */
      // *p++   = ' ';
    }

  *p='\0';
  return p;
}

static int ascii_to_piece(int p)
{
  if (p == 'q') return WQ-WP;
  if (p == 'r') return WR-WP;
  if (p == 'b') return WB-WP;
  if (p == 'n') return WN-WP;
  if (p == 'Q') return WQ-WP;
  if (p == 'R') return WR-WP;
  if (p == 'B') return WB-WP;
  if (p == 'N') return WN-WP;
  abort();
}

void ascii_to_move(char *p, int *from, int *to)
{
  if (*p=='o')
    {
      if (!strcmp(p,"o-o-o"))
	{
	  if (currPositionPtr->amzug == WMOVE)
	    {
	      *from = E1;
	      *to   = C1;
	    }
	  else
	    {
	      *from = E8;
	      *to   = C8;
	    }
	}
      else
	if (currPositionPtr->amzug == WMOVE)
	  {
	    *from = E1;
	    *to   = G1;
	  }
	else
	  {
	    *from = E8;
	    *to   = G8;
	  }
    }
  else if (*(p+4)=='q' || *(p+4)=='r' || *(p+4)=='b' || *(p+4)=='n' ||
	   *(p+4)=='Q' || *(p+4)=='R' || *(p+4)=='B' || *(p+4)=='N' )
    { // promotion
      *from = (*p - 'a' + 1) + (*(p+1) - '1' + 2 ) * 10;
      p+=2;
      *to = (*p - 'a' + 1) + (*(p+1) - '1' + 2 ) * 10;
      if (*(p+1) == '1')
	  *to = 128 +  *to - A1 + ( ascii_to_piece(*(p+2)) + 1) * 8;
      else
      if (*(p+1) == '8')
	  *to = 128 +  *to - A8 + ( ascii_to_piece(*(p+2)) + 1) * 8;
      else abort();
    }
  else
    {
      *from = (*p - 'a' + 1) + (*(p+1) - '1' + 2 ) * 10;
      p+=2;
      *to   = (*p - 'a' + 1) + (*(p+1) - '1' + 2 ) * 10;
    }
}

void piece_move_to_ascii(char *p,int  piece, int  from, int to)
{
  int i;

        if ( (piece == WK || piece == BK) && abs(from-to) == 2)
	  {
	    if (to % 10 == 3)
	      {
		strcpy(p,"O-O-O");
		return;
	      }
	    if (to % 10 == 7)
	      {
		strcpy(p,"O-O");
		return;
	      }
	    abort();
	  }

        i = norm_piece(piece);
        *p++ = piece_to_ascii[i];
        move_to_ascii(p,from,to);
}

static int norm_piece(int piece)
{
   if (WPIECE(piece))
         return piece-WP;
   if (BPIECE(piece))
         return piece-BP;

   return piece;
}

char * move_to_san(position *pos, int from, int to) {
	int piece, norm, checksquare, checkto, desrank, desfile, promote, inc;
	int i, tempdesfile, tempdesrank;
	char *san;
	char *temp;
	const int jump[]={ 8, 12,19, 21,-8,-12,-19,-21};

	san = malloc(sizeof(char)*12);
	temp = san;

	desrank = desfile = promote = 0;

	/* Handle Promotion */
	if (to & 128) {
		promote = ((to >> 3) & 7)-1;
     		if ( from > E4) {
			to = (to & 7) + A8;
			piece = WP;
		} else {
			to = (to & 7) + A1;
			piece = BP;
		}
	} else {
		piece = pos->square[to];
	}

	/* Check if we have to designate the rank or file */
	switch (piece) {
		case WQ:
		case BQ:
			/* Check like rooks and bishops */
		case WR:
		case BR:
			/* Check for other rooks/queens */
			i = 0;
			while (1) {
				tempdesfile = tempdesrank = 0;
				 if (i == 0) {
					checksquare = 20 + (to % 10);
					checkto =  90 + (to % 10);
					if (from / 10 > to / 10 )
						checkto = to - 10;
					else if (from / 10 < to /10)
						checksquare = to + 10;
					inc = 10;
				} else if (i == 1) {
					checksquare = 10 * (to / 10) + 1;
					checkto =  10 * (to / 10) + 8;
					if (from % 10 > to % 10)
						checkto = to - 1;
					else if (from % 10 < to % 10)
						checksquare = to + 1;
					inc = 1;
				} else {
					break;
				}

				while (checksquare <= checkto) {
					if (pos->square[checksquare] == piece && checksquare != to) {
						if (same_rank(from, checksquare))
							tempdesfile = 1;
						else if (same_file(from, checksquare))
							desrank = 1;
						else 
							tempdesfile = 1;
					} else if (pos->square[checksquare] != EMPTY && checksquare < to) {
						tempdesfile = tempdesrank = 0;	/* A piece is in the way */
					} else if (pos->square[checksquare] != EMPTY && checksquare > to) {
						break;			/* A piece is in the way */
					}
					checksquare += inc;
				}
				i++;
				if (tempdesfile == 1) desfile = 1;
				if (tempdesrank == 1) desrank = 1;
			}
			if (piece == WR || piece == BR) break;
		case WB:
		case BB:
			/* Check for other bishops/queens */
			i = 0;
			while (1) {
				tempdesfile = tempdesrank = 0;
				 if (i == 0) {
					checksquare = to - (((to % 10) - 1) * 11);
					checkto =  to + ((9 - (to / 10)) * 11);
					if (from % 10 > to % 10  && from / 10 > to / 10)
						checkto = to - 11;
					else if (from % 10 < to % 10 && from / 10 < to / 10)
						checksquare = to + 11;
					inc = 11;
				} else if (i == 1) {
					checksquare = to - ((8 - (to % 10)) * 9);
					checkto =  to + ((9 - (to / 10)) * 9);
					if (from % 10 > to % 10 && from / 10 < to / 10)
						checksquare = to + 9;
					else if (from % 10 < to % 10  && from / 10 > to / 10)
						checkto = to - 9;
					inc = 9;
				} else {
					break;
				}

				while (checksquare <= checkto) {
					if (pos->square[checksquare] == piece && checksquare != to) {
						if (same_rank(from, checksquare))
							tempdesfile = 1;
						else if (same_file(from, checksquare))
							desrank = 1;
						else 
							tempdesfile = 1;
					} else if (pos->square[checksquare] != EMPTY && checksquare < to) {
						tempdesfile = tempdesrank = 0;	/* A piece is in the way */
					} else if (pos->square[checksquare] != EMPTY && checksquare > to) {
						break;			/* A piece is in the way */
					}
					checksquare += inc;
				}
				i++;
				if (tempdesfile == 1) desfile = 1;
				if (tempdesrank == 1) desrank = 1;
			}
			break;
		case WN:
		case BN:
			/* Check for other knights */
			for (i=0;i<8;i++) {
				if (pos->square[to+jump[i]] == piece && to+jump[i] >= 0) {
					if (same_rank(from, to+jump[i]))
						desfile = 1;
					else if (same_file(from, to+jump[i]))
						desrank = 1;
					else 
						desfile = 1;
				}
			}
			break;				

	}

	/* Handle Castling */
	if ((piece == WK || piece == BK) && abs(from-to) == 2) {
		if (to % 10 == 3)
			strcpy(temp,"O-O-O");
		if (to % 10 == 7)
			strcpy(temp,"O-O");
	} else {
		/* The piece letter */
	        norm = norm_piece(piece);
		if (norm > 0)
		        *temp++ = piece_to_ascii[norm];

		/* The rank/file designators */
		if (desfile)
			file_to_ascii(&temp, from);
		if (desrank)
			rank_to_ascii(&temp, from);

		/* If there was a capture */
		if (pos->vf != EMPTY) {
			if (piece == WP || piece == BP)
				file_to_ascii(&temp, from);
			*temp++ = 'x';
		}

		/* Destination square */
	        square_to_ascii(&temp, to);

		/* If there was promotion */
		if (promote) {
			*temp++ = '=';
			norm = norm_piece(promote);
			*temp++ = piece_to_ascii[norm];
		}

		*temp = '\0';
	}

	temp = san;
	san = strdup(temp);
	free(temp);
	return san;
}

void san_to_move(position *pos, char *p, int *from, int *to) {

}
