/* 
 * Copyright (C) 1999 JP Rosevear
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#include "gnome_chess.h"
#include <stdarg.h>
#include <stdio.h>

#include "dialog_login.h"

extern GtkWidget *app;

int dialog_login_new(struct engine *e) {
  GtkWidget *dlg;
  GtkWidget *dialog_vbox2;
  GtkWidget *table1;
  GtkWidget *entry_user;
  GtkWidget *entry_pass;
  GtkWidget *lbl;
  GtkWidget *lbl2;
  int button;

  dlg = gnome_dialog_new ("Login", GNOME_STOCK_BUTTON_CANCEL, GNOME_STOCK_BUTTON_OK, NULL);
  gnome_dialog_set_parent(GNOME_DIALOG(dlg), GTK_WINDOW(app));
  gtk_object_set_data (GTK_OBJECT (dlg), "dlg", dlg);
  gtk_window_set_policy (GTK_WINDOW (dlg), FALSE, FALSE, FALSE);

  dialog_vbox2 = GNOME_DIALOG (dlg)->vbox;
  gtk_object_set_data (GTK_OBJECT (dlg), "dialog_vbox2", dialog_vbox2);
  gtk_widget_show (dialog_vbox2);

  table1 = gtk_table_new (2, 2, FALSE);
  gtk_widget_ref (table1);
  gtk_object_set_data_full (GTK_OBJECT (dlg), "table1", table1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (table1);
  gtk_box_pack_start (GTK_BOX (dialog_vbox2), table1, TRUE, TRUE, 0);
  gtk_table_set_col_spacings (GTK_TABLE (table1), 4);

  entry_user = gtk_entry_new ();
  if (engine_ics_get_user(first_chess_programm))
	  gtk_entry_set_text(GTK_ENTRY(entry_user), engine_ics_get_user(first_chess_programm));
  gtk_widget_ref (entry_user);
  gtk_object_set_data_full (GTK_OBJECT (dlg), "entry_user", entry_user,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (entry_user);
  gtk_table_attach (GTK_TABLE (table1), entry_user, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  entry_pass = gtk_entry_new ();
  if (engine_ics_get_pass(first_chess_programm))
	  gtk_entry_set_text(GTK_ENTRY(entry_pass), engine_ics_get_pass(first_chess_programm));
  gtk_widget_ref (entry_pass);
  gtk_object_set_data_full (GTK_OBJECT (dlg), "entry_pass", entry_pass,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (entry_pass);
  gtk_table_attach (GTK_TABLE (table1), entry_pass, 1, 2, 1, 2,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  lbl = gtk_label_new (_("Username"));
  gtk_widget_ref (lbl);
  gtk_object_set_data_full (GTK_OBJECT (dlg), "lbl", lbl,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (lbl);
  gtk_table_attach (GTK_TABLE (table1), lbl, 0, 1, 0, 1,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_justify (GTK_LABEL (lbl), GTK_JUSTIFY_LEFT);

  lbl2 = gtk_label_new (_("Password"));
  gtk_widget_ref (lbl2);
  gtk_object_set_data_full (GTK_OBJECT (dlg), "lbl2", lbl2,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (lbl2);
  gtk_table_attach (GTK_TABLE (table1), lbl2, 0, 1, 1, 2,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_justify (GTK_LABEL (lbl2), GTK_JUSTIFY_LEFT);

  button = gnome_dialog_run(GNOME_DIALOG (dlg));

  switch (button) {
	case 0:
  		engine_destroy_all();
	    gnome_dialog_close(GNOME_DIALOG (dlg));
		engine_destroy_all();
  		gtk_main_quit ();
		break;
	case 1:
		engine_ics_set_user(first_chess_programm, gtk_editable_get_chars(GTK_EDITABLE(entry_user),0,-1));
		engine_ics_set_pass(first_chess_programm, gtk_editable_get_chars(GTK_EDITABLE(entry_pass),0,-1));
	    gnome_dialog_close(GNOME_DIALOG (dlg));
  }
  return 0;
}