/* 
 * Copyright (C) 1999 JP Rosevear
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#include "gnome_chess.h"
#include <ctype.h>
#include <sys/time.h>
#include <stdarg.h>
#include <signal.h>

#include "makros.h"
#include "portab.h"
#include "child.h"
#include "cho1.h"
#include "pro.h"
#include "position.h"
#include "sound.h"

/* Menu callback functions */
static void engine_local_menu_init(struct engine *e);
static void engine_local_new_cb (GtkWidget *widget, void *data);
static void engine_local_takeback_cb (GtkWidget *widget, void *data);
static void engine_local_flag_cb (GtkWidget *widget, void *data);
static void engine_local_draw_cb (GtkWidget *widget, void *data);
static void engine_local_resign_cb (GtkWidget *widget, void *data);
static void engine_local_start_cb (GtkWidget *widget, void *data);
static void engine_local_previous_cb (GtkWidget *widget, void *data);
static void engine_local_next_cb (GtkWidget *widget, void *data);
static void engine_local_end_cb (GtkWidget *widget, void *data);
static void engine_local_now_cb (GtkWidget *widget, void *data);
static void engine_local_go_cb (GtkWidget *widget, void *data);
static void engine_local_cwhite_cb (GtkWidget *widget, void *data);
static void engine_local_cblack_cb (GtkWidget *widget, void *data);

struct engine * engine_local_new(char *cmd, char *arg) {
	struct engine *e;

	e = engine_new(cmd, arg);
	engine_local_menu_init(e);

	gdk_input_add( fileno(e->read_from), GDK_INPUT_READ, engine_local_cb, e);

	engine_write(e,"xboard\n");
	engine_write(e,"post\n");
	engine_write(e,"easy\n");
	engine_write(e,"level 60 2 0\n");

	return e;
}

static void engine_local_menu_init(struct engine *e) {
	e->menudata->menu_init = engine_local_menu_init;
	e->menudata->menu_new_cb = engine_local_new_cb;
	e->menudata->menu_flag_cb = engine_local_flag_cb;
	e->menudata->menu_draw_cb = engine_local_draw_cb;
	e->menudata->menu_resign_cb = engine_local_resign_cb;
	e->menudata->menu_start_cb = engine_local_start_cb;
	e->menudata->menu_previous_cb = engine_local_previous_cb;
	e->menudata->menu_next_cb = engine_local_next_cb;
	e->menudata->menu_end_cb = engine_local_end_cb;
	e->menudata->menu_takeback_cb = engine_local_takeback_cb;
	e->menudata->menu_go_cb = engine_local_go_cb;
	e->menudata->menu_now_cb = engine_local_now_cb;
	e->menudata->menu_cwhite_cb = engine_local_cwhite_cb;
	e->menudata->menu_cblack_cb = engine_local_cblack_cb;

	enable_all_menus();
	uncheck_all_menus();
	disable_menu(MENU_FLAG);
	disable_menu(MENU_DRAW);
	disable_menu(MENU_RESIGN);
	check_menu(MENU_CBLACK);
}

static void engine_local_move(char *p)
{
	    int from,to,piece;

	    ascii_to_move(p,&from,&to);
	    if (debug)
	      printf("move detected: %s %d %d\n",p+4,from,to);
	    piece= currPositionPtr->square[from];
	    gnomechess_position_make_move(currPositionPtr,from,to);
	    gnomechess_sound_enginemove();
	    gnomechess_movelist_add(board.movelist, piece,from,to);
	    update_board();
}

static void
engine_local_new_cb (GtkWidget *widget, void *data)
{
  engine_write(first_chess_programm,"new\n");
  gnomechess_position_set_initial(currPositionPtr);
  gnomechess_movelist_clear(board.movelist);
  update_board();
}

static void engine_local_takeback_cb (GtkWidget *widget, void *data) {
	int curr;

	curr = gnomechess_movelist_maxply(board.movelist);

	if (!(board.mode == COMPUTER_BLACK) && !(board.mode == COMPUTER_WHITE)) {
		engine_write(first_chess_programm,"undo\n");
	} else {
		if ((board.mode == COMPUTER_BLACK && (curr % 2) == 0) ||
				(board.mode == COMPUTER_WHITE && (curr % 2) == 1)) {
			engine_write(first_chess_programm,"remove\n");
			curr--;
		} else {
			engine_write(first_chess_programm,"undo\n");
			engine_write(first_chess_programm,"go\n");
		}
	}

	gnomechess_movelist_clear_from(board.movelist, curr);
	update_board();
}

static void
engine_local_flag_cb (GtkWidget *widget, void *data)
{

}

static void
engine_local_draw_cb (GtkWidget *widget, void *data)
{
}

static void engine_local_resign_cb (GtkWidget *widget, void *data) {
}

static void engine_local_start_cb (GtkWidget *widget, void *data) {
  gnomechess_movelist_move_start(board.movelist);
  update_board();
  return;
}

static void engine_local_previous_cb (GtkWidget *widget, void *data) {
  gnomechess_movelist_move_back(board.movelist);
  update_board();
  return;
}

static void engine_local_next_cb (GtkWidget *widget, void *data) {
  gnomechess_movelist_move_forward(board.movelist);
  update_board();
  return;
}

static void engine_local_end_cb (GtkWidget *widget, void *data) {
  gnomechess_movelist_move_end(board.movelist);
  update_board();
}

static void engine_local_now_cb (GtkWidget *widget, void *data) {
  engine_write(first_chess_programm,"?\n");
}

static void engine_local_go_cb (GtkWidget *widget, void *data) {
  engine_write(first_chess_programm,"go\n");
}

static void engine_local_cwhite_cb (GtkWidget *widget, void *data) {
	engine_write(first_chess_programm,"white\n");
	if (currPositionPtr->amzug == WMOVE)
		engine_write(first_chess_programm,"go\n");
	set_flip(TRUE);
	update_board();
}

static void engine_local_cblack_cb (GtkWidget *widget, void *data) {
	engine_write(first_chess_programm,"black\n");
	if (currPositionPtr->amzug == BMOVE)
		engine_write(first_chess_programm,"go\n");
	set_flip(FALSE);
	update_board();
}

void engine_local_cb( gpointer data, gint source, GdkInputCondition condition)
{
  static char buf[1024];
  static char *b=buf;

  char *p,*q;
  ssize_t len;

  len = read(source, b, sizeof buf - 1 - (b-buf));
  if (len > 0) 
    {
      b[len] = 0;
      b += len;
    }

  while(1)
    {
      char tmp;

      q = strchr(buf,'\n');
      if ( q == NULL) break;
      tmp = *(q+1);
      *(q+1) = 0;

      if (debug)
       fputs(buf,stderr);

      gtk_text_insert (GTK_TEXT(board.messages), NULL,
                    0,
		    NULL,
                    buf, -1);
      *q=0;
      *(q+1) = tmp;

      // parse for  NUMBER ... MOVE  
  
      if (isdigit(*buf))
	if ((p = strstr(buf,"...")))
	    engine_local_move(p+4);

      // parse for move MOVE
      if (!strncmp("move",buf,4))
	    engine_local_move(buf+5);

      memmove( buf, q+1, sizeof(buf) - ( q + 1 - buf));
      b -= (q + 1 - buf );
    }
}
 
