#include <config.h>
#include <gnome.h>
#include "engine.h"
#include "menu.h"

static GtkWidget *move_entry;
static GtkWidget *time_entry;


static int callback(GtkWidget *widget, gint page, GtkWidget *window)
{
  gchar *move, *ti, *s;

  if ( page != 0) return FALSE;

  move = gtk_entry_get_text(GTK_ENTRY(move_entry));
  ti = gtk_entry_get_text(GTK_ENTRY(time_entry));
  s = g_strconcat("level ",move," ",ti," 0\n",NULL);
  engine_write(first_chess_programm,s);
  g_free(s);
  return TRUE;
}

static void
properties_modified_cb (GtkWidget * widget, GnomePropertyBox * pbox)
{
  gnome_property_box_changed (pbox);
}


void
level_cb (GtkWidget *widget, void *data)

{

    GtkWidget *pbox;
    GtkWidget *vbox;
    GtkWidget *entry;

    pbox = gnome_property_box_new ();
    gtk_signal_connect (GTK_OBJECT (pbox), "destroy",
			GTK_SIGNAL_FUNC (gtk_object_destroy), pbox);

    gtk_signal_connect (GTK_OBJECT (pbox), "apply",
			GTK_SIGNAL_FUNC (callback), pbox);



    vbox = gtk_vbox_new (FALSE, 0);
    gtk_container_add (GTK_CONTAINER (GNOME_PROPERTY_BOX (pbox)->notebook), vbox);

    entry = gtk_label_new(_("Number of moves:"));
    gtk_box_pack_start (GTK_BOX (vbox), entry, TRUE, TRUE, 0);
    gtk_widget_show (entry);

    move_entry = gtk_entry_new_with_max_length (4);
    gtk_entry_set_text (GTK_ENTRY (move_entry), "60");
    gtk_box_pack_start (GTK_BOX (vbox), move_entry, TRUE, TRUE, 0);
    gtk_widget_show (move_entry);

    entry = gtk_label_new(_("Time in minutes:"));
    gtk_box_pack_start (GTK_BOX (vbox), entry, TRUE, TRUE, 0);
    gtk_widget_show (entry);

    time_entry = gtk_entry_new_with_max_length (4);
    gtk_entry_set_text (GTK_ENTRY (time_entry), "2");
    gtk_box_pack_start (GTK_BOX (vbox), time_entry, TRUE, TRUE, 0);
    gtk_widget_show (time_entry);
    gtk_widget_show (vbox);
    gtk_widget_show(pbox);

    gtk_signal_connect (GTK_OBJECT (move_entry), "changed",
		      GTK_SIGNAL_FUNC (properties_modified_cb), pbox);
    gtk_signal_connect (GTK_OBJECT (time_entry), "changed",
		      GTK_SIGNAL_FUNC (properties_modified_cb), pbox);

    return;
}
