/* engine.c */

#include "gnome_chess.h"
#include <ctype.h>
#include <sys/time.h>
#include <stdarg.h>
#include <signal.h>

#include "makros.h"
#include "portab.h"
#include "child.h"
#include "cho1.h"
#include "pro.h"
#include "movlist.h"
#include "position.h"

static GSList *engines=NULL;

struct engine * engine_new(char *cmd, char **arg)
{
  struct engine *e;

  e = malloc( sizeof(struct engine));
  e->notation = COORD;
  e->menudata = malloc(sizeof(struct engine_menu));
  e->menudata->menu_init = NULL;
  e->menudata->menu_new_cb = NULL;
  e->menudata->menu_flag_cb = NULL;
  e->menudata->menu_draw_cb = NULL;
  e->menudata->menu_resign_cb = NULL;
  e->menudata->menu_start_cb = NULL;
  e->menudata->menu_previous_cb = NULL;
  e->menudata->menu_next_cb = NULL;
  e->menudata->menu_end_cb = NULL;
  e->menudata->menu_now_cb = NULL;
  e->menudata->menu_cwhite_cb = NULL;
  e->menudata->menu_cblack_cb = NULL;
  e->menudata->menu_twop_cb = NULL;
  e->menudata->menu_twoc_cb = NULL;
  e->menudata->menu_analyze_cb = NULL;

  e->data = NULL;
  start_child(cmd, arg, &e->read_from, &e->write_to, &e->childpid);

  engines = g_slist_append(engines,e);

  return e;
}

void engine_write(struct engine *e, char *format,...)
{
  FILE *file= e->write_to;

  va_list ap;
  va_start(ap,format);
  vfprintf(file,format,ap);
  if (debug)
    vfprintf(stderr,format,ap);  
  va_end(ap);
}

static void position_to_engine(void)
{
  int i;
  char s[10];
  char *p;

  engine_write(first_chess_programm,"edit\n");
  engine_write(first_chess_programm,"#\n");

  for (i=A1; i<= H8;i++)
    {
      p = s;
      switch (currPositionPtr->square[i])
	{
	case WP:  *p++='P';break;
	case WN:  *p++='N';break;
	case WB:  *p++='B';break;
	case WR:  *p++='R';break;
	case WQ:  *p++='Q';break;
	case WK:  *p++='K';break;
	default:   continue;
	}

      *p++   = i - i / 10 * 10 + 96;   /*  a - h       */
      *p++   = i / 10 + 47 ;              /*  1 - 8       */
      *p=0;
      printf("%s\n",s);  
      engine_write(first_chess_programm,"%s\n",s);  
    }

  engine_write(first_chess_programm,"c\n");  
  
  for (i=A1; i<= H8;i++)
    {
      p = s;
      switch (currPositionPtr->square[i])
	{
	case BP:  *p++='P';break;
	case BN:  *p++='N';break;
	case BB:  *p++='B';break;
	case BR:  *p++='R';break;
	case BQ:  *p++='Q';break;
	case BK:  *p++='K';break;
	default:   continue;
	}

      *p++   = i - i / 10 * 10 + 96;   /*  a - h       */
      *p++   = i / 10 + 47 ;              /*  1 - 8       */
      *p=0;
      printf("%s\n",s);  
      engine_write(first_chess_programm,"%s\n",s);  
    }

  engine_write(first_chess_programm,".\n");
}

void engine_write_move(int from, int to) {
  char s[100];
  char *str = NULL;

  if (gnomechess_movelist_currply(board.movelist) != gnomechess_movelist_maxply(board.movelist))
       position_to_engine();

  if (first_chess_programm->notation) {
	move_to_ascii(s,from,to);
	engine_write(first_chess_programm,"%s\n",s);
  } else {
	str = move_to_san(currPositionPtr,from, to);
	engine_write(first_chess_programm,"%s\n",str);
  	free(str);
  }
}

void engine_destroy_all() {
	int i;
	int n = g_slist_length(engines);
	struct engine *e;

	for (i=0;i<n;i++) {
		e = (struct engine *)g_slist_nth_data (engines,i);

		if (e->data)
			free(e->data);
		stop_child(e->childpid);
	}
}

  
