/* 
 * Copyright (C) 1999 JP Rosevear
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#ifndef ENGINE_H
#define ENGINE_H

#include <stdarg.h>
#include <stdio.h>

struct engine;

struct engine_menu{
	void (*menu_init) (struct engine *e);
	void (*menu_new_cb) (GtkWidget *widget, void *data);
	void (*menu_flag_cb) (GtkWidget *widget, void *data);
	void (*menu_draw_cb) (GtkWidget *widget, void *data);
	void (*menu_resign_cb) (GtkWidget *widget, void *data);
	void (*menu_start_cb) (GtkWidget *widget, void *data);
	void (*menu_previous_cb) (GtkWidget *widget, void *data);
	void (*menu_next_cb) (GtkWidget *widget, void *data);
	void (*menu_end_cb) (GtkWidget *widget, void *data);
	void (*menu_takeback_cb) (GtkWidget *widget, void *data);
	void (*menu_now_cb) (GtkWidget *widget, void *data);
	void (*menu_go_cb) (GtkWidget *widget, void *data);
	void (*menu_cwhite_cb) (GtkWidget *widget, void *data);
	void (*menu_cblack_cb) (GtkWidget *widget, void *data);
	void (*menu_twop_cb) (GtkWidget *widget, void *data);
	void (*menu_twoc_cb) (GtkWidget *widget, void *data);
	void (*menu_analyze_cb) (GtkWidget *widget, void *data);
}; 

struct engine { 
	FILE *read_from;
	FILE *write_to;
	pid_t childpid;
	int notation;
	struct engine_menu *menudata;
	void *data;
};

extern struct engine *first_chess_programm;

struct engine * engine_new(char *cmd, char **arg);
int engine_destroy( struct engine *e);
void engine_destroy_all(void);

#ifdef __GNUC__
void engine_write(struct engine *, char *format,...) __attribute__ (( __format__(printf,2,3)));
#else
void engine_write(struct *engine, char *format,...); 
#endif

void engine_write_move(int from, int to);

/* Now some prototypes for the various engines */
void engine_local_cb( gpointer data, gint source, GdkInputCondition condition);

#endif
