/* 
 * Copyright (C) 1999 JP Rosevear
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#include "../config.h"
#include "gnome_chess.h"
#include "portab.h"
#include "makros.h"
#include "position.h"
#include "pro.h"
#include "pgn.h"
 
#ifdef CHESS_ENGINE_CRAFTY
#define     FIRST_CHESS_PROGRAMM CHESS_ENGINE_CRAFTY
#define     FIRST_CHESS_PROGRAMM_ARG "xboard"
#else
#ifdef CHESS_ENGINE_GNUCHESS
#define     FIRST_CHESS_PROGRAMM CHESS_ENGINE_GNUCHESS
#define     FIRST_CHESS_PROGRAMM_ARG NULL
#endif
#endif
#define TELNET_PROGRAM telnet

struct engine *first_chess_programm;

/* The debugging level */
int debug = 0;

GtkWidget *app;
static gint *ics = 0;
static char *icshost = NULL;
static char *icsuser = NULL;
static char *icspass = NULL;
static char *icsport = NULL;
static char *icstelnetprogram = NULL;
static char *fcp = NULL;
static char **startup_files = NULL;

static poptContext ctx;

static const struct poptOption gnome_chess_popt_options [] = {
	{ "debug", '\0', POPT_ARG_INT, &debug, 0,
	  N_("Enables some debugging functions"), N_("LEVEL") },
	{ "fcp", '\0', POPT_ARG_STRING, &fcp, 0,
	  N_("First Chess Programm"),   N_("FILE") },
	{ "ics", '\0', POPT_ARG_NONE, &ics, 0,
	  N_("Start in ICS mode"), NULL },
	{ "icshost", '\0', POPT_ARG_STRING, &icshost, 0,
	  N_("ICS Server"), N_("SERVER") },
	{ "icsuser", '\0', POPT_ARG_STRING, &icsuser, 0,
	  N_("ICS User"), N_("USERNAME") },
	{ "icspass", '\0', POPT_ARG_STRING, &icspass, 0,
	  N_("ICS Password"), N_("PASSWORD") },
	{ "icsport", '\0', POPT_ARG_STRING, &icsport, 0,
	  N_("ICS Port"), N_("PORT") },
	{ "icstelnetprogram", '\0', POPT_ARG_STRING, &icstelnetprogram, 0,
	  N_("ICS Telnet Programm"), N_("TELNET") },

	{ NULL, '\0', 0, NULL, 0 }
};

int main(int argc,char *argv[])
{
     GtkWidget *box;

     bindtextdomain (PACKAGE, GNOMELOCALEDIR);
     textdomain (PACKAGE);

     gnome_init_with_popt_table ("Gnome Chess", VERSION, argc, argv, gnome_chess_popt_options,0, &ctx);

	 currPositionPtr = gnomechess_position_new_initial();

     //pgn_test(); 

     app = gnome_app_new ("gnome-chess", _("Gnome Chess"));

     create_menus();

     box = gnomechess_board_new();
     gnome_app_set_contents ( GNOME_APP (app), box);

     gtk_widget_show(box);
     gtk_widget_show (app);

     gnomechess_prefs_init();

     if (ics) {
       first_chess_programm = engine_ics_new(icshost, icsuser, icspass, icsport, icstelnetprogram);
     } else if (fcp) {
       first_chess_programm = engine_local_new(fcp,NULL);
     } else {
       first_chess_programm = engine_local_new(FIRST_CHESS_PROGRAMM,FIRST_CHESS_PROGRAMM_ARG);
	 }

     startup_files = poptGetArgs (ctx);
     if (startup_files) 
       pgn_open(*startup_files);
     
     poptFreeContext (ctx);


     gtk_main ();


     return 0;
}

