/* 
 * Copyright (C) 1999 Robert Wilhelm
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#include <glib.h>

#include "portab.h"
#include "makros.h"
#include "position.h"
#include "pro.h"

static const int jump[]={ 8, 12,19, 21,-8,-12,-19,-21,     
                   9, 11,-9,-11, 1, 10,-10, -1,     
                   9, 11, 1, 10,-1,  1, 10, -1,
                  -9,-11, 1,-10,-1     };

static BYTE *index,*sindex;

static void sdouble(WORD af,WORD a,WORD b);
static void wdouble(WORD af,WORD a,WORD b);
static void neuer_zug(WORD von,WORD nach);
static void neuer_szug(WORD von,WORD nach);
static void s_ro_l(void);
static void s_ro_k(void);
static void w_ro_k(void);
static void w_ro_l(void);

static void wpawn2(WORD af);
static void wpawn3(WORD af);
static void wpawn5(WORD af);
static void wpawn7(WORD af);
static void wb_um2(WORD af,WORD ef);
static void wknight(WORD af);
static void wbishop(WORD af);
static void wrook(WORD af);
static void wqueen(WORD af);
static void wking(WORD af);
static void wkingro(WORD af);

static void bpawn7(WORD af);
static void bpawn6(WORD af);
static void bpawn4(WORD af);
static void bpawn2(WORD af);
static void sb_um2(WORD af,WORD ef);
static void sknight(WORD af);
static void sbishop(WORD af);
static void srook(WORD af);
static void squeen(WORD af);
static void skingro(WORD af);
static void sking(WORD af);



static void inline neuer_zug(WORD von,WORD nach)
{

   *   index          = (BYTE) von;
   * ( index + 1 )    = (BYTE) nach;
       index         += 2;
}

static void wpawn2(WORD af)      
{
   register WORD ef;

    ef = af + 10;    
    if (currPositionPtr->square[ef] == EMPTY ) {
        neuer_zug(af,ef);
        ef = af + 20;
        if (currPositionPtr->square[ef] == EMPTY ) {
            neuer_zug(af,ef);
        }
    }
    if (BPIECE(currPositionPtr->square[af + 9 ])) neuer_szug(af,af+9);
    if (BPIECE(currPositionPtr->square[af +11 ])) neuer_szug(af,af+11);
}

static void wpawn3(WORD af)  
{
   register WORD ef;

     ef = af + 10;
     if ( currPositionPtr->square[ef] == EMPTY ) neuer_zug(af,ef);

     if ( BPIECE( currPositionPtr->square[af + 9 ] ) ) neuer_szug(af, af + 9 );
     if ( BPIECE( currPositionPtr->square[af +11 ] ) ) neuer_szug(af, af + 11 );
}

static void wpawn5(WORD af)   
{

   wpawn3(af);

   if ( ( af - 1 ) == currPositionPtr->ep )  
       neuer_szug(af,af+9);
   else
   if ( ( af + 1 ) == currPositionPtr->ep )  
     neuer_szug(af,af+11);
}

static void  wpawn7(WORD af)
{
register WORD ef;

   ef = af + 10;
   if (currPositionPtr->square[ef] == EMPTY ) wb_um2(af,ef);

   if (BPIECE( currPositionPtr->square[af + 9] )) wb_um2( af , af + 9);
   if (BPIECE( currPositionPtr->square[af +11] )) wb_um2 (af , af +11);

}
static void wb_um2(WORD af,WORD ef)
{
register WORD b,i;

        for (i=2;i<6;i++) {
                b = 128 + 8 * i + ef - A8;
                neuer_szug(af,b);
        }
}
static void wknight(WORD af)
{
   register WORD a,fi,bb;

   for (a = 0 ; a < 8;a++) {
      bb=af+jump[a];
      fi=currPositionPtr->square[bb];

      switch (fi) {
         case EMPTY:  neuer_zug(af,bb);break;
         case BORDER:  break;

         default  :  if (BPIECE(fi)) neuer_szug(af,bb);
      }
   }
}

static void wbishop(WORD af)
{
   WORD a = 8,
        b = 12;

   wdouble(af,a,b);
}

static void wrook(WORD af)
{
   WORD a = 12,
        b = 16;

   wdouble(af,a,b);
}

static void wqueen(WORD af)
{
   WORD a = 8,
        b = 16;

   wdouble(af,a,b);
}

static void wking(WORD af)
{
register WORD a;
register WORD fi,bb;

   for (a = 8; a < 16 ; a++) {
      bb=af+jump[a];
      fi=currPositionPtr->square[bb];

      switch (fi) {
         case EMPTY:  neuer_zug(af,bb);break;
         case BORDER:  break;

         default  :  if (BPIECE(fi)) neuer_szug(af,bb);
      }
   }
}

static void wkingro(WORD af)  
{
register WORD a;
register WORD fi,bb;

   for (a = 8; a < 16 ; a++) {
      bb=af+jump[a];
      fi=currPositionPtr->square[bb];

      switch (fi) {
         case EMPTY:  neuer_zug(af,bb);break;
         case BORDER:  break;

         default  :  if (BPIECE(fi)) neuer_szug(af,bb);
      }
   }

   if ( currPositionPtr->wki != E1) return;
   if ( ! currPositionPtr->wth ) w_ro_k();  
   if ( ! currPositionPtr->wta ) w_ro_l();  
}
static void w_ro_k(void)
{
  if ( currPositionPtr->square[F1] == EMPTY &&
       currPositionPtr->square[G1] == EMPTY &&
       currPositionPtr->square[H1] == WR)
    neuer_zug(E1,G1);

}
static void w_ro_l(void)
{
  if (currPositionPtr->square[D1] == EMPTY &&
      currPositionPtr->square[C1] == EMPTY &&
      currPositionPtr->square[B1] == EMPTY &&
      currPositionPtr->square[A1] == WR) 
    neuer_zug(E1,C1);
}
static void wdouble(WORD af,WORD a,WORD b)   
{
        WORD jp,
             ef = af,
             fi;

        for ( ; a < b ; a ++ )
        {
                ef = af;
                jp = jump[a];

                do {
                        ef += jp;
                        fi  = currPositionPtr->square[ef];

                        if ( fi == EMPTY )   neuer_zug(af,ef);
                else    if ( fi == BORDER )   break;
                else    if ( BPIECE(fi) ) { neuer_szug(af,ef);break; }
                else    break;
                }       while ( TRUE );
        }
}

static void bpawn7(WORD af)      
{
   register WORD ef;

    ef = af - 10;                
    if (currPositionPtr->square[ef] == EMPTY ) {
        neuer_zug(af,ef);
        ef = af - 20;            
        if (currPositionPtr->square[ef] == EMPTY ) {
            neuer_zug(af,ef);
        }
    }


    if (WPIECE(currPositionPtr->square[af - 9 ])) neuer_szug(af,af-9);
    if (WPIECE(currPositionPtr->square[af -11 ])) neuer_szug(af,af-11);
}

static void bpawn6(WORD af)                
{
   register WORD ef;

     ef = af - 10;
     if ( currPositionPtr->square[ef] == EMPTY ) neuer_zug(af,ef);

     if ( WPIECE( currPositionPtr->square[af - 9 ] ) ) neuer_szug(af, af - 9 );
     if ( WPIECE( currPositionPtr->square[af -11 ] ) ) neuer_szug(af, af - 11 );
}

static void bpawn4(WORD af)         
{
   bpawn6(af);

   if (( af - 1) == currPositionPtr->ep )   
     neuer_szug( af, af-11);
   if (( af + 1) == currPositionPtr->ep ) 
     neuer_szug( af, af-9);
}

static void  bpawn2(WORD af)  
{
register WORD ef;

   ef = af - 10;
   if (currPositionPtr->square[ef] == EMPTY ) sb_um2(af,ef);


   if (WPIECE( currPositionPtr->square[af - 9] )) sb_um2( af , af - 9);
   if (WPIECE( currPositionPtr->square[af -11] )) sb_um2 (af , af -11);

}
static void sb_um2(WORD af,WORD ef)    
{
register WORD b,i;
 for (i=2;i<6;i++)
   {
     b = 128 + 8 * i + ef - A1;
     neuer_szug(af,b);
   }
}
static void sknight(WORD af)
{
   register WORD a,fi,bb;

   for (a = 0 ; a < 8;a++) {
      bb=af+jump[a];
      fi=currPositionPtr->square[bb];

      switch (fi) {
         case EMPTY:  neuer_zug(af,bb);break;
         case BORDER:  break;

         default  :  if (WPIECE(fi)) neuer_szug(af,bb);
      }
   }
}

static void sbishop(WORD af)
{
   WORD a=8,
        b=12;

   sdouble(af,a,b);
}

static void srook(WORD af)
{
   WORD a = 12,
        b = 16;

   sdouble(af,a,b);
}

static void squeen(WORD af)
{
   WORD a=8,
        b=16;

   sdouble(af,a,b);
}

static void sking(WORD af)
{
register WORD a;
register WORD fi,bb;

   for (a = 8; a < 16 ; a++) {
      bb=af+jump[a];
      fi=currPositionPtr->square[bb];

      switch (fi) {
         case EMPTY:  neuer_zug(af,bb);break;
         case BORDER:  break;

         default  :  if (WPIECE(fi)) neuer_szug(af,bb);
      }
   }
}

static void skingro(WORD af)     
{
register WORD a;
register WORD fi,bb;

   for (a = 8; a < 16 ; a++) {
      bb=af+jump[a];
      fi=currPositionPtr->square[bb];

      switch (fi) {
         case EMPTY:  neuer_zug(af,bb);break;
         case BORDER:  break;

         default  :  if (WPIECE(fi)) neuer_szug(af,bb);
      }
   }

   if ( currPositionPtr->ski != E8) return;
   if ( ! currPositionPtr->sth ) s_ro_k();  
   if ( ! currPositionPtr->sta ) s_ro_l();  
}
static void s_ro_k(void)
{

  if ( currPositionPtr->square[F8] == EMPTY &&
       currPositionPtr->square[G8] == EMPTY && 
       currPositionPtr->square[H8] == BR)
    neuer_zug(E8,G8);

}
static void s_ro_l(void)
{
  if (currPositionPtr->square[D8] == EMPTY &&
      currPositionPtr->square[C8] == EMPTY &&
      currPositionPtr->square[B8] == EMPTY &&
      currPositionPtr->square[A8] == BR) 
    neuer_zug(E8,C8);
}
static void sdouble(WORD af,WORD a,WORD b)  
{
        WORD jp,
             ef = af,
             fi;

        for ( ; a < b ; a ++ )
        {
                ef = af;
                jp = jump[a];

                do
                {
                        ef += jp;
                        fi  = currPositionPtr->square[ef];

                        if ( fi == EMPTY )   neuer_zug(af,ef);
                else    if ( fi == BORDER )   break;
                else    if ( WPIECE(fi) ) { neuer_szug(af,ef);break; }
                else    break;
                }       while ( TRUE );
        }
}

static void neuer_szug(WORD von,WORD nach)  
{
               sindex       -= 2;
            *  sindex        = (BYTE) von;
            * (sindex + 1 )  = (BYTE) nach;
}

static int movgen_white(BYTE **index0,WORD *anz_s,WORD *anz_n)
{
   register WORD af,figur;

   index = sindex = *index0;

      for( af = A1 ; af <= H1 ; af++ ) {
         figur = currPositionPtr->square[af];
            if ( WPIECE(figur)) { 
               switch (figur)   {
                  case    WP: abort();          break;
                  case    WN: wknight(af);       break;
                  case    WB: wbishop(af);         break;
                  case    WR: wrook(af);            break;
                  case    WQ: wqueen(af);            break;
                  case    WK: wkingro(af);        break;
               }
            }
      }

      for( af = A2 ; af <= H2 ; af++ ) {
         figur = currPositionPtr->square[af];
            if ( WPIECE(figur)) { 
               switch (figur)   {
                  case    WP: wpawn2(af);          break;
                  case    WN: wknight(af);        break;
                  case    WB: wbishop(af);         break;
                  case    WR: wrook(af);            break;
                  case    WQ: wqueen(af);            break;
                  case    WK: wking(af);          break;
               }
            }
      }

      for( af = A3 ; af <= H3 ; af++ ) {
         figur = currPositionPtr->square[af];
            if ( WPIECE(figur)) { 
               switch (figur)   {
                  case    WP: wpawn3(af);          break;
                  case    WN: wknight(af);        break;
                  case    WB: wbishop(af);         break;
                  case    WR: wrook(af);            break;
                  case    WQ: wqueen(af);            break;
                  case    WK: wking(af);          break;
               }
            }
      }
      for( af = A4 ; af <= H4 ; af++ ) {
         figur = currPositionPtr->square[af];
            if ( WPIECE(figur)) {
               switch (figur)   {
                  case    WP: wpawn3(af);          break;
                  case    WN: wknight(af);        break;
                  case    WB: wbishop(af);         break;
                  case    WR: wrook(af);            break;
                  case    WQ: wqueen(af);            break;
                  case    WK: wking(af);          break;
               }
            }
      }
      for( af = A5 ; af <= H5 ; af++ ) {
         figur = currPositionPtr->square[af];
            if ( WPIECE(figur)) {
               switch (figur)   {
                  case    WP: wpawn5(af);          break;
                  case    WN: wknight(af);        break;
                  case    WB: wbishop(af);         break;
                  case    WR: wrook(af);            break;
                  case    WQ: wqueen(af);            break;
                  case    WK: wking(af);          break;
               }
            }
      }
      for( af = A6 ; af <= H6 ; af++ ) {
         figur = currPositionPtr->square[af];
            if ( WPIECE(figur)) {
               switch (figur)   {
                  case    WP: wpawn3(af);          break;
                  case    WN: wknight(af);        break;
                  case    WB: wbishop(af);         break;
                  case    WR: wrook(af);            break;
                  case    WQ: wqueen(af);            break;
                  case    WK: wking(af);          break;
               }
            }
      }
      for( af = A7 ; af <= H7 ; af++ ) {
         figur = currPositionPtr->square[af];
            if ( WPIECE(figur)) {
               switch (figur)   {
                  case    WP: wpawn7(af);          break;
                  case    WN: wknight(af);        break;
                  case    WB: wbishop(af);         break;
                  case    WR: wrook(af);            break;
                  case    WQ: wqueen(af);            break;
                  case    WK: wking(af);          break;
               }
            }
      }
      for( af = A8 ; af <= H8 ; af++ ) {
         figur = currPositionPtr->square[af];
            if ( WPIECE(figur)) {
               switch (figur)   {
                  case    WP: abort();          break;
                  case    WN: wknight(af);        break;
                  case    WB: wbishop(af);         break;
                  case    WR: wrook(af);            break;
                  case    WQ: wqueen(af);            break;
                  case    WK: wking(af);          break;
               }
            }
         }

      *anz_n = (WORD) (( index  - *index0) / 2) ;
      *anz_s = (WORD) (( *index0 - sindex) / 2 );

      af = *anz_n + *anz_s ;
      *index0 = sindex;

      return af;
}

static int movgen_black(BYTE **index0,WORD *anz_s,WORD *anz_n)
{
   register WORD af,figur;

   index = sindex = *index0;

      for( af = A1 ; af <= H1 ; af++ ) {
         figur = currPositionPtr->square[af];
            if (BPIECE(figur)) {
               switch (figur) {
                  case   BP: abort();          break;
                  case   BN: sknight(af);        break;
                  case   BB: sbishop(af);         break;
                  case   BR: srook(af);            break;
                  case   BQ: squeen(af);            break;
                  case   BK: sking(af);        break;
               }
            }
      }
      for( af = A2 ; af <= H2 ; af++ ) {
         figur = currPositionPtr->square[af];
            if (BPIECE(figur)) {
               switch (figur) {
                  case   BP: bpawn2(af);          break;
                  case   BN: sknight(af);        break;
                  case   BB: sbishop(af);         break;
                  case   BR: srook(af);            break;
                  case   BQ: squeen(af);            break;
                  case   BK: sking(af);          break;
               }
            }
      }
      for( af = A3 ; af <= H3 ; af++ ) {
         figur = currPositionPtr->square[af];
            if (BPIECE(figur)) {
               switch (figur) {
                  case   BP: bpawn6(af);          break;
                  case   BN: sknight(af);        break;
                  case   BB: sbishop(af);         break;
                  case   BR: srook(af);            break;
                  case   BQ: squeen(af);            break;
                  case   BK: sking(af);          break;
               }
            }
      }
      for( af = A4 ; af <= H4 ; af++ ) {
         figur = currPositionPtr->square[af];
            if (BPIECE(figur)) {
               switch (figur) {
                  case   BP: bpawn4(af);          break;
                  case   BN: sknight(af);        break;
                  case   BB: sbishop(af);         break;
                  case   BR: srook(af);            break;
                  case   BQ: squeen(af);            break;
                  case   BK: sking(af);          break;
               }
            }
      }
      for( af = A5 ; af <= H5 ; af++ ) {
         figur = currPositionPtr->square[af];
            if (BPIECE(figur)) {
               switch (figur) {
                  case   BP: bpawn6(af);          break;
                  case   BN: sknight(af);        break;
                  case   BB: sbishop(af);         break;
                  case   BR: srook(af);            break;
                  case   BQ: squeen(af);            break;
                  case   BK: sking(af);          break;
               }
            }
      }
      for( af = A6 ; af <= H6 ; af++ ) {
         figur = currPositionPtr->square[af];
            if (BPIECE(figur)) {
               switch (figur) {
                  case   BP: bpawn6(af);          break;
                  case   BN: sknight(af);        break;
                  case   BB: sbishop(af);         break;
                  case   BR: srook(af);            break;
                  case   BQ: squeen(af);            break;
                  case   BK: sking(af);          break;
               }
            }
      }
      for( af = A7 ; af <= H7 ; af++ ) {
         figur = currPositionPtr->square[af];
            if (BPIECE(figur)) {
               switch (figur) {
                  case   BP: bpawn7(af);          break;
                  case   BN: sknight(af);        break;
                  case   BB: sbishop(af);         break;
                  case   BR: srook(af);            break;
                  case   BQ: squeen(af);            break;
                  case   BK: sking(af);          break;
               }
            }
      }
      for( af = A8 ; af <= H8 ; af++ ) {
         figur = currPositionPtr->square[af];
            if (BPIECE(figur)) {
               switch (figur) {
                  case   BP: abort();          break;
                  case   BN: sknight(af);        break;
                  case   BB: sbishop(af);         break;
                  case   BR: srook(af);            break;
                  case   BQ: squeen(af);            break;
                  case   BK: skingro(af);          break;
               }
            }
      }

      *anz_n = (WORD) (( index  - *index0) / 2) ;
      *anz_s = (WORD) (( *index0 - sindex) / 2 );
     
      af = *anz_n + *anz_s ;
      *index0 = sindex;

      return af;
}


int  move_generator(BYTE **index0,WORD *anz_s,WORD *anz_n)
{

	if (currPositionPtr->tomove == WMOVE ) 
		return movgen_white(index0,anz_s,anz_n);
	else if (currPositionPtr->tomove == BMOVE ) 
		return  movgen_black(index0,anz_s,anz_n);
    else
        abort();


}
