/* 
 * Copyright (C) 1999 Robert Wilhelm
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#include <gnome.h>

#include <stdio.h>
#include <string.h>
#include "makros.h"
#include "position.h"
#include "pro.h"
#include "disk.h"
#include "ckis.h"

static gshort reg_zug_umw(gshort nach,gshort n1,gshort n2,gshort n3,gshort n4);

gshort reg_zug(gshort from,gshort to)
{
   gshort anz,anz_n,anz_s,ret;
   gshort i;
   gchar *ap;
   gchar *aq;
   gchar zugliste[AB_ZUGL];

  ap =  zugliste + AB_ZUG_S;
  anz = legal_move(&ap,&anz_s,&anz_n);

  for ( aq = ap , i = 0 ; i < anz ; i++ , aq += 2 ) 
  {
         if (from == *aq) 
         {
                if (to ==  *(aq+1)) return to;
                else 
                {
                     if (*(aq+1) < 0)  
                     { /* Promotion */
                        ret =reg_zug_umw
                             (to,*(aq+1),*(aq+3),*(aq+5),*(aq+7));
                        if (ret) return ret;
                        aq += 6;        /*      skip 3 moves */
                     }
                }
        }
  }
  return FALSE;
}

static int promotion_dialog()
{
  int ret;
  GtkWidget *dialog;
  GtkWidget *label;

  label = gtk_label_new ("Promotion into which piece?");
  dialog = gnome_dialog_new ("Promotion","Queen","Rook","Bishop","Knight", NULL);
  gnome_dialog_set_default(GNOME_DIALOG (dialog),0);
  gtk_box_pack_start (GTK_BOX (GNOME_DIALOG (dialog)->vbox), label, TRUE, TRUE, 0);
  gtk_widget_show (label);
  ret = gnome_dialog_run(GNOME_DIALOG (dialog));
  gtk_object_destroy (GTK_OBJECT (dialog));
  return ret;
}

static gshort reg_zug_umw(gshort nach,gshort n1,gshort n2,gshort n3,gshort n4)
{
        gchar help;
        gshort fi=0,c;

        if  (currPositionPtr->tomove == WHITE)
                    help = nach - A8;
        else
                    help = nach - A1;


        if ( help == (n1 & 7)) 
        {
	  c= promotion_dialog();
	  if (currPositionPtr->tomove == WHITE) 
	    switch (c) 
	      {
	      case 0 : fi = WQ;break;
	      case 1 : fi = WR;break;
	      case 2 : fi = WB;break;
	      case 3 : fi = WN;break;
	      }
	  else 
	    switch (c) 
	      {
	      case 0 : fi = BQ;break;
	      case 1 : fi = BR;break;
	      case 2 : fi = BB;break;
	      case 3 : fi = BN;break;
	      }

	  if (currPositionPtr->tomove == WHITE)
	    help = 128 + nach - A8 + (fi - WP + 1) * 8;
	  else
	    help = 128 + nach - A1 + (fi - BP + 1) * 8;

	  if (help == n1)
	    return n1;
	  if (help == n2)
	    return n2;
	  if (help == n3)
	    return n3;
	  if (help == n4)
	    return n4;
	  
        }
        return FALSE;
}

gshort legal_move(gchar **zl,gshort *as,gshort *an) {
	position temp;
	gshort a;
	gchar *ap,*ap2;
	gshort anz,anz_s,anz_n,anzahl,check=0;
	gshort amzug = currPositionPtr->tomove;
	gchar zugl[AB_ZUGL];

        ap =  zugl + AB_ZUG_S;
        anz = move_generator(&ap,&anz_s,&anz_n);
        anzahl = 0;
        ap2 = *zl;

        for(a=0;a<anz;a++)
        {

                temp = *currPositionPtr;
                gnomechess_position_move(currPositionPtr, *ap,*(ap+1));

                switch (amzug)
                {
                        case WHITE: check = king_is_attacked_white();
                                  break;
                        case BLACK: check = king_is_attacked_black();
                                  break;
                        default : abort();
                }

                if (!check) {
                        *ap2++=*ap++;
                        *ap2++=*ap++;
                        anzahl++;
                } else {
		        ap+=2;
		}
                switch (amzug) {
                        case WHITE:
                                gnomechess_position_move_reverse_white(currPositionPtr,*(ap-2),*(ap-1));
                                break;
                        case BLACK:
                                gnomechess_position_move_reverse_black(currPositionPtr,*(ap-2),*(ap-1));
                                break;
                }
                *currPositionPtr = temp;
        }
        *as = anzahl;*an=0;
        return anzahl;
}
