/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 8; tab-width: 8 -*- */
/* engine-null.c
 *
 * Copyright (C) 2001  JP Rosevear.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Author: JP Rosevear
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <gnome.h>
#include "engine_null.h"

struct _EngineNullPrivate 
{
};

static EngineClass *parent_class = NULL;

static void class_init (EngineNullClass *klass);
static void init (EngineNull *null);

static void engine_null_fill_menu (EngineNull *engine, GtkMenuShell *shell, gint pos);
static void engine_null_move (EngineNull *engine, gint from, gint to);

GtkType
engine_null_get_type (void)
{
  static GtkType type = 0;

  if (type == 0)
    {
      static const GtkTypeInfo info =
      {
        "EngineNull",
        sizeof (EngineNull),
        sizeof (EngineNullClass),
        (GtkClassInitFunc) class_init,
        (GtkObjectInitFunc) init,
        /* reserved_1 */ NULL,
        /* reserved_2 */ NULL,
        (GtkClassInitFunc) NULL,
      };

      type = gtk_type_unique (engine_get_type (), &info);
    }

  return type;
}

static void
class_init (EngineNullClass *klass)
{
	EngineClass *engine_klass;
	
	engine_klass = ENGINE_CLASS (klass);
	parent_class = gtk_type_class (engine_get_type ());

	engine_klass->engine_fill_menu = (EngineFillMenu) engine_null_fill_menu;
	engine_klass->engine_move = (EngineMove) engine_null_move;
}


static void
init (EngineNull *null)
{
	EngineNullPrivate *priv;

	priv = g_new0 (EngineNullPrivate, 1);

	null->priv = priv;
}



GtkObject *
engine_null_new()
{
	return GTK_OBJECT (gtk_type_new (engine_null_get_type ()));
}

static void
engine_null_fill_menu (EngineNull *engine, GtkMenuShell *shell, gint pos)
{
	if (engine->fill_menu != NULL)
		engine->fill_menu (ENGINE (engine), shell, pos);
}

void 
engine_null_set_fill_menu (EngineNull *engine, EngineFillMenu fill_menu)
{
	engine->fill_menu = fill_menu;
}

static void
engine_null_move (EngineNull *engine, gint from, gint to)
{
	if (engine->move != NULL)
		engine->move (ENGINE (engine), from, to);
}

void 
engine_null_set_move (EngineNull *engine, EngineMove move)
{
	engine->move = move;
}

