/* chess-engine.c generated by valac 0.26.0.79-670a6, the Vala compiler
 * generated from chess-engine.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright (C) 2010-2013 Robert Ancell
 * Copyright (C) 2013-2014 Michael Catanzaro
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include "libchess.h"
#include "portability.h"
#include <unistd.h>
#include <errno.h>
#include <signal.h>
#include <sys/types.h>
#include <string.h>
#include <stdlib.h>


#define TYPE_CHESS_ENGINE (chess_engine_get_type ())
#define CHESS_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_ENGINE, ChessEngine))
#define CHESS_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_ENGINE, ChessEngineClass))
#define IS_CHESS_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_ENGINE))
#define IS_CHESS_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_ENGINE))
#define CHESS_ENGINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_ENGINE, ChessEngineClass))

typedef struct _ChessEngine ChessEngine;
typedef struct _ChessEngineClass ChessEngineClass;
typedef struct _ChessEnginePrivate ChessEnginePrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_io_channel_unref0(var) ((var == NULL) ? NULL : (var = (g_io_channel_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _ChessEngine {
	GObject parent_instance;
	ChessEnginePrivate * priv;
};

struct _ChessEngineClass {
	GObjectClass parent_class;
	void (*process_input) (ChessEngine* self, gchar* data, int data_length1);
	void (*start_game) (ChessEngine* self);
	void (*report_move) (ChessEngine* self, ChessMove* move);
	void (*do_undo) (ChessEngine* self);
	void (*request_move) (ChessEngine* self);
};

struct _ChessEnginePrivate {
	gchar* binary;
	gchar** args;
	gint args_length1;
	gint _args_size_;
	guint delay_seconds;
	guint pending_move_source_id;
	GPid pid;
	gint stdin_fd;
	gint stderr_fd;
	GIOChannel* stdout_channel;
	guint stdout_watch_id;
	gboolean started;
	gboolean _ready;
};


static gpointer chess_engine_parent_class = NULL;

GType chess_engine_get_type (void) G_GNUC_CONST;
#define CHESS_ENGINE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_CHESS_ENGINE, ChessEnginePrivate))
enum  {
	CHESS_ENGINE_DUMMY_PROPERTY,
	CHESS_ENGINE_READY
};
void chess_engine_process_input (ChessEngine* self, gchar* data, int data_length1);
static void chess_engine_real_process_input (ChessEngine* self, gchar* data, int data_length1);
ChessEngine* chess_engine_construct (GType object_type, const gchar* binary, gchar** args, int args_length1, guint delay_seconds);
static gchar** _vala_array_dup19 (gchar** self, int length);
gboolean chess_engine_start (ChessEngine* self);
static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add2 (gchar*** array, int* length, int* size, gchar* value);
static void ___lambda4_ (ChessEngine* self);
static void ____lambda4__gspawn_child_setup_func (gpointer self);
static void chess_engine_engine_stopped_cb (ChessEngine* self, GPid pid, gint status);
static void _chess_engine_engine_stopped_cb_gchild_watch_func (GPid pid, gint status, gpointer self);
static gboolean chess_engine_read_cb (ChessEngine* self, GIOChannel* source, GIOCondition condition);
static gboolean _chess_engine_read_cb_gio_func (GIOChannel* source, GIOCondition condition, gpointer self);
void chess_engine_start_game (ChessEngine* self);
static void chess_engine_real_start_game (ChessEngine* self);
void chess_engine_report_move (ChessEngine* self, ChessMove* move);
static void chess_engine_real_report_move (ChessEngine* self, ChessMove* move);
void chess_engine_do_undo (ChessEngine* self);
static void chess_engine_real_do_undo (ChessEngine* self);
void chess_engine_request_move (ChessEngine* self);
static void chess_engine_real_request_move (ChessEngine* self);
void chess_engine_move (ChessEngine* self);
static gboolean __lambda5_ (ChessEngine* self);
static gboolean ___lambda5__gsource_func (gpointer self);
void chess_engine_undo (ChessEngine* self);
void chess_engine_stop (ChessEngine* self);
void chess_engine_write (ChessEngine* self, gchar* data, int data_length1);
void chess_engine_write_line (ChessEngine* self, const gchar* line);
gboolean chess_engine_get_ready (ChessEngine* self);
void chess_engine_set_ready (ChessEngine* self, gboolean value);
static void chess_engine_finalize (GObject* obj);
static void _vala_chess_engine_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_chess_engine_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static void chess_engine_real_process_input (ChessEngine* self, gchar* data, int data_length1) {
}


void chess_engine_process_input (ChessEngine* self, gchar* data, int data_length1) {
#line 28 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	g_return_if_fail (self != NULL);
#line 28 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	CHESS_ENGINE_GET_CLASS (self)->process_input (self, data, data_length1);
#line 128 "chess-engine.c"
}


static gchar** _vala_array_dup19 (gchar** self, int length) {
	gchar** result;
	int i;
#line 56 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	result = g_new0 (gchar*, length + 1);
#line 56 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	for (i = 0; i < length; i++) {
#line 139 "chess-engine.c"
		gchar* _tmp0_ = NULL;
#line 56 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		_tmp0_ = g_strdup (self[i]);
#line 56 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		result[i] = _tmp0_;
#line 145 "chess-engine.c"
	}
#line 56 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	return result;
#line 149 "chess-engine.c"
}


ChessEngine* chess_engine_construct (GType object_type, const gchar* binary, gchar** args, int args_length1, guint delay_seconds) {
	ChessEngine * self = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	gchar** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	guint _tmp4_ = 0U;
#line 53 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	g_return_val_if_fail (binary != NULL, NULL);
#line 53 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	self = (ChessEngine*) g_object_new (object_type, NULL);
#line 55 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	_tmp0_ = binary;
#line 55 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 55 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	_g_free0 (self->priv->binary);
#line 55 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	self->priv->binary = _tmp1_;
#line 56 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	_tmp2_ = args;
#line 56 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	_tmp2__length1 = args_length1;
#line 56 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	_tmp3_ = (_tmp2_ != NULL) ? _vala_array_dup19 (_tmp2_, _tmp2__length1) : ((gpointer) _tmp2_);
#line 56 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	_tmp3__length1 = _tmp2__length1;
#line 56 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	self->priv->args = (_vala_array_free (self->priv->args, self->priv->args_length1, (GDestroyNotify) g_free), NULL);
#line 56 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	self->priv->args = _tmp3_;
#line 56 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	self->priv->args_length1 = _tmp3__length1;
#line 56 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	self->priv->_args_size_ = self->priv->args_length1;
#line 57 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	_tmp4_ = delay_seconds;
#line 57 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	self->priv->delay_seconds = _tmp4_;
#line 53 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	return self;
#line 196 "chess-engine.c"
}


static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value) {
#line 64 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	if ((*length) == (*size)) {
#line 64 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 64 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 207 "chess-engine.c"
	}
#line 64 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	(*array)[(*length)++] = value;
#line 64 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	(*array)[*length] = NULL;
#line 213 "chess-engine.c"
}


static void _vala_array_add2 (gchar*** array, int* length, int* size, gchar* value) {
#line 65 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	if ((*length) == (*size)) {
#line 65 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 65 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 224 "chess-engine.c"
	}
#line 65 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	(*array)[(*length)++] = value;
#line 65 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	(*array)[*length] = NULL;
#line 230 "chess-engine.c"
}


static void ___lambda4_ (ChessEngine* self) {
#line 72 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	maybe_kill_orphan_engine ();
#line 237 "chess-engine.c"
}


static void ____lambda4__gspawn_child_setup_func (gpointer self) {
#line 70 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	___lambda4_ ((ChessEngine*) self);
#line 244 "chess-engine.c"
}


static void _chess_engine_engine_stopped_cb_gchild_watch_func (GPid pid, gint status, gpointer self) {
#line 81 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	chess_engine_engine_stopped_cb ((ChessEngine*) self, pid, status);
#line 251 "chess-engine.c"
}


static gboolean _chess_engine_read_cb_gio_func (GIOChannel* source, GIOCondition condition, gpointer self) {
	gboolean result;
	result = chess_engine_read_cb ((ChessEngine*) self, source, condition);
#line 93 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	return result;
#line 260 "chess-engine.c"
}


gboolean chess_engine_start (ChessEngine* self) {
	gboolean result = FALSE;
	gchar** argv = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar** _tmp2_ = NULL;
	gint argv_length1 = 0;
	gint _argv_size_ = 0;
	gchar** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	gchar** _tmp8_ = NULL;
	gint _tmp8__length1 = 0;
	gint stdout_fd = 0;
	GPid _tmp16_ = 0;
	gint _tmp17_ = 0;
	GIOChannel* _tmp18_ = NULL;
	GIOChannel* _tmp22_ = NULL;
	GIOChannel* _tmp23_ = NULL;
	guint _tmp24_ = 0U;
	GError * _inner_error_ = NULL;
#line 60 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 62 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	_tmp0_ = self->priv->binary;
#line 62 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 62 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	_tmp2_ = g_new0 (gchar*, 1 + 1);
#line 62 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	_tmp2_[0] = _tmp1_;
#line 62 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	argv = _tmp2_;
#line 62 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	argv_length1 = 1;
#line 62 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	_argv_size_ = argv_length1;
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	_tmp3_ = self->priv->args;
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	_tmp3__length1 = self->priv->args_length1;
#line 304 "chess-engine.c"
	{
		gchar** arg_collection = NULL;
		gint arg_collection_length1 = 0;
		gint _arg_collection_size_ = 0;
		gint arg_it = 0;
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		arg_collection = _tmp3_;
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		arg_collection_length1 = _tmp3__length1;
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		for (arg_it = 0; arg_it < _tmp3__length1; arg_it = arg_it + 1) {
#line 316 "chess-engine.c"
			gchar* _tmp4_ = NULL;
			gchar* arg = NULL;
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
			_tmp4_ = g_strdup (arg_collection[arg_it]);
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
			arg = _tmp4_;
#line 323 "chess-engine.c"
			{
				gchar** _tmp5_ = NULL;
				gint _tmp5__length1 = 0;
				const gchar* _tmp6_ = NULL;
				gchar* _tmp7_ = NULL;
#line 64 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
				_tmp5_ = argv;
#line 64 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
				_tmp5__length1 = argv_length1;
#line 64 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
				_tmp6_ = arg;
#line 64 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
				_tmp7_ = g_strdup (_tmp6_);
#line 64 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
				_vala_array_add1 (&argv, &argv_length1, &_argv_size_, _tmp7_);
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
				_g_free0 (arg);
#line 341 "chess-engine.c"
			}
		}
	}
#line 65 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	_tmp8_ = argv;
#line 65 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	_tmp8__length1 = argv_length1;
#line 65 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	_vala_array_add2 (&argv, &argv_length1, &_argv_size_, NULL);
#line 351 "chess-engine.c"
	{
		gchar** _tmp9_ = NULL;
		gint _tmp9__length1 = 0;
		GPid _tmp10_ = 0;
		gint _tmp11_ = 0;
		gint _tmp12_ = 0;
		gint _tmp13_ = 0;
#line 70 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		_tmp9_ = argv;
#line 70 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		_tmp9__length1 = argv_length1;
#line 70 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		g_spawn_async_with_pipes (NULL, _tmp9_, NULL, G_SPAWN_SEARCH_PATH | G_SPAWN_DO_NOT_REAP_CHILD, ____lambda4__gspawn_child_setup_func, self, &_tmp10_, &_tmp11_, &_tmp12_, &_tmp13_, &_inner_error_);
#line 70 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		self->priv->pid = _tmp10_;
#line 70 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		self->priv->stdin_fd = _tmp11_;
#line 70 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		stdout_fd = _tmp12_;
#line 70 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		self->priv->stderr_fd = _tmp13_;
#line 70 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 70 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
			if (_inner_error_->domain == G_SPAWN_ERROR) {
#line 377 "chess-engine.c"
				goto __catch13_g_spawn_error;
			}
#line 70 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
			argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
#line 70 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 70 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
			g_clear_error (&_inner_error_);
#line 70 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
			return FALSE;
#line 388 "chess-engine.c"
		}
	}
	goto __finally13;
	__catch13_g_spawn_error:
	{
		GError* e = NULL;
		GError* _tmp14_ = NULL;
		const gchar* _tmp15_ = NULL;
#line 68 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		e = _inner_error_;
#line 68 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		_inner_error_ = NULL;
#line 77 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		_tmp14_ = e;
#line 77 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		_tmp15_ = _tmp14_->message;
#line 77 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		g_warning ("chess-engine.vala:77: Failed to execute chess engine: %s\n", _tmp15_);
#line 78 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		result = FALSE;
#line 78 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		_g_error_free0 (e);
#line 78 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
#line 78 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		return result;
#line 415 "chess-engine.c"
	}
	__finally13:
#line 68 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 68 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
#line 68 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 68 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		g_clear_error (&_inner_error_);
#line 68 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		return FALSE;
#line 428 "chess-engine.c"
	}
#line 81 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	_tmp16_ = self->priv->pid;
#line 81 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	g_child_watch_add_full (G_PRIORITY_DEFAULT_IDLE, _tmp16_, _chess_engine_engine_stopped_cb_gchild_watch_func, g_object_ref (self), g_object_unref);
#line 83 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	_tmp17_ = stdout_fd;
#line 83 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	_tmp18_ = g_io_channel_unix_new (_tmp17_);
#line 83 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	_g_io_channel_unref0 (self->priv->stdout_channel);
#line 83 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	self->priv->stdout_channel = _tmp18_;
#line 442 "chess-engine.c"
	{
		GIOChannel* _tmp19_ = NULL;
#line 86 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		_tmp19_ = self->priv->stdout_channel;
#line 86 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		g_io_channel_set_flags (_tmp19_, G_IO_FLAG_NONBLOCK, &_inner_error_);
#line 86 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 86 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
			if (_inner_error_->domain == G_IO_CHANNEL_ERROR) {
#line 453 "chess-engine.c"
				goto __catch14_g_io_channel_error;
			}
#line 86 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
			argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
#line 86 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 86 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
			g_clear_error (&_inner_error_);
#line 86 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
			return FALSE;
#line 464 "chess-engine.c"
		}
	}
	goto __finally14;
	__catch14_g_io_channel_error:
	{
		GError* e = NULL;
		GError* _tmp20_ = NULL;
		const gchar* _tmp21_ = NULL;
#line 84 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		e = _inner_error_;
#line 84 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		_inner_error_ = NULL;
#line 90 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		_tmp20_ = e;
#line 90 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		_tmp21_ = _tmp20_->message;
#line 90 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		g_warning ("chess-engine.vala:90: Failed to set input from chess engine to non-blo" \
"cking: %s", _tmp21_);
#line 84 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		_g_error_free0 (e);
#line 485 "chess-engine.c"
	}
	__finally14:
#line 84 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 84 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
#line 84 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 84 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		g_clear_error (&_inner_error_);
#line 84 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		return FALSE;
#line 498 "chess-engine.c"
	}
#line 92 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	_tmp22_ = self->priv->stdout_channel;
#line 92 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	g_io_channel_set_close_on_unref (_tmp22_, TRUE);
#line 93 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	_tmp23_ = self->priv->stdout_channel;
#line 93 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	_tmp24_ = g_io_add_watch (_tmp23_, G_IO_IN, _chess_engine_read_cb_gio_func, self);
#line 93 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	self->priv->stdout_watch_id = _tmp24_;
#line 95 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	self->priv->started = TRUE;
#line 96 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	g_signal_emit_by_name (self, "starting");
#line 98 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	result = TRUE;
#line 98 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
#line 98 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	return result;
#line 520 "chess-engine.c"
}


static void chess_engine_engine_stopped_cb (ChessEngine* self, GPid pid, gint status) {
	GPid _tmp0_ = 0;
#line 101 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	g_return_if_fail (self != NULL);
#line 103 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	_tmp0_ = pid;
#line 103 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	g_spawn_close_pid (_tmp0_);
#line 104 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	pid = (GPid) 0;
#line 105 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	g_signal_emit_by_name (self, "stopped");
#line 536 "chess-engine.c"
}


static void chess_engine_real_start_game (ChessEngine* self) {
#line 108 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	g_critical ("Type `%s' does not implement abstract method `chess_engine_start_game'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 108 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	return;
#line 545 "chess-engine.c"
}


void chess_engine_start_game (ChessEngine* self) {
#line 108 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	g_return_if_fail (self != NULL);
#line 108 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	CHESS_ENGINE_GET_CLASS (self)->start_game (self);
#line 554 "chess-engine.c"
}


static void chess_engine_real_report_move (ChessEngine* self, ChessMove* move) {
#line 110 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	g_critical ("Type `%s' does not implement abstract method `chess_engine_report_move'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 110 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	return;
#line 563 "chess-engine.c"
}


void chess_engine_report_move (ChessEngine* self, ChessMove* move) {
#line 110 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	g_return_if_fail (self != NULL);
#line 110 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	CHESS_ENGINE_GET_CLASS (self)->report_move (self, move);
#line 572 "chess-engine.c"
}


static void chess_engine_real_do_undo (ChessEngine* self) {
#line 112 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	g_critical ("Type `%s' does not implement abstract method `chess_engine_do_undo'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 112 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	return;
#line 581 "chess-engine.c"
}


void chess_engine_do_undo (ChessEngine* self) {
#line 112 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	g_return_if_fail (self != NULL);
#line 112 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	CHESS_ENGINE_GET_CLASS (self)->do_undo (self);
#line 590 "chess-engine.c"
}


static void chess_engine_real_request_move (ChessEngine* self) {
#line 114 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	g_critical ("Type `%s' does not implement abstract method `chess_engine_request_move'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 114 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	return;
#line 599 "chess-engine.c"
}


void chess_engine_request_move (ChessEngine* self) {
#line 114 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	g_return_if_fail (self != NULL);
#line 114 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	CHESS_ENGINE_GET_CLASS (self)->request_move (self);
#line 608 "chess-engine.c"
}


static gboolean __lambda5_ (ChessEngine* self) {
	gboolean result = FALSE;
#line 119 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	self->priv->pending_move_source_id = (guint) 0;
#line 120 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	chess_engine_request_move (self);
#line 122 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	result = FALSE;
#line 122 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	return result;
#line 622 "chess-engine.c"
}


static gboolean ___lambda5__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda5_ ((ChessEngine*) self);
#line 118 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	return result;
#line 631 "chess-engine.c"
}


void chess_engine_move (ChessEngine* self) {
	guint _tmp0_ = 0U;
	guint _tmp1_ = 0U;
#line 116 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	g_return_if_fail (self != NULL);
#line 118 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	_tmp0_ = self->priv->delay_seconds;
#line 118 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	_tmp1_ = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, _tmp0_, ___lambda5__gsource_func, g_object_ref (self), g_object_unref);
#line 118 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	self->priv->pending_move_source_id = _tmp1_;
#line 646 "chess-engine.c"
}


void chess_engine_undo (ChessEngine* self) {
	guint _tmp0_ = 0U;
#line 126 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	g_return_if_fail (self != NULL);
#line 128 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	_tmp0_ = self->priv->pending_move_source_id;
#line 128 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	if (_tmp0_ != ((guint) 0)) {
#line 658 "chess-engine.c"
		guint _tmp1_ = 0U;
#line 130 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		_tmp1_ = self->priv->pending_move_source_id;
#line 130 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		g_source_remove (_tmp1_);
#line 131 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		self->priv->pending_move_source_id = (guint) 0;
#line 666 "chess-engine.c"
	}
#line 134 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	chess_engine_do_undo (self);
#line 670 "chess-engine.c"
}


void chess_engine_stop (ChessEngine* self) {
	gboolean _tmp0_ = FALSE;
	guint _tmp1_ = 0U;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	gboolean _tmp13_ = FALSE;
	GPid _tmp14_ = 0;
	GError * _inner_error_ = NULL;
#line 137 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	g_return_if_fail (self != NULL);
#line 139 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	_tmp0_ = self->priv->started;
#line 139 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	if (!_tmp0_) {
#line 140 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		return;
#line 692 "chess-engine.c"
	}
#line 142 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	_tmp1_ = self->priv->stdout_watch_id;
#line 142 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	g_source_remove (_tmp1_);
#line 698 "chess-engine.c"
	{
		GIOChannel* _tmp2_ = NULL;
#line 146 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		_tmp2_ = self->priv->stdout_channel;
#line 146 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		g_io_channel_shutdown (_tmp2_, FALSE, &_inner_error_);
#line 146 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 146 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
			if (_inner_error_->domain == G_IO_CHANNEL_ERROR) {
#line 709 "chess-engine.c"
				goto __catch15_g_io_channel_error;
			}
#line 146 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 146 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
			g_clear_error (&_inner_error_);
#line 146 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
			return;
#line 718 "chess-engine.c"
		}
	}
	goto __finally15;
	__catch15_g_io_channel_error:
	{
		GError* e = NULL;
		GError* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
#line 144 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		e = _inner_error_;
#line 144 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		_inner_error_ = NULL;
#line 150 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		_tmp3_ = e;
#line 150 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		_tmp4_ = _tmp3_->message;
#line 150 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		g_warning ("chess-engine.vala:150: Failed to close channel to engine's stdout: %s", _tmp4_);
#line 144 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		_g_error_free0 (e);
#line 739 "chess-engine.c"
	}
	__finally15:
#line 144 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 144 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 144 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		g_clear_error (&_inner_error_);
#line 144 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		return;
#line 750 "chess-engine.c"
	}
#line 153 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	_tmp5_ = self->priv->stdin_fd;
#line 153 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	_tmp6_ = close (_tmp5_);
#line 153 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	if (_tmp6_ == (-1)) {
#line 758 "chess-engine.c"
		gint _tmp7_ = 0;
		const gchar* _tmp8_ = NULL;
#line 154 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		_tmp7_ = errno;
#line 154 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		_tmp8_ = g_strerror (_tmp7_);
#line 154 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		g_warning ("chess-engine.vala:154: Failed to close pipe to engine's stdin: %s", _tmp8_);
#line 767 "chess-engine.c"
	}
#line 156 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	_tmp9_ = self->priv->stderr_fd;
#line 156 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	_tmp10_ = close (_tmp9_);
#line 156 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	if (_tmp10_ == (-1)) {
#line 775 "chess-engine.c"
		gint _tmp11_ = 0;
		const gchar* _tmp12_ = NULL;
#line 157 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		_tmp11_ = errno;
#line 157 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		_tmp12_ = g_strerror (_tmp11_);
#line 157 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		g_warning ("chess-engine.vala:157: Failed to close pipe to engine's stderr: %s", _tmp12_);
#line 784 "chess-engine.c"
	}
#line 159 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	_tmp14_ = self->priv->pid;
#line 159 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	if (_tmp14_ != ((GPid) 0)) {
#line 790 "chess-engine.c"
		GPid _tmp15_ = 0;
		gint _tmp16_ = 0;
#line 159 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		_tmp15_ = self->priv->pid;
#line 159 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		_tmp16_ = kill ((pid_t) _tmp15_, SIGTERM);
#line 159 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		_tmp13_ = _tmp16_ == (-1);
#line 799 "chess-engine.c"
	} else {
#line 159 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		_tmp13_ = FALSE;
#line 803 "chess-engine.c"
	}
#line 159 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	if (_tmp13_) {
#line 807 "chess-engine.c"
		gint _tmp17_ = 0;
		const gchar* _tmp18_ = NULL;
#line 160 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		_tmp17_ = errno;
#line 160 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		_tmp18_ = g_strerror (_tmp17_);
#line 160 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		g_warning ("chess-engine.vala:160: Failed to kill engine: %s", _tmp18_);
#line 816 "chess-engine.c"
	}
#line 162 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	self->priv->started = FALSE;
#line 820 "chess-engine.c"
}


static gboolean chess_engine_read_cb (ChessEngine* self, GIOChannel* source, GIOCondition condition) {
	gboolean result = FALSE;
	gchar* buf = NULL;
	gint buf_length1 = 0;
	gint _buf_size_ = 0;
	gsize n_read = 0UL;
	GIOStatus status = 0;
	gchar* _tmp0_ = NULL;
	GIOStatus _tmp10_ = 0;
	GIOStatus _tmp11_ = 0;
	GError * _inner_error_ = NULL;
#line 165 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 165 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	g_return_val_if_fail (source != NULL, FALSE);
#line 171 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	_tmp0_ = g_new0 (gchar, 1024);
#line 171 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	buf = (g_free (buf), NULL);
#line 171 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	buf = _tmp0_;
#line 171 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	buf_length1 = 1024;
#line 171 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	_buf_size_ = buf_length1;
#line 849 "chess-engine.c"
	{
		GIOStatus _tmp1_ = 0;
		GIOChannel* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		gint _tmp3__length1 = 0;
		gsize _tmp4_ = 0UL;
		GIOStatus _tmp5_ = 0;
#line 174 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		_tmp2_ = source;
#line 174 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		_tmp3_ = buf;
#line 174 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		_tmp3__length1 = buf_length1;
#line 174 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		_tmp5_ = g_io_channel_read_chars (_tmp2_, _tmp3_, _tmp3__length1, &_tmp4_, &_inner_error_);
#line 174 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		n_read = _tmp4_;
#line 174 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		_tmp1_ = _tmp5_;
#line 174 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 174 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
			if (_inner_error_->domain == G_CONVERT_ERROR) {
#line 873 "chess-engine.c"
				goto __catch16_g_convert_error;
			}
#line 174 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
			if (_inner_error_->domain == G_IO_CHANNEL_ERROR) {
#line 878 "chess-engine.c"
				goto __catch16_g_io_channel_error;
			}
#line 174 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
			buf = (g_free (buf), NULL);
#line 174 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 174 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
			g_clear_error (&_inner_error_);
#line 174 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
			return FALSE;
#line 889 "chess-engine.c"
		}
#line 174 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		status = _tmp1_;
#line 893 "chess-engine.c"
	}
	goto __finally16;
	__catch16_g_convert_error:
	{
		GError* e = NULL;
		GError* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
#line 172 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		e = _inner_error_;
#line 172 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		_inner_error_ = NULL;
#line 178 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		_tmp6_ = e;
#line 178 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		_tmp7_ = _tmp6_->message;
#line 178 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		g_warning ("chess-engine.vala:178: Failed to read from engine: %s", _tmp7_);
#line 179 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		self->priv->stdout_watch_id = (guint) 0;
#line 180 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		result = FALSE;
#line 180 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		_g_error_free0 (e);
#line 180 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		buf = (g_free (buf), NULL);
#line 180 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		return result;
#line 921 "chess-engine.c"
	}
	goto __finally16;
	__catch16_g_io_channel_error:
	{
		GError* e = NULL;
		GError* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
#line 172 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		e = _inner_error_;
#line 172 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		_inner_error_ = NULL;
#line 184 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		_tmp8_ = e;
#line 184 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		_tmp9_ = _tmp8_->message;
#line 184 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		g_warning ("chess-engine.vala:184: Failed to read from engine: %s", _tmp9_);
#line 185 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		self->priv->stdout_watch_id = (guint) 0;
#line 186 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		result = FALSE;
#line 186 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		_g_error_free0 (e);
#line 186 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		buf = (g_free (buf), NULL);
#line 186 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		return result;
#line 949 "chess-engine.c"
	}
	__finally16:
#line 172 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 172 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		buf = (g_free (buf), NULL);
#line 172 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 172 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		g_clear_error (&_inner_error_);
#line 172 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		return FALSE;
#line 962 "chess-engine.c"
	}
#line 189 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	_tmp10_ = status;
#line 189 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	if (_tmp10_ == G_IO_STATUS_EOF) {
#line 191 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		g_debug ("chess-engine.vala:191: EOF");
#line 192 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		self->priv->stdout_watch_id = (guint) 0;
#line 193 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		result = FALSE;
#line 193 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		buf = (g_free (buf), NULL);
#line 193 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		return result;
#line 978 "chess-engine.c"
	}
#line 195 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	_tmp11_ = status;
#line 195 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	if (_tmp11_ == G_IO_STATUS_NORMAL) {
#line 984 "chess-engine.c"
		gsize _tmp12_ = 0UL;
		gint _tmp13_ = 0;
		gchar* _tmp14_ = NULL;
		gint _tmp14__length1 = 0;
#line 197 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		_tmp12_ = n_read;
#line 197 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		_tmp13_ = (gint) _tmp12_;
#line 197 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		buf = g_renew (gchar, buf, (gint) _tmp12_);
#line 197 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		(_tmp13_ > buf_length1) ? memset (buf + buf_length1, 0, sizeof (gchar) * (_tmp13_ - buf_length1)) : NULL;
#line 197 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		buf_length1 = _tmp13_;
#line 197 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		_buf_size_ = _tmp13_;
#line 198 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		_tmp14_ = buf;
#line 198 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		_tmp14__length1 = buf_length1;
#line 198 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		chess_engine_process_input (self, _tmp14_, _tmp14__length1);
#line 1007 "chess-engine.c"
	}
#line 201 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	result = TRUE;
#line 201 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	buf = (g_free (buf), NULL);
#line 201 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	return result;
#line 1015 "chess-engine.c"
}


void chess_engine_write (ChessEngine* self, gchar* data, int data_length1) {
	gsize offset = 0UL;
	gsize n_written = 0UL;
#line 204 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	g_return_if_fail (self != NULL);
#line 206 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	offset = (gsize) 0;
#line 207 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	n_written = (gsize) 0;
#line 1028 "chess-engine.c"
	{
		gboolean _tmp0_ = FALSE;
#line 209 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		_tmp0_ = TRUE;
#line 209 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		while (TRUE) {
#line 1035 "chess-engine.c"
			gint _tmp5_ = 0;
			gchar* _tmp6_ = NULL;
			gint _tmp6__length1 = 0;
			gsize _tmp7_ = 0UL;
			gchar* _tmp8_ = NULL;
			gint _tmp8__length1 = 0;
			gsize _tmp9_ = 0UL;
			gssize _tmp10_ = 0L;
			gsize _tmp11_ = 0UL;
			gsize _tmp12_ = 0UL;
#line 209 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
			if (!_tmp0_) {
#line 1048 "chess-engine.c"
				gboolean _tmp1_ = FALSE;
				gsize _tmp2_ = 0UL;
#line 213 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
				_tmp2_ = n_written;
#line 213 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
				if (_tmp2_ > ((gsize) 0)) {
#line 1055 "chess-engine.c"
					gsize _tmp3_ = 0UL;
					gchar* _tmp4_ = NULL;
					gint _tmp4__length1 = 0;
#line 213 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
					_tmp3_ = offset;
#line 213 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
					_tmp4_ = data;
#line 213 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
					_tmp4__length1 = data_length1;
#line 213 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
					_tmp1_ = _tmp3_ < ((gsize) _tmp4__length1);
#line 1067 "chess-engine.c"
				} else {
#line 213 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
					_tmp1_ = FALSE;
#line 1071 "chess-engine.c"
				}
#line 213 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
				if (!_tmp1_) {
#line 213 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
					break;
#line 1077 "chess-engine.c"
				}
			}
#line 209 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
			_tmp0_ = FALSE;
#line 211 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
			_tmp5_ = self->priv->stdin_fd;
#line 211 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
			_tmp6_ = data;
#line 211 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
			_tmp6__length1 = data_length1;
#line 211 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
			_tmp7_ = offset;
#line 211 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
			_tmp8_ = data;
#line 211 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
			_tmp8__length1 = data_length1;
#line 211 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
			_tmp9_ = offset;
#line 211 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
			_tmp10_ = write (_tmp5_, &_tmp6_[_tmp7_], _tmp8__length1 - _tmp9_);
#line 211 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
			n_written = (gsize) _tmp10_;
#line 212 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
			_tmp11_ = offset;
#line 212 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
			_tmp12_ = n_written;
#line 212 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
			offset = _tmp11_ + _tmp12_;
#line 1106 "chess-engine.c"
		}
	}
}


static gchar* string_to_utf8 (const gchar* self, int* result_length1) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gchar* _tmp2_ = NULL;
	gint _result__length1 = 0;
	gint __result__size_ = 0;
	gint _tmp3_ = 0;
	gchar* _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gchar* _tmp7_ = NULL;
	gint _tmp7__length1 = 0;
#line 1307 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1308 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1308 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1308 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp2_ = g_new0 (gchar, _tmp1_ + 1);
#line 1308 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_result_ = _tmp2_;
#line 1308 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_result__length1 = _tmp1_ + 1;
#line 1308 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	__result__size_ = _result__length1;
#line 1309 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp3_ = _result__length1;
#line 1309 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_result__length1 = _tmp3_ - 1;
#line 1310 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp4_ = _result_;
#line 1310 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp4__length1 = _result__length1;
#line 1310 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp5_ = strlen (self);
#line 1310 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp6_ = _tmp5_;
#line 1310 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	memcpy (_tmp4_, self, (gsize) _tmp6_);
#line 1311 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp7_ = _result_;
#line 1311 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp7__length1 = _result__length1;
#line 1311 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	if (result_length1) {
#line 1311 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		*result_length1 = _tmp7__length1;
#line 1163 "chess-engine.c"
	}
#line 1311 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	result = _tmp7_;
#line 1311 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	return result;
#line 1169 "chess-engine.c"
}


void chess_engine_write_line (ChessEngine* self, const gchar* line) {
	gchar* l = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* d = NULL;
	const gchar* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gchar* _tmp5_ = NULL;
	gint d_length1 = 0;
	gint _d_size_ = 0;
	gchar* _tmp6_ = NULL;
	gint _tmp6__length1 = 0;
#line 216 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	g_return_if_fail (self != NULL);
#line 216 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	g_return_if_fail (line != NULL);
#line 218 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	_tmp0_ = line;
#line 218 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	_tmp1_ = g_strconcat (_tmp0_, "\n", NULL);
#line 218 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	l = _tmp1_;
#line 219 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	_tmp2_ = line;
#line 219 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	g_debug ("chess-engine.vala:219: Writing line to engine: '%s'", _tmp2_);
#line 220 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	_tmp3_ = l;
#line 220 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	_tmp5_ = string_to_utf8 (_tmp3_, &_tmp4_);
#line 220 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	d = _tmp5_;
#line 220 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	d_length1 = _tmp4_;
#line 220 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	_d_size_ = d_length1;
#line 221 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	_tmp6_ = d;
#line 221 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	_tmp6__length1 = d_length1;
#line 221 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	if (_tmp6_ != NULL) {
#line 1216 "chess-engine.c"
		gchar* _tmp7_ = NULL;
		gint _tmp7__length1 = 0;
#line 222 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		_tmp7_ = d;
#line 222 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		_tmp7__length1 = d_length1;
#line 222 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		chess_engine_write (self, _tmp7_, _tmp7__length1);
#line 1225 "chess-engine.c"
	}
#line 216 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	d = (g_free (d), NULL);
#line 216 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	_g_free0 (l);
#line 1231 "chess-engine.c"
}


gboolean chess_engine_get_ready (ChessEngine* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 47 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 49 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	_tmp0_ = self->priv->_ready;
#line 49 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	result = _tmp0_;
#line 49 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	return result;
#line 1246 "chess-engine.c"
}


void chess_engine_set_ready (ChessEngine* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
#line 42 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	g_return_if_fail (self != NULL);
#line 44 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	_tmp0_ = value;
#line 44 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	self->priv->_ready = _tmp0_;
#line 45 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	g_signal_emit_by_name (self, "ready-changed");
#line 42 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	g_object_notify ((GObject *) self, "ready");
#line 1262 "chess-engine.c"
}


static void chess_engine_class_init (ChessEngineClass * klass) {
#line 13 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	chess_engine_parent_class = g_type_class_peek_parent (klass);
#line 13 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	g_type_class_add_private (klass, sizeof (ChessEnginePrivate));
#line 13 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	((ChessEngineClass *) klass)->process_input = chess_engine_real_process_input;
#line 13 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	((ChessEngineClass *) klass)->start_game = chess_engine_real_start_game;
#line 13 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	((ChessEngineClass *) klass)->report_move = chess_engine_real_report_move;
#line 13 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	((ChessEngineClass *) klass)->do_undo = chess_engine_real_do_undo;
#line 13 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	((ChessEngineClass *) klass)->request_move = chess_engine_real_request_move;
#line 13 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_chess_engine_get_property;
#line 13 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_chess_engine_set_property;
#line 13 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	G_OBJECT_CLASS (klass)->finalize = chess_engine_finalize;
#line 13 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_ENGINE_READY, g_param_spec_boolean ("ready", "ready", "ready", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 13 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	g_signal_new ("starting", TYPE_CHESS_ENGINE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 13 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	g_signal_new ("ready_changed", TYPE_CHESS_ENGINE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 13 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	g_signal_new ("moved", TYPE_CHESS_ENGINE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
#line 13 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	g_signal_new ("resigned", TYPE_CHESS_ENGINE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 13 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	g_signal_new ("stopped", TYPE_CHESS_ENGINE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 13 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	g_signal_new ("error", TYPE_CHESS_ENGINE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 13 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	g_signal_new ("claim_draw", TYPE_CHESS_ENGINE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 13 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	g_signal_new ("offer_draw", TYPE_CHESS_ENGINE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 1305 "chess-engine.c"
}


static void chess_engine_instance_init (ChessEngine * self) {
#line 13 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	self->priv = CHESS_ENGINE_GET_PRIVATE (self);
#line 26 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	self->priv->started = FALSE;
#line 39 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	self->priv->_ready = FALSE;
#line 1316 "chess-engine.c"
}


static void chess_engine_finalize (GObject* obj) {
	ChessEngine * self;
#line 13 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CHESS_ENGINE, ChessEngine);
#line 15 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	_g_free0 (self->priv->binary);
#line 16 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	self->priv->args = (_vala_array_free (self->priv->args, self->priv->args_length1, (GDestroyNotify) g_free), NULL);
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	_g_io_channel_unref0 (self->priv->stdout_channel);
#line 13 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	G_OBJECT_CLASS (chess_engine_parent_class)->finalize (obj);
#line 1332 "chess-engine.c"
}


GType chess_engine_get_type (void) {
	static volatile gsize chess_engine_type_id__volatile = 0;
	if (g_once_init_enter (&chess_engine_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ChessEngineClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) chess_engine_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ChessEngine), 0, (GInstanceInitFunc) chess_engine_instance_init, NULL };
		GType chess_engine_type_id;
		chess_engine_type_id = g_type_register_static (G_TYPE_OBJECT, "ChessEngine", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&chess_engine_type_id__volatile, chess_engine_type_id);
	}
	return chess_engine_type_id__volatile;
}


static void _vala_chess_engine_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ChessEngine * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_CHESS_ENGINE, ChessEngine);
#line 13 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	switch (property_id) {
#line 13 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		case CHESS_ENGINE_READY:
#line 13 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		g_value_set_boolean (value, chess_engine_get_ready (self));
#line 13 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		break;
#line 1359 "chess-engine.c"
		default:
#line 13 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 13 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		break;
#line 1365 "chess-engine.c"
	}
}


static void _vala_chess_engine_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ChessEngine * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_CHESS_ENGINE, ChessEngine);
#line 13 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
	switch (property_id) {
#line 13 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		case CHESS_ENGINE_READY:
#line 13 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		chess_engine_set_ready (self, g_value_get_boolean (value));
#line 13 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		break;
#line 1381 "chess-engine.c"
		default:
#line 13 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 13 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/chess-engine.vala"
		break;
#line 1387 "chess-engine.c"
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



