/* libchess.vapi generated by valac 0.27.1.15-b1df0, do not modify. */

[CCode (cheader_filename = "libchess.h")]
public enum ChessResult {
	IN_PROGRESS,
	WHITE_WON,
	BLACK_WON,
	DRAW,
	BUG
}
[CCode (cheader_filename = "libchess.h")]
public enum ChessRule {
	UNKNOWN,
	CHECKMATE,
	STALEMATE,
	FIFTY_MOVES,
	TIMEOUT,
	THREE_FOLD_REPETITION,
	INSUFFICIENT_MATERIAL,
	RESIGN,
	ABANDONMENT,
	DEATH,
	BUG
}
[CCode (cheader_filename = "libchess.h")]
public enum PieceType {
	PAWN,
	ROOK,
	KNIGHT,
	BISHOP,
	QUEEN,
	KING
}
[CCode (cheader_filename = "libchess.h")]
public enum Color {
	WHITE,
	BLACK
}
[CCode (cheader_filename = "libchess.h")]
public enum CheckState {
	NONE,
	CHECK,
	CHECKMATE
}
[CCode (cheader_filename = "libchess.h")]
public errordomain PGNError {
	LOAD_ERROR
}
[CCode (cheader_filename = "libchess.h")]
public class BitBoard : GLib.Object {
	public const int64[] clear_location_masks;
	public const int64[] move_masks;
	public const int64[] over_masks;
	public const int64[] set_location_masks;
	public BitBoard ();
	public static string to_string (int64 mask);
}
[CCode (cheader_filename = "libchess.h")]
public class ChessClock : GLib.Object {
	public ChessClock (int white_initial_seconds, int black_initial_seconds);
	public void pause ();
	public void start ();
	public void stop ();
	public void unpause ();
	public Color active_color { get; set; }
	public int black_initial_seconds { get; private set; }
	public int black_seconds_used { get; private set; }
	public int white_initial_seconds { get; private set; }
	public int white_seconds_used { get; private set; }
	public signal void expired ();
	public signal void tick ();
}
[CCode (cheader_filename = "libchess.h")]
public class ChessGame : GLib.Object {
	public bool is_started;
	public GLib.List<ChessState> move_stack;
	public ChessResult result;
	public ChessRule rule;
	public const string STANDARD_SETUP;
	public ChessGame (string fen = STANDARD_SETUP, string[]? moves = null);
	public void add_hold ();
	public bool can_claim_draw ();
	public ChessPiece? get_piece (int rank, int file, int move_number = -1);
	public bool is_fifty_move_rule_fulfilled ();
	public bool is_three_fold_repeat ();
	public void pause (bool show_overlay = true);
	public void remove_hold ();
	public void start ();
	public void stop (ChessResult result, ChessRule rule);
	public void unpause ();
	public ChessPlayer black { get; }
	public ChessClock? clock { get; set; }
	public ChessPlayer current_player { get; }
	public ChessState current_state { get; }
	public bool is_paused { get; private set; }
	public uint n_moves { get; }
	public ChessPlayer opponent { get; }
	public bool should_show_paused_overlay { get; private set; }
	public ChessPlayer white { get; }
	public signal void ended ();
	public signal void moved (ChessMove move);
	public signal void paused ();
	public signal void turn_started (ChessPlayer player);
	public signal void undo ();
	public signal void unpaused ();
}
[CCode (cheader_filename = "libchess.h")]
public class ChessMove : GLib.Object {
	public bool ambiguous_file;
	public bool ambiguous_rank;
	public CheckState check_state;
	public int f0;
	public int f1;
	public ChessPiece? moved_rook;
	public int number;
	public ChessPiece piece;
	public ChessPiece? promotion_piece;
	public int r0;
	public int r1;
	public ChessPiece? victim;
	public ChessMove ();
	public ChessMove copy ();
	public string get_engine ();
	public string get_fan ();
	public string get_lan ();
	public string get_san ();
}
[CCode (cheader_filename = "libchess.h")]
public class PGNGame : GLib.Object {
	public static string RESULT_BLACK;
	public static string RESULT_DRAW;
	public static string RESULT_IN_PROGRESS;
	public static string RESULT_WHITE;
	public static string TERMINATE_ABANDONED;
	public static string TERMINATE_ADJUDICATION;
	public static string TERMINATE_DEATH;
	public static string TERMINATE_EMERGENCY;
	public static string TERMINATE_NORMAL;
	public static string TERMINATE_RULES_INFRACTION;
	public static string TERMINATE_TIME_FORFEIT;
	public static string TERMINATE_UNTERMINATED;
	public GLib.List<string> moves;
	public GLib.HashTable<string,string> tags;
	public PGNGame ();
	public string escape (string value);
	public void write (GLib.File file) throws GLib.Error;
	public string? annotator { get; set; }
	public string black { get; set; }
	public string? black_ai { get; set; }
	public string? black_level { get; set; }
	public string? black_time_left { get; set; }
	public string date { get; set; }
	public string event { get; set; }
	public string? fen { get; set; }
	public string result { get; set; }
	public string round { get; set; }
	public bool set_up { get; set; }
	public string site { get; set; }
	public string? termination { get; set; }
	public string time { get; set; }
	public string? time_control { get; set; }
	public string white { get; set; }
	public string? white_ai { get; set; }
	public string? white_level { get; set; }
	public string? white_time_left { get; set; }
}
[CCode (cheader_filename = "libchess.h")]
public class PGN : GLib.Object {
	public GLib.List<PGNGame> games;
	public PGN ();
	public PGN.from_file (GLib.File file) throws GLib.Error;
	public PGN.from_string (string data) throws PGNError;
}
[CCode (cheader_filename = "libchess.h")]
public class ChessPiece : GLib.Object {
	public ChessPlayer player;
	public PieceType type;
	public ChessPiece (ChessPlayer player, PieceType type);
	public Color color { get; }
	public unichar symbol { get; }
	public signal void died ();
	public signal void moved ();
	public signal void promoted ();
}
[CCode (cheader_filename = "libchess.h")]
public class ChessPlayer : GLib.Object {
	public Color color;
	public ChessPlayer (Color color);
	public void claim_draw ();
	public bool move (string move, bool apply = true);
	public bool move_with_coords (int r0, int f0, int r1, int f1, bool apply = true, PieceType promotion_type = PieceType.QUEEN);
	public bool resign ();
	public void undo ();
	public bool local_human { get; set; }
	public signal void do_claim_draw ();
	public signal bool do_move (string move, bool apply);
	public signal bool do_resign ();
	public signal void do_undo ();
}
[CCode (cheader_filename = "libchess.h")]
public class ChessState : GLib.Object {
	public ChessPiece board[64];
	public bool can_castle_kingside[2];
	public bool can_castle_queenside[2];
	public CheckState check_state;
	public ChessPlayer current_player;
	public int en_passant_index;
	public int halfmove_clock;
	public ChessMove? last_move;
	public int number;
	public ChessPlayer players[2];
	public ChessState (string fen);
	public ChessState copy ();
	public bool equals (ChessState state);
	public string get_fen ();
	public int get_file (int index);
	public int get_index (int rank, int file);
	public int get_rank (int index);
	public ChessResult get_result (out ChessRule rule);
	public bool have_sufficient_material ();
	public bool is_in_check (ChessPlayer player);
	public bool move (string move, bool apply = true);
	public bool move_with_coords (ChessPlayer player, int r0, int f0, int r1, int f1, PieceType promotion_type = PieceType.QUEEN, bool apply = true, bool test_check = true);
	public ChessPlayer opponent { get; }
}
