/* service.c generated by valac 0.20.1, the Vala compiler
 * generated from service.vala, do not modify */

/*
 * This file is part of gnome-code-assistance.
 *
 * Copyright (C) 2013 - Melissa Wen <melissa.srw@gmail.com>
 * Copyright (C) 2013 - Jesse van den Kieboom <jessevdk@gnome.org>
 *
 * gnome-code-assistance is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * gnome-code-assistance is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gnome-code-assistance.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <vala.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gstdio.h>


#define GCA_BACKENDS_VALA_TYPE_DIAGNOSTICS (gca_backends_vala_diagnostics_get_type ())
#define GCA_BACKENDS_VALA_DIAGNOSTICS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCA_BACKENDS_VALA_TYPE_DIAGNOSTICS, GcaBackendsValaDiagnostics))
#define GCA_BACKENDS_VALA_DIAGNOSTICS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCA_BACKENDS_VALA_TYPE_DIAGNOSTICS, GcaBackendsValaDiagnosticsClass))
#define GCA_BACKENDS_VALA_IS_DIAGNOSTICS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCA_BACKENDS_VALA_TYPE_DIAGNOSTICS))
#define GCA_BACKENDS_VALA_IS_DIAGNOSTICS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCA_BACKENDS_VALA_TYPE_DIAGNOSTICS))
#define GCA_BACKENDS_VALA_DIAGNOSTICS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCA_BACKENDS_VALA_TYPE_DIAGNOSTICS, GcaBackendsValaDiagnosticsClass))

typedef struct _GcaBackendsValaDiagnostics GcaBackendsValaDiagnostics;
typedef struct _GcaBackendsValaDiagnosticsClass GcaBackendsValaDiagnosticsClass;
typedef struct _GcaBackendsValaDiagnosticsPrivate GcaBackendsValaDiagnosticsPrivate;

#define GCA_BACKENDS_VALA_TYPE_DIAGNOSTIC (gca_backends_vala_diagnostic_get_type ())

#define GCA_BACKENDS_VALA_TYPE_FIXIT (gca_backends_vala_fixit_get_type ())

#define GCA_BACKENDS_VALA_TYPE_SOURCE_RANGE (gca_backends_vala_source_range_get_type ())

#define GCA_BACKENDS_VALA_TYPE_SOURCE_LOCATION (gca_backends_vala_source_location_get_type ())
typedef struct _GcaBackendsValaSourceLocation GcaBackendsValaSourceLocation;
typedef struct _GcaBackendsValaSourceRange GcaBackendsValaSourceRange;
typedef struct _GcaBackendsValaFixit GcaBackendsValaFixit;
typedef struct _GcaBackendsValaDiagnostic GcaBackendsValaDiagnostic;
#define _g_free0(var) (var = (g_free (var), NULL))

#define GCA_BACKENDS_VALA_TYPE_SEVERITY (gca_backends_vala_severity_get_type ())

#define GCA_BACKENDS_VALA_TYPE_SERVICE (gca_backends_vala_service_get_type ())
#define GCA_BACKENDS_VALA_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCA_BACKENDS_VALA_TYPE_SERVICE, GcaBackendsValaService))
#define GCA_BACKENDS_VALA_SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCA_BACKENDS_VALA_TYPE_SERVICE, GcaBackendsValaServiceClass))
#define GCA_BACKENDS_VALA_IS_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCA_BACKENDS_VALA_TYPE_SERVICE))
#define GCA_BACKENDS_VALA_IS_SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCA_BACKENDS_VALA_TYPE_SERVICE))
#define GCA_BACKENDS_VALA_SERVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCA_BACKENDS_VALA_TYPE_SERVICE, GcaBackendsValaServiceClass))

typedef struct _GcaBackendsValaService GcaBackendsValaService;
typedef struct _GcaBackendsValaServiceClass GcaBackendsValaServiceClass;
typedef struct _GcaBackendsValaServicePrivate GcaBackendsValaServicePrivate;

#define GCA_BACKENDS_VALA_TYPE_DOCUMENT (gca_backends_vala_document_get_type ())
#define GCA_BACKENDS_VALA_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCA_BACKENDS_VALA_TYPE_DOCUMENT, GcaBackendsValaDocument))
#define GCA_BACKENDS_VALA_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCA_BACKENDS_VALA_TYPE_DOCUMENT, GcaBackendsValaDocumentClass))
#define GCA_BACKENDS_VALA_IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCA_BACKENDS_VALA_TYPE_DOCUMENT))
#define GCA_BACKENDS_VALA_IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCA_BACKENDS_VALA_TYPE_DOCUMENT))
#define GCA_BACKENDS_VALA_DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCA_BACKENDS_VALA_TYPE_DOCUMENT, GcaBackendsValaDocumentClass))

typedef struct _GcaBackendsValaDocument GcaBackendsValaDocument;
typedef struct _GcaBackendsValaDocumentClass GcaBackendsValaDocumentClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))
#define _vala_code_visitor_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_visitor_unref (var), NULL)))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))

struct _GcaBackendsValaDiagnostics {
	ValaReport parent_instance;
	GcaBackendsValaDiagnosticsPrivate * priv;
};

struct _GcaBackendsValaDiagnosticsClass {
	ValaReportClass parent_class;
};

struct _GcaBackendsValaSourceLocation {
	gint64 line;
	gint64 column;
};

struct _GcaBackendsValaSourceRange {
	gint64 file;
	GcaBackendsValaSourceLocation start;
	GcaBackendsValaSourceLocation end;
};

struct _GcaBackendsValaFixit {
	GcaBackendsValaSourceRange location;
	gchar* replacement;
};

struct _GcaBackendsValaDiagnostic {
	guint32 severity;
	GcaBackendsValaFixit* fixits;
	gint fixits_length1;
	GcaBackendsValaSourceRange* locations;
	gint locations_length1;
	gchar* message;
};

struct _GcaBackendsValaDiagnosticsPrivate {
	GcaBackendsValaDiagnostic* d_diagnostics;
	gint d_diagnostics_length1;
	gint _d_diagnostics_size_;
	gchar* _path;
};

typedef enum  {
	GCA_BACKENDS_VALA_SEVERITY_NONE,
	GCA_BACKENDS_VALA_SEVERITY_INFO,
	GCA_BACKENDS_VALA_SEVERITY_WARNING,
	GCA_BACKENDS_VALA_SEVERITY_DEPRECATED,
	GCA_BACKENDS_VALA_SEVERITY_ERROR,
	GCA_BACKENDS_VALA_SEVERITY_FATAL
} GcaBackendsValaSeverity;

struct _GcaBackendsValaService {
	GObject parent_instance;
	GcaBackendsValaServicePrivate * priv;
};

struct _GcaBackendsValaServiceClass {
	GObjectClass parent_class;
};


static gpointer gca_backends_vala_diagnostics_parent_class = NULL;
static gpointer gca_backends_vala_service_parent_class = NULL;

GType gca_backends_vala_diagnostics_get_type (void) G_GNUC_CONST;
GType gca_backends_vala_diagnostic_get_type (void) G_GNUC_CONST;
GType gca_backends_vala_fixit_get_type (void) G_GNUC_CONST;
GType gca_backends_vala_source_range_get_type (void) G_GNUC_CONST;
GType gca_backends_vala_source_location_get_type (void) G_GNUC_CONST;
GcaBackendsValaSourceLocation* gca_backends_vala_source_location_dup (const GcaBackendsValaSourceLocation* self);
void gca_backends_vala_source_location_free (GcaBackendsValaSourceLocation* self);
GcaBackendsValaSourceRange* gca_backends_vala_source_range_dup (const GcaBackendsValaSourceRange* self);
void gca_backends_vala_source_range_free (GcaBackendsValaSourceRange* self);
GcaBackendsValaFixit* gca_backends_vala_fixit_dup (const GcaBackendsValaFixit* self);
void gca_backends_vala_fixit_free (GcaBackendsValaFixit* self);
void gca_backends_vala_fixit_copy (const GcaBackendsValaFixit* self, GcaBackendsValaFixit* dest);
void gca_backends_vala_fixit_destroy (GcaBackendsValaFixit* self);
GcaBackendsValaDiagnostic* gca_backends_vala_diagnostic_dup (const GcaBackendsValaDiagnostic* self);
void gca_backends_vala_diagnostic_free (GcaBackendsValaDiagnostic* self);
void gca_backends_vala_diagnostic_copy (const GcaBackendsValaDiagnostic* self, GcaBackendsValaDiagnostic* dest);
void gca_backends_vala_diagnostic_destroy (GcaBackendsValaDiagnostic* self);
#define GCA_BACKENDS_VALA_DIAGNOSTICS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GCA_BACKENDS_VALA_TYPE_DIAGNOSTICS, GcaBackendsValaDiagnosticsPrivate))
enum  {
	GCA_BACKENDS_VALA_DIAGNOSTICS_DUMMY_PROPERTY,
	GCA_BACKENDS_VALA_DIAGNOSTICS_PATH
};
static void _vala_GcaBackendsValaDiagnostic_array_free (GcaBackendsValaDiagnostic* array, gint array_length);
GcaBackendsValaDiagnostics* gca_backends_vala_diagnostics_new (const gchar* path);
GcaBackendsValaDiagnostics* gca_backends_vala_diagnostics_construct (GType object_type, const gchar* path);
void gca_backends_vala_diagnostics_set_path (GcaBackendsValaDiagnostics* self, const gchar* value);
GType gca_backends_vala_severity_get_type (void) G_GNUC_CONST;
static void gca_backends_vala_diagnostics_diags_report (GcaBackendsValaDiagnostics* self, ValaSourceReference* source, const gchar* message, GcaBackendsValaSeverity severity);
const gchar* gca_backends_vala_diagnostics_get_path (GcaBackendsValaDiagnostics* self);
gint gca_backends_vala_source_location_compare_to (GcaBackendsValaSourceLocation *self, GcaBackendsValaSourceLocation* other);
static void _vala_GcaBackendsValaFixit_array_free (GcaBackendsValaFixit* array, gint array_length);
static void _vala_array_add1 (GcaBackendsValaDiagnostic** array, int* length, int* size, const GcaBackendsValaDiagnostic* value);
static void gca_backends_vala_diagnostics_real_err (ValaReport* base, ValaSourceReference* source, const gchar* message);
static void gca_backends_vala_diagnostics_real_warn (ValaReport* base, ValaSourceReference* source, const gchar* message);
static void gca_backends_vala_diagnostics_real_depr (ValaReport* base, ValaSourceReference* source, const gchar* message);
static void gca_backends_vala_diagnostics_real_note (ValaReport* base, ValaSourceReference* source, const gchar* message);
GcaBackendsValaDiagnostic* gca_backends_vala_diagnostics_get_diagnostics (GcaBackendsValaDiagnostics* self, int* result_length1);
static void gca_backends_vala_diagnostics_finalize (GObject* obj);
static void _vala_gca_backends_vala_diagnostics_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_gca_backends_vala_diagnostics_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType gca_backends_vala_service_get_type (void) G_GNUC_CONST;
enum  {
	GCA_BACKENDS_VALA_SERVICE_DUMMY_PROPERTY
};
GType gca_backends_vala_document_get_type (void) G_GNUC_CONST;
void gca_backends_vala_service_parse (GcaBackendsValaService* self, GcaBackendsValaDocument* doc, GHashTable* options, GError** error);
const gchar* gca_backends_vala_document_get_path (GcaBackendsValaDocument* self);
const gchar* gca_backends_vala_document_get_data_path (GcaBackendsValaDocument* self);
void gca_backends_vala_document_set_diagnostics (GcaBackendsValaDocument* self, GcaBackendsValaDiagnostic* value, int value_length1);
void gca_backends_vala_service_dispose (GcaBackendsValaService* self, GcaBackendsValaDocument* document);
GcaBackendsValaService* gca_backends_vala_service_new (void);
GcaBackendsValaService* gca_backends_vala_service_construct (GType object_type);


static void _vala_GcaBackendsValaDiagnostic_array_free (GcaBackendsValaDiagnostic* array, gint array_length) {
#line 28 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	if (array != NULL) {
#line 204 "service.c"
		int i;
#line 28 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
		for (i = 0; i < array_length; i = i + 1) {
#line 28 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
			gca_backends_vala_diagnostic_destroy (&array[i]);
#line 210 "service.c"
		}
	}
#line 28 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	g_free (array);
#line 215 "service.c"
}


GcaBackendsValaDiagnostics* gca_backends_vala_diagnostics_construct (GType object_type, const gchar* path) {
	GcaBackendsValaDiagnostics * self = NULL;
	const gchar* _tmp0_;
	GcaBackendsValaDiagnostic* _tmp1_ = NULL;
	gint _tmp2_;
#line 31 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	g_return_val_if_fail (path != NULL, NULL);
#line 31 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	self = (GcaBackendsValaDiagnostics*) vala_report_construct (object_type);
#line 33 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	_tmp0_ = path;
#line 33 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	gca_backends_vala_diagnostics_set_path (self, _tmp0_);
#line 35 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	_tmp1_ = g_new0 (GcaBackendsValaDiagnostic, 20);
#line 35 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	self->priv->d_diagnostics = (_vala_GcaBackendsValaDiagnostic_array_free (self->priv->d_diagnostics, self->priv->d_diagnostics_length1), NULL);
#line 35 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	self->priv->d_diagnostics = _tmp1_;
#line 35 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	self->priv->d_diagnostics_length1 = 20;
#line 35 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	self->priv->_d_diagnostics_size_ = self->priv->d_diagnostics_length1;
#line 36 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	self->priv->d_diagnostics_length1 = 0;
#line 36 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	_tmp2_ = self->priv->d_diagnostics_length1;
#line 31 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	return self;
#line 248 "service.c"
}


GcaBackendsValaDiagnostics* gca_backends_vala_diagnostics_new (const gchar* path) {
#line 31 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	return gca_backends_vala_diagnostics_construct (GCA_BACKENDS_VALA_TYPE_DIAGNOSTICS, path);
#line 255 "service.c"
}


static void _vala_GcaBackendsValaFixit_array_free (GcaBackendsValaFixit* array, gint array_length) {
#line 75 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	if (array != NULL) {
#line 262 "service.c"
		int i;
#line 75 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
		for (i = 0; i < array_length; i = i + 1) {
#line 75 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
			gca_backends_vala_fixit_destroy (&array[i]);
#line 268 "service.c"
		}
	}
#line 75 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	g_free (array);
#line 273 "service.c"
}


static void _vala_array_add1 (GcaBackendsValaDiagnostic** array, int* length, int* size, const GcaBackendsValaDiagnostic* value) {
#line 75 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	if ((*length) == (*size)) {
#line 75 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 75 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
		*array = g_renew (GcaBackendsValaDiagnostic, *array, *size);
#line 284 "service.c"
	}
#line 75 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	(*array)[(*length)++] = *value;
#line 288 "service.c"
}


static void gca_backends_vala_diagnostics_diags_report (GcaBackendsValaDiagnostics* self, ValaSourceReference* source, const gchar* message, GcaBackendsValaSeverity severity) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ValaSourceReference* _tmp2_;
	gboolean _tmp6_;
	gboolean _tmp12_;
	ValaSourceReference* _tmp13_;
	ValaSourceFile* _tmp14_;
	ValaSourceFile* _tmp15_;
	const gchar* _tmp16_;
	const gchar* _tmp17_;
	const gchar* _tmp18_;
	ValaSourceReference* _tmp19_;
	ValaSourceLocation _tmp20_;
	ValaSourceLocation _tmp21_;
	gint _tmp22_;
	ValaSourceReference* _tmp23_;
	ValaSourceLocation _tmp24_;
	ValaSourceLocation _tmp25_;
	gint _tmp26_;
	GcaBackendsValaSourceLocation _tmp27_ = {0};
	GcaBackendsValaSourceLocation start;
	ValaSourceReference* _tmp28_;
	ValaSourceLocation _tmp29_;
	ValaSourceLocation _tmp30_;
	gint _tmp31_;
	ValaSourceReference* _tmp32_;
	ValaSourceLocation _tmp33_;
	ValaSourceLocation _tmp34_;
	gint _tmp35_;
	GcaBackendsValaSourceLocation _tmp36_ = {0};
	GcaBackendsValaSourceLocation end;
	GcaBackendsValaSourceLocation _tmp37_;
	gint _tmp38_ = 0;
	GcaBackendsValaSourceLocation _tmp42_;
	GcaBackendsValaSourceLocation _tmp43_;
	GcaBackendsValaSourceRange _tmp44_ = {0};
	GcaBackendsValaSourceRange range;
	GcaBackendsValaDiagnostic* _tmp45_;
	gint _tmp45__length1;
	GcaBackendsValaSeverity _tmp46_;
	GcaBackendsValaFixit* _tmp47_ = NULL;
	GcaBackendsValaSourceRange _tmp48_;
	GcaBackendsValaSourceRange* _tmp49_ = NULL;
	const gchar* _tmp50_;
	gchar* _tmp51_;
	GcaBackendsValaDiagnostic _tmp52_ = {0};
#line 39 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	g_return_if_fail (self != NULL);
#line 39 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	g_return_if_fail (message != NULL);
#line 41 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	_tmp2_ = source;
#line 41 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	if (_tmp2_ == NULL) {
#line 41 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
		_tmp1_ = TRUE;
#line 349 "service.c"
	} else {
		ValaSourceReference* _tmp3_;
		ValaSourceFile* _tmp4_;
		ValaSourceFile* _tmp5_;
#line 41 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
		_tmp3_ = source;
#line 41 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
		_tmp4_ = vala_source_reference_get_file (_tmp3_);
#line 41 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
		_tmp5_ = _tmp4_;
#line 41 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
		_tmp1_ = _tmp5_ == NULL;
#line 362 "service.c"
	}
#line 41 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	_tmp6_ = _tmp1_;
#line 41 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	if (_tmp6_) {
#line 41 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
		_tmp0_ = TRUE;
#line 370 "service.c"
	} else {
		ValaSourceReference* _tmp7_;
		ValaSourceFile* _tmp8_;
		ValaSourceFile* _tmp9_;
		const gchar* _tmp10_;
		const gchar* _tmp11_;
#line 41 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
		_tmp7_ = source;
#line 41 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
		_tmp8_ = vala_source_reference_get_file (_tmp7_);
#line 41 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
		_tmp9_ = _tmp8_;
#line 41 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
		_tmp10_ = vala_source_file_get_filename (_tmp9_);
#line 41 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
		_tmp11_ = _tmp10_;
#line 41 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
		_tmp0_ = _tmp11_ == NULL;
#line 389 "service.c"
	}
#line 41 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	_tmp12_ = _tmp0_;
#line 41 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	if (_tmp12_) {
#line 43 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
		return;
#line 397 "service.c"
	}
#line 46 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	_tmp13_ = source;
#line 46 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	_tmp14_ = vala_source_reference_get_file (_tmp13_);
#line 46 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	_tmp15_ = _tmp14_;
#line 46 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	_tmp16_ = vala_source_file_get_filename (_tmp15_);
#line 46 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	_tmp17_ = _tmp16_;
#line 46 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	_tmp18_ = self->priv->_path;
#line 46 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	if (g_strcmp0 (_tmp17_, _tmp18_) != 0) {
#line 48 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
		return;
#line 415 "service.c"
	}
#line 51 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	_tmp19_ = source;
#line 51 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	vala_source_reference_get_begin (_tmp19_, &_tmp20_);
#line 51 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	_tmp21_ = _tmp20_;
#line 51 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	_tmp22_ = _tmp21_.line;
#line 51 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	_tmp23_ = source;
#line 51 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	vala_source_reference_get_begin (_tmp23_, &_tmp24_);
#line 51 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	_tmp25_ = _tmp24_;
#line 51 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	_tmp26_ = _tmp25_.column;
#line 51 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	memset (&_tmp27_, 0, sizeof (GcaBackendsValaSourceLocation));
#line 51 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	_tmp27_.line = (gint64) _tmp22_;
#line 51 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	_tmp27_.column = (gint64) _tmp26_;
#line 51 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	start = _tmp27_;
#line 56 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	_tmp28_ = source;
#line 56 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	vala_source_reference_get_end (_tmp28_, &_tmp29_);
#line 56 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	_tmp30_ = _tmp29_;
#line 56 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	_tmp31_ = _tmp30_.line;
#line 56 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	_tmp32_ = source;
#line 56 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	vala_source_reference_get_end (_tmp32_, &_tmp33_);
#line 56 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	_tmp34_ = _tmp33_;
#line 56 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	_tmp35_ = _tmp34_.column;
#line 56 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	memset (&_tmp36_, 0, sizeof (GcaBackendsValaSourceLocation));
#line 56 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	_tmp36_.line = (gint64) _tmp31_;
#line 56 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	_tmp36_.column = (gint64) _tmp35_;
#line 56 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	end = _tmp36_;
#line 61 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	_tmp37_ = end;
#line 61 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	_tmp38_ = gca_backends_vala_source_location_compare_to (&start, &_tmp37_);
#line 61 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	if (_tmp38_ > 0) {
#line 471 "service.c"
		GcaBackendsValaSourceLocation _tmp39_;
		GcaBackendsValaSourceLocation tmp;
		GcaBackendsValaSourceLocation _tmp40_;
		GcaBackendsValaSourceLocation _tmp41_;
#line 63 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
		_tmp39_ = end;
#line 63 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
		tmp = _tmp39_;
#line 65 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
		_tmp40_ = start;
#line 65 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
		end = _tmp40_;
#line 66 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
		_tmp41_ = tmp;
#line 66 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
		start = _tmp41_;
#line 488 "service.c"
	}
#line 69 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	_tmp42_ = start;
#line 69 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	_tmp43_ = end;
#line 69 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	memset (&_tmp44_, 0, sizeof (GcaBackendsValaSourceRange));
#line 69 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	_tmp44_.file = (gint64) 0;
#line 69 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	_tmp44_.start = _tmp42_;
#line 69 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	_tmp44_.end = _tmp43_;
#line 69 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	range = _tmp44_;
#line 75 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	_tmp45_ = self->priv->d_diagnostics;
#line 75 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	_tmp45__length1 = self->priv->d_diagnostics_length1;
#line 75 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	_tmp46_ = severity;
#line 75 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	_tmp47_ = g_new0 (GcaBackendsValaFixit, 0);
#line 75 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	_tmp48_ = range;
#line 75 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	_tmp49_ = g_new0 (GcaBackendsValaSourceRange, 1);
#line 75 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	_tmp49_[0] = _tmp48_;
#line 75 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	_tmp50_ = message;
#line 75 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	_tmp51_ = g_strdup (_tmp50_);
#line 75 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	memset (&_tmp52_, 0, sizeof (GcaBackendsValaDiagnostic));
#line 75 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	_tmp52_.severity = (guint32) _tmp46_;
#line 75 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	_tmp52_.fixits = (_vala_GcaBackendsValaFixit_array_free (_tmp52_.fixits, _tmp52_.fixits_length1), NULL);
#line 75 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	_tmp52_.fixits = _tmp47_;
#line 75 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	_tmp52_.fixits_length1 = 0;
#line 75 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	_tmp52_.locations = (g_free (_tmp52_.locations), NULL);
#line 75 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	_tmp52_.locations = _tmp49_;
#line 75 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	_tmp52_.locations_length1 = 1;
#line 75 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	_g_free0 (_tmp52_.message);
#line 75 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	_tmp52_.message = _tmp51_;
#line 75 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	_vala_array_add1 (&self->priv->d_diagnostics, &self->priv->d_diagnostics_length1, &self->priv->_d_diagnostics_size_, &_tmp52_);
#line 544 "service.c"
}


static void gca_backends_vala_diagnostics_real_err (ValaReport* base, ValaSourceReference* source, const gchar* message) {
	GcaBackendsValaDiagnostics * self;
	ValaSourceReference* _tmp0_;
	const gchar* _tmp1_;
#line 88 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	self = (GcaBackendsValaDiagnostics*) base;
#line 88 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	g_return_if_fail (message != NULL);
#line 90 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	_tmp0_ = source;
#line 90 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	_tmp1_ = message;
#line 90 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	gca_backends_vala_diagnostics_diags_report (self, _tmp0_, _tmp1_, GCA_BACKENDS_VALA_SEVERITY_ERROR);
#line 562 "service.c"
}


static void gca_backends_vala_diagnostics_real_warn (ValaReport* base, ValaSourceReference* source, const gchar* message) {
	GcaBackendsValaDiagnostics * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaSourceReference* _tmp2_;
	const gchar* _tmp3_;
#line 93 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	self = (GcaBackendsValaDiagnostics*) base;
#line 93 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	g_return_if_fail (message != NULL);
#line 95 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	_tmp0_ = vala_report_get_enable_warnings ((ValaReport*) self);
#line 95 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	_tmp1_ = _tmp0_;
#line 95 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	if (!_tmp1_) {
#line 97 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
		return;
#line 584 "service.c"
	}
#line 100 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	_tmp2_ = source;
#line 100 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	_tmp3_ = message;
#line 100 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	gca_backends_vala_diagnostics_diags_report (self, _tmp2_, _tmp3_, GCA_BACKENDS_VALA_SEVERITY_WARNING);
#line 592 "service.c"
}


static void gca_backends_vala_diagnostics_real_depr (ValaReport* base, ValaSourceReference* source, const gchar* message) {
	GcaBackendsValaDiagnostics * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaSourceReference* _tmp2_;
	const gchar* _tmp3_;
#line 103 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	self = (GcaBackendsValaDiagnostics*) base;
#line 103 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	g_return_if_fail (message != NULL);
#line 105 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	_tmp0_ = vala_report_get_enable_warnings ((ValaReport*) self);
#line 105 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	_tmp1_ = _tmp0_;
#line 105 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	if (!_tmp1_) {
#line 107 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
		return;
#line 614 "service.c"
	}
#line 110 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	_tmp2_ = source;
#line 110 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	_tmp3_ = message;
#line 110 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	gca_backends_vala_diagnostics_diags_report (self, _tmp2_, _tmp3_, GCA_BACKENDS_VALA_SEVERITY_DEPRECATED);
#line 622 "service.c"
}


static void gca_backends_vala_diagnostics_real_note (ValaReport* base, ValaSourceReference* source, const gchar* message) {
	GcaBackendsValaDiagnostics * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaSourceReference* _tmp2_;
	const gchar* _tmp3_;
#line 113 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	self = (GcaBackendsValaDiagnostics*) base;
#line 113 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	g_return_if_fail (message != NULL);
#line 115 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	_tmp0_ = vala_report_get_enable_warnings ((ValaReport*) self);
#line 115 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	_tmp1_ = _tmp0_;
#line 115 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	if (!_tmp1_) {
#line 117 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
		return;
#line 644 "service.c"
	}
#line 120 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	_tmp2_ = source;
#line 120 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	_tmp3_ = message;
#line 120 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	gca_backends_vala_diagnostics_diags_report (self, _tmp2_, _tmp3_, GCA_BACKENDS_VALA_SEVERITY_INFO);
#line 652 "service.c"
}


const gchar* gca_backends_vala_diagnostics_get_path (GcaBackendsValaDiagnostics* self) {
	const gchar* result;
	const gchar* _tmp0_;
#line 29 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 29 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	_tmp0_ = self->priv->_path;
#line 29 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	result = _tmp0_;
#line 29 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	return result;
#line 667 "service.c"
}


void gca_backends_vala_diagnostics_set_path (GcaBackendsValaDiagnostics* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
#line 29 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	g_return_if_fail (self != NULL);
#line 29 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	_tmp0_ = value;
#line 29 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 29 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	_g_free0 (self->priv->_path);
#line 29 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	self->priv->_path = _tmp1_;
#line 29 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	g_object_notify ((GObject *) self, "path");
#line 686 "service.c"
}


GcaBackendsValaDiagnostic* gca_backends_vala_diagnostics_get_diagnostics (GcaBackendsValaDiagnostics* self, int* result_length1) {
	GcaBackendsValaDiagnostic* result;
	GcaBackendsValaDiagnostic* _tmp0_;
	gint _tmp0__length1;
	GcaBackendsValaDiagnostic* _tmp1_;
	gint _tmp1__length1;
#line 85 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 85 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	_tmp0_ = self->priv->d_diagnostics;
#line 85 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	_tmp0__length1 = self->priv->d_diagnostics_length1;
#line 85 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	_tmp1_ = _tmp0_;
#line 85 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	_tmp1__length1 = _tmp0__length1;
#line 85 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	if (result_length1) {
#line 85 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
		*result_length1 = _tmp1__length1;
#line 710 "service.c"
	}
#line 85 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	result = _tmp1_;
#line 85 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	return result;
#line 716 "service.c"
}


static void gca_backends_vala_diagnostics_class_init (GcaBackendsValaDiagnosticsClass * klass) {
#line 26 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	gca_backends_vala_diagnostics_parent_class = g_type_class_peek_parent (klass);
#line 26 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	g_type_class_add_private (klass, sizeof (GcaBackendsValaDiagnosticsPrivate));
#line 26 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	VALA_REPORT_CLASS (klass)->err = gca_backends_vala_diagnostics_real_err;
#line 26 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	VALA_REPORT_CLASS (klass)->warn = gca_backends_vala_diagnostics_real_warn;
#line 26 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	VALA_REPORT_CLASS (klass)->depr = gca_backends_vala_diagnostics_real_depr;
#line 26 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	VALA_REPORT_CLASS (klass)->note = gca_backends_vala_diagnostics_real_note;
#line 26 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_gca_backends_vala_diagnostics_get_property;
#line 26 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_gca_backends_vala_diagnostics_set_property;
#line 26 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	G_OBJECT_CLASS (klass)->finalize = gca_backends_vala_diagnostics_finalize;
#line 26 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GCA_BACKENDS_VALA_DIAGNOSTICS_PATH, g_param_spec_string ("path", "path", "path", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 741 "service.c"
}


static void gca_backends_vala_diagnostics_instance_init (GcaBackendsValaDiagnostics * self) {
#line 26 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	self->priv = GCA_BACKENDS_VALA_DIAGNOSTICS_GET_PRIVATE (self);
#line 748 "service.c"
}


static void gca_backends_vala_diagnostics_finalize (GObject* obj) {
	GcaBackendsValaDiagnostics * self;
#line 26 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GCA_BACKENDS_VALA_TYPE_DIAGNOSTICS, GcaBackendsValaDiagnostics);
#line 28 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	self->priv->d_diagnostics = (_vala_GcaBackendsValaDiagnostic_array_free (self->priv->d_diagnostics, self->priv->d_diagnostics_length1), NULL);
#line 29 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	_g_free0 (self->priv->_path);
#line 26 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	G_OBJECT_CLASS (gca_backends_vala_diagnostics_parent_class)->finalize (obj);
#line 762 "service.c"
}


GType gca_backends_vala_diagnostics_get_type (void) {
	static volatile gsize gca_backends_vala_diagnostics_type_id__volatile = 0;
	if (g_once_init_enter (&gca_backends_vala_diagnostics_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GcaBackendsValaDiagnosticsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gca_backends_vala_diagnostics_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GcaBackendsValaDiagnostics), 0, (GInstanceInitFunc) gca_backends_vala_diagnostics_instance_init, NULL };
		GType gca_backends_vala_diagnostics_type_id;
		gca_backends_vala_diagnostics_type_id = g_type_register_static (VALA_TYPE_REPORT, "GcaBackendsValaDiagnostics", &g_define_type_info, 0);
		g_once_init_leave (&gca_backends_vala_diagnostics_type_id__volatile, gca_backends_vala_diagnostics_type_id);
	}
	return gca_backends_vala_diagnostics_type_id__volatile;
}


static void _vala_gca_backends_vala_diagnostics_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GcaBackendsValaDiagnostics * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GCA_BACKENDS_VALA_TYPE_DIAGNOSTICS, GcaBackendsValaDiagnostics);
#line 26 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	switch (property_id) {
#line 26 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
		case GCA_BACKENDS_VALA_DIAGNOSTICS_PATH:
#line 26 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
		g_value_set_string (value, gca_backends_vala_diagnostics_get_path (self));
#line 26 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
		break;
#line 789 "service.c"
		default:
#line 26 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 26 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
		break;
#line 795 "service.c"
	}
}


static void _vala_gca_backends_vala_diagnostics_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GcaBackendsValaDiagnostics * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GCA_BACKENDS_VALA_TYPE_DIAGNOSTICS, GcaBackendsValaDiagnostics);
#line 26 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	switch (property_id) {
#line 26 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
		case GCA_BACKENDS_VALA_DIAGNOSTICS_PATH:
#line 26 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
		gca_backends_vala_diagnostics_set_path (self, g_value_get_string (value));
#line 26 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
		break;
#line 811 "service.c"
		default:
#line 26 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 26 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
		break;
#line 817 "service.c"
	}
}


void gca_backends_vala_service_parse (GcaBackendsValaService* self, GcaBackendsValaDocument* doc, GHashTable* options, GError** error) {
	ValaCodeContext* _tmp0_;
	ValaCodeContext* context;
	GcaBackendsValaDocument* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	GcaBackendsValaDiagnostics* _tmp4_;
	GcaBackendsValaDiagnostics* diags;
	gchar* source = NULL;
	GcaBackendsValaDocument* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_ = NULL;
	GcaBackendsValaDocument* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	ValaSourceFile* _tmp12_;
	ValaSourceFile* sf;
	ValaSourceFile* _tmp13_;
	ValaParser* _tmp14_;
	ValaParser* ast;
	ValaParser* _tmp15_;
	GcaBackendsValaDocument* _tmp16_;
	GcaBackendsValaDiagnostic* _tmp17_;
	gint _tmp17__length1;
	GcaBackendsValaDiagnostic* _tmp18_;
	gint _tmp18__length1;
	GError * _inner_error_ = NULL;
#line 126 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	g_return_if_fail (self != NULL);
#line 126 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	g_return_if_fail (doc != NULL);
#line 126 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	g_return_if_fail (options != NULL);
#line 128 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	_tmp0_ = vala_code_context_new ();
#line 128 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	context = _tmp0_;
#line 130 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	_tmp1_ = doc;
#line 130 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	_tmp2_ = gca_backends_vala_document_get_path (_tmp1_);
#line 130 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	_tmp3_ = _tmp2_;
#line 130 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	_tmp4_ = gca_backends_vala_diagnostics_new (_tmp3_);
#line 130 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	diags = _tmp4_;
#line 131 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	vala_code_context_set_report (context, (ValaReport*) diags);
#line 133 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	vala_code_context_push (context);
#line 136 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	_tmp5_ = doc;
#line 136 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	_tmp6_ = gca_backends_vala_document_get_data_path (_tmp5_);
#line 136 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	_tmp7_ = _tmp6_;
#line 136 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	g_file_get_contents (_tmp7_, &_tmp8_, NULL, &_inner_error_);
#line 136 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	_g_free0 (source);
#line 136 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	source = _tmp8_;
#line 136 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	if (_inner_error_ != NULL) {
#line 136 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
		g_propagate_error (error, _inner_error_);
#line 136 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
		_g_free0 (source);
#line 136 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
		_g_object_unref0 (diags);
#line 136 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
		_vala_code_context_unref0 (context);
#line 136 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
		return;
#line 898 "service.c"
	}
#line 138 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	_tmp9_ = doc;
#line 138 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	_tmp10_ = gca_backends_vala_document_get_path (_tmp9_);
#line 138 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	_tmp11_ = _tmp10_;
#line 138 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	_tmp12_ = vala_source_file_new (context, VALA_SOURCE_FILE_TYPE_SOURCE, _tmp11_, source, TRUE);
#line 138 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	sf = _tmp12_;
#line 139 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	_tmp13_ = sf;
#line 139 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	vala_code_context_add_source_file (context, _tmp13_);
#line 141 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	_tmp14_ = vala_parser_new ();
#line 141 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	ast = _tmp14_;
#line 142 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	_tmp15_ = ast;
#line 142 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	vala_parser_parse (_tmp15_, context);
#line 144 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	vala_code_context_pop ();
#line 146 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	_tmp16_ = doc;
#line 146 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	_tmp17_ = gca_backends_vala_diagnostics_get_diagnostics (diags, &_tmp17__length1);
#line 146 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	_tmp18_ = _tmp17_;
#line 146 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	_tmp18__length1 = _tmp17__length1;
#line 146 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	gca_backends_vala_document_set_diagnostics (_tmp16_, _tmp18_, _tmp18__length1);
#line 126 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	_vala_code_visitor_unref0 (ast);
#line 126 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	_vala_source_file_unref0 (sf);
#line 126 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	_g_free0 (source);
#line 126 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	_g_object_unref0 (diags);
#line 126 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	_vala_code_context_unref0 (context);
#line 944 "service.c"
}


void gca_backends_vala_service_dispose (GcaBackendsValaService* self, GcaBackendsValaDocument* document) {
#line 149 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	g_return_if_fail (self != NULL);
#line 149 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	g_return_if_fail (document != NULL);
#line 953 "service.c"
}


GcaBackendsValaService* gca_backends_vala_service_construct (GType object_type) {
	GcaBackendsValaService * self = NULL;
#line 124 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	self = (GcaBackendsValaService*) g_object_new (object_type, NULL);
#line 124 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	return self;
#line 963 "service.c"
}


GcaBackendsValaService* gca_backends_vala_service_new (void) {
#line 124 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	return gca_backends_vala_service_construct (GCA_BACKENDS_VALA_TYPE_SERVICE);
#line 970 "service.c"
}


static void gca_backends_vala_service_class_init (GcaBackendsValaServiceClass * klass) {
#line 124 "/home/jesse/devel/gnome-code-assistance/backends/vala/service.vala"
	gca_backends_vala_service_parent_class = g_type_class_peek_parent (klass);
#line 977 "service.c"
}


static void gca_backends_vala_service_instance_init (GcaBackendsValaService * self) {
}


GType gca_backends_vala_service_get_type (void) {
	static volatile gsize gca_backends_vala_service_type_id__volatile = 0;
	if (g_once_init_enter (&gca_backends_vala_service_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GcaBackendsValaServiceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gca_backends_vala_service_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GcaBackendsValaService), 0, (GInstanceInitFunc) gca_backends_vala_service_instance_init, NULL };
		GType gca_backends_vala_service_type_id;
		gca_backends_vala_service_type_id = g_type_register_static (G_TYPE_OBJECT, "GcaBackendsValaService", &g_define_type_info, 0);
		g_once_init_leave (&gca_backends_vala_service_type_id__volatile, gca_backends_vala_service_type_id);
	}
	return gca_backends_vala_service_type_id__volatile;
}



