/* GNOME DB
 * Copyright (C) 1998 Michael Lausch
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __GDA_CONNECTION_H__
#define __GDA_CONNECTION_H__

#include <glib.h>

#include "gda-types.h"


#define GDA_CNC_COMMIT_RTN 0x1
#define GDA_CNC_ABORT_RTN  0x2




typedef enum
{
  GDCN_SCHEMA_ASSERTS = 0,
  GDCN_SCHEMA_CATALOGS,
  GDCN_SCHEMA_CHARSETS,
  GDCN_SCHEMA_CHECK_CONSTRAINTS,
  GDCN_SCHEMA_COLLATIONS,
  GDCN_SCHEMA_COL_DOM_USAGE,
  GDCN_SCHEMA_COL_PRIVS,
  GDCN_SCHEMA_COLS,
  GDCN_SCHEMA_CONSTR_COL_USAGE,
  GDCN_SCHEMA_CONSTR_TAB_USAGE,
  GDCN_SCHEMA_FOREIGN_KEYS,
  GDCN_SCHEMA_INDEXES,
  GDCN_SCHEMA_KEY_COL_USAGE,
  GDCN_SCHEMA_PRIM_KEYS,
  GDCN_SCHEMA_PROC_COLUMNS,
  GDCN_SCHEMA_PROC_PARAMS,
  GDCN_SCHEMA_PROCS,
  GDCN_SCHEMA_PROV_SPEC,
  GDCN_SCHEMA_PROV_TYPES,
  GDCN_SCHEMA_REF_CONSTRAINTS,
  GDCN_SCHEMA_SQL_LANG,
  GDCN_SCHEMA_STATISTICS,
  GDCN_SCHEMA_TAB_CONSTRAINTS,
  GDCN_SCHEMA_TAB_PRIVS,
  GDCN_SCHEMA_TABLES,
  GDCN_SCHEMA_TRANSLATIONS,
  GDCN_SCHEMA_USAGE_PROVS,
  GDCN_SCHEMA_VIEW_COL_USAGE,
  GDCN_SCHEMA_VIEW_TAB_USAGE,
  GDCN_SCHEMA_VIEWS,
  GDNC_SCHEMA_LAST
}GDA_SCHEMA_QTYPE;


Gda_Connection*      gda_connection_new(void);
void                 gda_connection_free(Gda_Connection* cnc);
void                 gda_connection_error(Gda_Connection* cnc, gchar* where);
void                 gda_connection_add_error(Gda_Connection* cnc, Gda_Error* e);
/*
  Properties
*/

gulong         gda_connection_get_attributes     (Gda_Connection* cnc);
gulong         gda_connection_set_attributes     (Gda_Connection* cnc, gulong attrs);
gulong         gda_connection_get_cmd_to         (Gda_Connection* cnc);
gulong         gda_connection_set_cmd_to         (Gda_Connection* cnc, gulong to);
gchar*         gda_connection_get_string         (Gda_Connection* cnc);
gchar*         gda_connection_set_string         (Gda_Connection* cnc, gchar* string);
gulong         gda_connection_get_to             (Gda_Connection* cnc);
gulong         gda_connection_set_to             (Gda_Connection* cnc, gulong to);
GDC_CURSOR_LOCATION gda_connection_get_cursor_loc(Gda_Connection* cnc);
GDC_CURSOR_LOCATION gda_connection_set_cursor_loc(Gda_Connection* cnc, GDC_CURSOR_LOCATION l);
gchar*         gda_connection_get_default_db     (Gda_Connection* cnc);
gchar*         gda_connection_set_default_db     (Gda_Connection* cnc, gchar* default_db);
GDCN_ISOLATION_LEVEL gda_connection_get_isolation(Gda_Connection* cnc);
GDCN_ISOLATION_LEVEL gda_connection_set_isolation(Gda_Connection* cnc, GDCN_ISOLATION_LEVEL i);
GDCN_PERM      gda_connection_get_permission     (Gda_Connection* cnc);
GDCN_PERM      gda_connection_set_permission     (Gda_Connection* cnc, GDCN_PERM p);
gchar*         gda_connection_get_provider       (Gda_Connection* cnc);
gchar*         gda_connection_set_provider       (Gda_Connection* cnc, gchar* provider);
gint           gda_connection_is_open            (Gda_Connection* cnc);
gchar*         gda_connection_get_version        (Gda_Connection* version);

/*
  Methods
*/
glong               gda_connection_begin_trans        (Gda_Connection* cnc);
glong               gda_connection_commit_trans       (Gda_Connection* cnc);
glong               gda_connection_rollback_trans     (Gda_Connection* cnc);
gint                gda_connection_close              (Gda_Connection* cnc);
Gda_Recordset*      gda_connection_execute            (Gda_Connection* cnc,
						gchar* cmd,
						glong* rowcount,
						gulong stmt_type);

gint                gda_connection_open               (Gda_Connection* cnc, gchar* cnc_string,
						gchar* user, gchar* passwd);
Gda_Recordset*      gda_connection_open_schema        (Gda_Connection* cnc, GDA_SCHEMA_QTYPE t,
						char* constraints[]);

						     


#endif
