/* GNOME DB
 * Copyright (C) 1998 Michael Lausch
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include <memory.h>

#include "gda-mysql-field.h"
#include "gda-mysql-command.h"
#include "gda-mysql-recset.h"
#include "gda-mysql-error.h"
#include "gda-mysql-connection.h"

static guint
string_hash (gconstpointer v)
{
  register gchar *c;
  register guint h;
  
  h = 0;
  for (c = (gchar*)v; *c; c++)
    {
      register guint g;
      
      h = (h << 4) + *c;
      g = h & 0xf0000000;
      if (g)
	{
	  h = h ^ (g >> 24);
	  h = h ^ g;
	}
    }
  
  return h;
}

static gint
string_compare(gconstpointer s1, gconstpointer s2)
{
  return !strcmp(s1, s2);
}

Gda_MYSQL_Command*
gda_mysql_cmd_new()
{
  Gda_MYSQL_Command* rc = g_new0(Gda_MYSQL_Command, 1);
  return rc;
}


void
gda_mysql_cmd_free(Gda_MYSQL_Command* cmd)
{
  GList* ptr;
  
  g_free(cmd);
	
}



Gda_MYSQL_Connection*
gda_mysql_cmd_set_connection(Gda_MYSQL_Command* cmd,
			     Gda_MYSQL_Connection* cnc)
{
  return 0;
}


  
Gda_MYSQL_Recordset*
gda_mysql_cmd_execute(Gda_MYSQL_Command* cmd, gulong options)
{
  gint                rc;
  
#if 0
  rc = mysql_real_query(cmd->cnc->mysql, cmd->cmd, cmd->cmd_length);
  fprintf(stderr,"gda_cmd_execute: rc = %d\n", rc);
  fprintf(stderr,"                 mysql errno = %d\n",  mysql_errno(cmd->cnc->mysql));
  fprintf(stderr,"                 mysql errmsg = '%s'\n", mysql_error(cmd->cnc->mysql));
#endif
  return 0;
}
