/* gnome-sql - GUI front-end
 * Copyright (c) 1998 by Rodrigo Moya

 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <config.h>
#include <gnome.h>

#if !defined(_GNOME_SQL_FE_)
#  define _GNOME_SQL_FE_ 0

/* header files */
#ifdef HAVE_GDA
#include <gda-connection.h>
#else
#include <gnome-sql.h>
#endif

/* data types */
struct GSQLFE_ConnectionInfo
{
#ifdef HAVE_GDA
  Gda_Connection *db;
#else  
  GnomeDatabase *db;
#endif  
  GtkWidget *tab;
  GtkWidget *toolbar;
  GtkWidget *cmd_win;
  GtkWidget *scrolled_window;
  GtkWidget *grid;
};
struct GSQLFE_BrowserInfo
{
  enum
  {
    GSQLFE_BROWSER_TABLES = 0
  } type;
#ifdef HAVE_GDA
  Gda_Connection* db;
#else  
  GnomeDatabase *db;
#endif  
  GList *tables;
  GtkWidget *tab;
  GtkWidget *toolbar;
  GtkWidget *scrolled_window;
  GtkWidget *list;
  GtkWidget *grid_scroll1;
  GtkWidget *grid1;
  GtkWidget *grid_scroll2;
  GtkWidget *grid2;
};

/* configuration stuff */
#define MAX_COMMAND_LIST 100		/* size of stored commands list */

extern void app_load_settings (void);
extern void app_save_settings (void);

/* callback functions */
extern void db_close_connection (GtkWidget *, gpointer );
extern void db_close_all_connections (GtkWidget *, gpointer );
extern void db_commit (GtkWidget *, gpointer );
extern void db_exec_command (GtkWidget *, gpointer );
extern void db_open_connection (GtkWidget *, gpointer );
extern void db_rollback (GtkWidget *, gpointer );
extern void db_set_trace (GtkWidget *, gpointer );
extern void db_start_transaction (GtkWidget *, gpointer );
extern void db_table_browser (GtkWidget *, gpointer );

extern void sql_clear_window (GtkWidget *, gpointer );
extern void sql_copy_text (GtkWidget *, gpointer );
extern void sql_cut_text (GtkWidget *, gpointer );
extern void sql_load_script (GtkWidget *, gpointer );
extern void sql_paste_text (GtkWidget *, gpointer );
extern void sql_refresh_grid (GtkWidget *, gpointer );
extern void sql_run_script (GtkWidget *, gpointer );
extern void sql_save_script (GtkWidget *, gpointer );
extern void sql_select_command (GtkWidget *, gpointer );

/* database functions */
extern struct GSQLFE_ConnectionInfo *db_get_current_connection (void);
#ifndef HAVE_GDA
extern void db_new_connection (GnomeDatabase *);
#endif

/* SQL functions */
extern gchar *sql_get_last_command (void);
extern void sql_store_command (const gchar *);

/* DB Grid functions */
extern GtkWidget *grid_new_empty (GtkWidget *);
#ifdef HAVE_GDA
extern GtkWidget* grid_show_resultset(GtkWidget*, Gda_Recordset*);
#else
extern GtkWidget *grid_show_resultset (GtkWidget *, GnomeSqlRowset *);
#endif

/* object browser */
#ifdef HAVE_GDA
extern void browser_close_all (Gda_Connection*);
#else
extern void browser_close_all (GnomeDatabase *);
#endif
struct GSQLFE_BrowserInfo *browser_get_current_window (void);

#ifdef HAVE_GDA
extern void browser_open_tables(Gda_Connection*);
#else
extern void browser_open_tables (GnomeDatabase *);
#endif
/* UI helper functions */
extern void ui_fill_list (GtkList *, GList *);
extern gchar *ui_get_file_name (gchar *);
extern GtkWidget *ui_get_work_area (void);
extern void ui_load_file_in_text (GtkText *, gchar *);
extern GtkWidget *ui_new_combo_in_table (GtkWidget *, gint , gint , gint , gint );
extern GtkWidget *ui_new_entry_in_table (GtkWidget *, gchar *, gchar *, gint ,
                                        gint , gint , gint );
extern GtkWidget *ui_new_label_in_table (GtkWidget *, gchar *, gint ,
                                         gint , gint , gint );
extern GtkWidget *ui_new_text_in_table (GtkWidget *, gint , gint , 
                                        gint , gint );
extern GtkWidget *ui_new_toolbar_in_table (GtkWidget *, gint , gint , 
                                           gint , gint );
extern void ui_show_error (const gchar *, ...);
                                         
/* global variables */
extern GnomeApp *glb_app;
extern gchar *glb_list_item_data_key;


#endif

