#include <orb/orbit.h>
#include <ctype.h>
#include <stdio.h>
#include <signal.h>
#include <gnome.h>

#include "gda-mysqlsrv.h"
#include "gda-mysql-types.h"
#include "gda-mysql-connection.h"
#include "gda-mysql-command.h"
#include "gda-mysql-error.h"
#include "gda.h"


void Exception( CORBA_Environment* ev )
{
  switch( ev->_major )
    {
    case CORBA_SYSTEM_EXCEPTION:
      g_log("GDA MYSQL", G_LOG_LEVEL_DEBUG, "CORBA system exception %s.\n",
	       CORBA_exception_id(ev));
      exit ( 1 );
    case CORBA_USER_EXCEPTION:
      g_log("GDA MYSQL", G_LOG_LEVEL_DEBUG, "CORBA user exception: %s.\n",
	       CORBA_exception_id( ev ) );
      exit ( 1 );
    default:
      break;
    }
}


      

GDA_Connection
gda_mysql_ConnectionFactory_create(PortableServer_Servant _obj,
				   CORBA_Environment*     ev)
{
  GDAConnection_Servant *new_connection_servant;
  GDA_Connection         new_connection;
  GDAConnectionFactory_Servant* cf_servant = (GDAConnectionFactory_Servant*)_obj;
  PortableServer_ObjectId*      oid;
  
  
  new_connection_servant = g_new0(GDAConnection_Servant, 1);
  new_connection_servant->base._private = 0;
  new_connection_servant->base.vepv     = &poa_gda_connection__vepv;
  new_connection_servant->poa           = cf_servant->poa;
  new_connection_servant->cnc           = gda_mysql_connection_new();

  POA_GDA_Connection__init((PortableServer_Servant) new_connection_servant, ev);
  Exception(ev);
  
  oid = PortableServer_POA_activate_object(cf_servant->poa, new_connection_servant, ev);
  Exception(ev);

  new_connection = PortableServer_POA_servant_to_reference(cf_servant->poa, (PortableServer_Servant)new_connection_servant, ev);
  Exception(ev);

  return new_connection;
}


CORBA_long
gda_mysql_Connection_open(PortableServer_Servant _obj,
			  const CORBA_char*            dsn,
			  const CORBA_char*            user,
			  const CORBA_char*            passwd,			  
			  CORBA_Environment*      env)
{
  GDAConnection_Servant* cnc = (GDAConnection_Servant*) _obj;
  gint  rc;
  
  fprintf(stderr, "gda_mysql_Connection_open: dsn    = '%s'\n", dsn);
  fprintf(stderr, "gda_mysql_Connection_open: user   = '%s'\n", user);
  fprintf(stderr, "gda_mysql_Connection_open: passwd = '%s'\n", passwd);
  rc = gda_mysql_connection_open(cnc->cnc, dsn, user, passwd);
  fprintf(stderr,"gda_mysql_Connection_open: cnc = %p\n", cnc->cnc);
  fprintf(stderr,"                           cnc->mysql = %p\n", cnc->cnc->mysql);
  if (rc < 0)
    return -1;
  else
    return 0;
}

GDA_Recordset
gda_mysql_Connection_openSchema   (PortableServer_Servant _obj,
			     const GDA_Connection_QType t,
			     const GDA_Connection_ConstraintSeq * constraints, CORBA_Environment * ev)
{
  GDAConnection_Servant*   cnc = (GDAConnection_Servant*) _obj;
  GDARecordset_Servant*    new_recset_servant;
  GDA_Recordset            new_recset;
  Gda_MYSQL_Recordset*      recset;
  PortableServer_ObjectId* oid;
  Gda_MYSQL_Error           e;
  
  fprintf(stderr,"gda_Connection_openSchema: constraints->_length = %d\n", constraints->_length);
  fprintf(stderr,"gda_Connection_openSchema: constraints->_maximum = %d\n", constraints->_maximum);
  memset(&e, '\0', sizeof(e));
  return CORBA_OBJECT_NIL;
#if 0  
  if ((recset = gda_mysql_connection_open_schema(cnc->cnc, &e, t, constraints->_buffer, constraints->_length)) == 0)
    return CORBA_OBJECT_NIL;
  new_recset_servant = g_new0(GDARecordset_Servant, 1);
  new_recset_servant->base._private = 0;
  new_recset_servant->base.vepv = &poa_gda_recordset__vepv;
  new_recset_servant->poa = cnc->poa;
  new_recset_servant->recset = recset;

  POA_GDA_Recordset__init((PortableServer_Servant)new_recset_servant, ev);
  Exception(ev);

  oid = PortableServer_POA_activate_object(new_recset_servant->poa, new_recset_servant, ev);
  Exception(ev);

  new_recset = PortableServer_POA_servant_to_reference(new_recset_servant->poa, new_recset_servant, ev);
  Exception(ev);

  return new_recset;
#endif
}

CORBA_long
gda_mysql_Connection_close(PortableServer_Servant _obj,
			   CORBA_Environment*      env)
  {
  GDAConnection_Servant* cnc = (GDAConnection_Servant*) _obj;

  if (gda_mysql_connection_close(cnc->cnc) < 0)
    return -1;
  else
    return 0;
}

GDA_Command
gda_mysql_Connection_createCommand(PortableServer_Servant _obj,
				   CORBA_Environment*     ev)
{
  
  GDACommand_Servant*      new_command_servant;
  GDA_Command              new_command;
  GDAConnection_Servant*   cnc                  = (GDAConnection_Servant*)_obj;
  PortableServer_ObjectId* oid;

  new_command_servant = g_new0(GDACommand_Servant, 1);
  new_command_servant->base._private = 0;
  new_command_servant->base.vepv     = &poa_gda_command__vepv;
  new_command_servant->poa           = cnc->poa;
  new_command_servant->cmd           = gda_mysql_cmd_new();
  new_command_servant->cmd->cnc      = cnc;

  gda_mysql_cmd_set_connection(new_command_servant->cmd, cnc->cnc);
  
  POA_GDA_Command__init((PortableServer_Servant) new_command_servant, ev);
  Exception(ev);

  oid = PortableServer_POA_activate_object(new_command_servant->poa, new_command_servant, ev);

  new_command = PortableServer_POA_servant_to_reference(new_command_servant->poa,
							(PortableServer_Servant)new_command_servant, ev);
  Exception(ev);
  fprintf(stderr,"gda_mysql_Connection_createCommand: left\n");
  fprintf(stderr,"                  cmd = %p\n",  new_command_servant->cmd);
  fprintf(stderr,"                  cmd->cnc = %p\n", new_command_servant->cmd->cnc);
  fprintf(stderr,"                  cmd->cnc->mysql = %p\n", new_command_servant->cmd->cnc->mysql);
  
  return new_command;
}


GDA_Recordset
gda_mysql_Command_execute(PortableServer_Servant _obj,
			  const CORBA_char*      cmd,
			  CORBA_long*            affected,
			  const GDA_CmdParameterSeq* params,
			  CORBA_long             options,
			  CORBA_Environment*     ev)
{
  GDACommand_Servant*      command_servant = (GDACommand_Servant*)_obj;
  GDARecordset_Servant*    new_recset_servant;
  GDA_Recordset            new_recset;
  Gda_MYSQL_Recordset*      recset;
  PortableServer_ObjectId* oid;
  Gda_MYSQL_Error*          error;
  
  fprintf(stderr,"gda_mysql_Command_execute: cmd = '%s'\n", cmd);
  if (command_servant->cmd->cmd) {
    fprintf(stderr,"WARNING WARNING: command string still existing\n");
    g_free(command_servant->cmd->cmd);
  }
  command_servant->cmd->cmd = g_strdup(cmd);
  error = gda_mysql_error_new();
  recset = gda_mysql_cmd_execute(command_servant->cmd, error, params, 0);
  if (!recset)
    {
      if (error->description)
	{
	  GDA_DriverError* exception = GDA_DriverError__alloc();
	  exception->errors._length = 1;
	  exception->errors._buffer = CORBA_sequence_GDA_Error_allocbuf(1);
	  exception->errors._buffer[0].description = CORBA_string_dup(error->description);
	  exception->errors._buffer[0].number      = error->number;
	  exception->errors._buffer[0].source      = CORBA_string_dup(error->source);
	  exception->errors._buffer[0].sqlstate    = CORBA_string_dup(error->sqlstate);
	  exception->errors._buffer[0].nativeMsg   = CORBA_string_dup(error->native);
	  exception->realcommand = CORBA_string_dup("<Unknown>");
	  CORBA_exception_set(ev, CORBA_USER_EXCEPTION, ex_GDA_DriverError, exception);
	}
      gda_mysql_error_free(error);
      return CORBA_OBJECT_NIL;
    }
  gda_mysql_error_free(error);
  new_recset_servant = g_new0(GDARecordset_Servant, 1);
  new_recset_servant->base._private = 0;
  new_recset_servant->base.vepv     = &poa_gda_recordset__vepv;
  new_recset_servant->poa           = command_servant->poa;
  new_recset_servant->recset        = recset;

  POA_GDA_Recordset__init((PortableServer_Servant)new_recset_servant, ev);
  Exception(ev);

  oid = PortableServer_POA_activate_object(new_recset_servant->poa, new_recset_servant, ev);
  Exception(ev);

  new_recset = PortableServer_POA_servant_to_reference(new_recset_servant->poa, new_recset_servant, ev);
  Exception(ev);

  return new_recset;
}


static GDA_Recordset_Chunk*
gda_mysql_Recset_fetch(PortableServer_Servant _obj, CORBA_long count, CORBA_Environment* ev)
{

  GDARecordset_Servant* recset_servant = (GDARecordset_Servant*)_obj;
  Gda_MYSQL_Recordset*  rs = recset_servant->recset;
  GDA_Row*              row;
  gint                  rowidx;
  GDA_Recordset_Chunk*  chunk;
  GDA_Field*            field;

  chunk = GDA_Recordset_Chunk__alloc();
  chunk->_buffer = CORBA_sequence_GDA_Row_allocbuf(count);
  chunk->_length = 0;
  for (rowidx = 0; rowidx < count; rowidx++)
    {
      chunk->_buffer[rowidx]._length = 0;
      chunk->_buffer[rowidx]._buffer = 0;
    }
  rowidx = 0;

  return 0;
}


GDA_Connection_DSNlist*
gda_mysql_Connection_listSources(PortableServer_Servant _obj,
				 CORBA_Environment* ev)
{
  gpointer                 mysql_iterator;
  gchar                    mysql_path[PATH_MAX];
  gchar*                   section_name;
  GList*                   data_sources = 0;
  GDA_Connection_DSNlist*  retval;
  gchar*                   dsn_name;
  GList*                   ptr;
  gint                     idx;

  fprintf(stderr,"gda-mysql: gda_Connection_listSources entered\n");
  retval = GDA_Connection_DSNlist__alloc();

  g_snprintf(mysql_path, sizeof(mysql_path), "=%s/.mysql.ini", gnome_user_home_dir);
  gnome_config_push_prefix(mysql_path);

  mysql_iterator = gnome_config_init_iterator("=/MYSQL Servers");
  while ((mysql_iterator = gnome_config_iterator_next(mysql_iterator, &dsn_name, &section_name)))
    {
      fprintf(stderr,"gda-mysql: dsn_name = '%s', section_name = '%s'\n", dsn_name, section_name);
      data_sources = g_list_append(data_sources, dsn_name);
      g_free(section_name);
    }
  retval->_length = g_list_length(data_sources);
  retval->_buffer = CORBA_sequence_CORBA_string_allocbuf(retval->_length);
  ptr = data_sources;
  idx = 0;
  while(ptr)
    {
      retval->_buffer[idx] = CORBA_string_dup(ptr->data);
      g_free(ptr->data);
      ptr = g_list_next(ptr);
      idx++;
    }
  g_list_free(data_sources);
  /* user servers */
  return retval;
}

      
  
CORBA_Object
gda_mysql_connection_factory__create  (PortableServer_POA poa,   gpointer *impl_ptr,  CORBA_Environment *ev)
{
  GDAConnectionFactory_Servant* servant;
  PortableServer_ObjectId *objid;
  CORBA_Object retval;
  servant = g_new0(GDAConnectionFactory_Servant, 1);
  servant->base._private = NULL;
  servant->base.vepv     = &poa_gda_connectionfactory__vepv;
  servant->poa           = poa;
  POA_GDA_ConnectionFactory__init((PortableServer_Servant)servant, ev);
  objid = PortableServer_POA_activate_object(poa, servant, ev);
  CORBA_free(objid);
  Exception(ev);
  retval =  PortableServer_POA_servant_to_reference(poa, (PortableServer_Servant)servant, ev);
  *impl_ptr = servant;
  return retval;
}

void
gda_mysql_connection_factory__destroy (PortableServer_POA poa,   gpointer impl_ptr,   CORBA_Environment *ev)
{
  ;
}
