/* GNOME DB libary
 * Copyright (C) 1998,1999 Michael Lausch
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __gda_connection_h__
#define __gda_connection_h__ 1

#include <glib.h>
#include <orb/orbit.h>
#include "gda.h"
#include <stdarg.h>
#include "gda-recordset.h"

/* Data Structures and Prototypes for the Gnome DB Access Client
 * Library
 */

 

/*
 * The connection object. The base of all acceess to data sources.
 */

typedef struct _Gda_Connection
{
  CORBA_Object  connection;
  CORBA_ORB     orb;
  GList*        commands;
  GList*        recordsets;
  gchar*        provider;
  gchar*        default_db;
  gchar*        database;
  gchar*        user;
  gchar*        passwd;
  GList*        errors;
  gint          is_open;
}Gda_Connection;


typedef struct _Gda_Constraint_Element
{
  GDA_Connection_QType  type;
  gchar*                value;
} Gda_Constraint_Element;



Gda_Connection*             gda_connection_new               (CORBA_ORB orb);
void                        gda_connection_free              (Gda_Connection* cnc);
GList*                      gda_connection_list_providers    (void);
void                        gda_connection_set_provider      (Gda_Connection* cnc, gchar* name);
const gchar*                gda_connection_get_provider      (Gda_Connection* cnc);
void                        gda_connection_set_default_db    (Gda_Connection* cnc, gchar* dsn);
gint                        gda_connection_open              (Gda_Connection* cnc, gchar* dsn, gchar* user,gchar* pwd );
gint                        gda_connection_close             (Gda_Connection* cnc);
Gda_Recordset*              gda_connection_open_schema       (Gda_Connection* cnc, GDA_Connection_QType t, ...);
Gda_Recordset*              gda_connection_open_schema_array (Gda_Connection* cnc, GDA_Connection_QType t, Gda_Constraint_Element*);
GList*                      gda_connection_get_errors        (Gda_Connection* cnc);
GList*                      gda_connection_list_datasources  (Gda_Connection* cnc);
gint                        gda_connection_begin_transaction (Gda_Connection* cnc);
gint                        gda_connection_commit_transaction (Gda_Connection* cnc);
gint                        gda_connection_rollback_transaction (Gda_Connection* cnc);


/**
 * gda_connection_get_dsn:
 * @cnc: the connection
 *
 * Returns: the name of the data source for @cnc or 0
 */
#define                     gda_connection_get_dsn(cnc)      ((cnc) ? cnc->database : 0)

/**
 * gda_connection_get_user:
 * @cnc: the connection
 *
 * Returns: the username of the conneciton
 */
#define                    gda_connection_get_user(cnc)     ((cnc) ? cnc->user : 0)

#endif

