/* GNOME-DB
 * Copyright (c) 1998 by Rodrigo Moya
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __GDA_POSTGRES_CONNECTION_H__
#  define __GDA_POSTGRES_CONNECTION_H__

#include "gda.h"
#include "gda-common.h"
#include "gda-postgres-types.h"

Gda_POSTGRES_Connection *gda_postgres_connection_new (void);
void                     gda_postgres_connection_free (Gda_POSTGRES_Connection *c);
gint                     gda_postgres_connection_open (Gda_POSTGRES_Connection *c,
						       const gchar *dsn,
						       const gchar *user,
						       const gchar *password);
gint                     gda_postgres_connection_close (Gda_POSTGRES_Connection *c);
Gda_POSTGRES_Recorset   *gda_postgres_connection_open_schema (Gda_POSTGRES_Connection *c,
							      Gda_POSTGRES_Error *err,
							      Gda_Connection_QType *t,
							      Gda_Connection_Constraint *cnt,
							      gint len);

#endif
