/* gnome-sql - GUI front-end
 * Copyright (c) 1998 by Rodrigo Moya
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "gsqlfe.h"

/* global variables */
extern GList     *l_connections;		/* defined in db.c */
extern gint       l_openconns;			/* defined in db.c */
static gboolean   l_isopen = FALSE;
static GtkWidget *l_tab = NULL;
static GtkWidget *l_toolbar = NULL;
static GtkWidget *l_list1 = NULL;
static GtkWidget *l_list2 = NULL;
static GnomeUIInfo errortoolbar[] =
{
  { GNOME_APP_UI_ITEM, N_("Refresh"), N_("Reload connection errors"),
    error_refresh_viewer, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_PIXMAP_REFRESH, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("Clear"), N_("Clear error list"),
    NULL, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_PIXMAP_TRASH, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("Save"), N_("Save error list to file"),
    NULL, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_PIXMAP_SAVE, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("Print"), N_("Print error list"),
    NULL, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_PIXMAP_PRINT, 0, 0, NULL },
  GNOMEUIINFO_SEPARATOR,
  { GNOME_APP_UI_ITEM, N_("Close"), N_("Close this window"),
    error_close_viewer, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_PIXMAP_CLOSE, 0, 0, NULL },
  GNOMEUIINFO_END
};

/* private functions */
void select_connection_cb (GtkWidget *widget, gint row, gint column,
                           GdkEventButton *event, gpointer data)
{
  struct GSQLFE_ConnectionInfo *info;
  gint count = 0;
  gchar *empty = "";
  if (l_isopen)
    {
      info = (struct GSQLFE_ConnectionInfo *) gtk_clist_get_row_data(GTK_CLIST(l_list1), row);
      if (info != NULL)
        {
          GPtrArray *row;
          GList *node;
          /* add new errors from last call to db_show_last_error() */
          error_add_list(info->errors, gda_connection_get_errors(info->db));
          node = g_list_first(info->errors);
          gtk_clist_clear(GTK_CLIST(l_list2));
          gtk_clist_freeze(GTK_CLIST(l_list2));
          while (node != NULL)
            {
              Gda_Error *error = (Gda_Error *) node->data;
              if (error != NULL)
                {
                  row = g_ptr_array_new();
                  if (info != NULL)
                    {
                      g_ptr_array_add(row, (gconstpointer) error->description ? 
                                                           error->description : empty);
                      g_ptr_array_add(row, (gconstpointer) g_strdup_printf("%ld", error->number));
                      gtk_clist_set_column_justification(GTK_CLIST(l_list2), 1,
                                                         GTK_JUSTIFY_RIGHT);
                      g_ptr_array_add(row, (gconstpointer) error->source ?
                                                           error->source : empty);
                      g_ptr_array_add(row, (gconstpointer) error->helpurl ?
                                                           error->helpurl : empty);
                      g_ptr_array_add(row, (gconstpointer) error->sqlstate ?
                                                           error->sqlstate : empty);
                      g_ptr_array_add(row, (gconstpointer) error->native ?
                                                          error->native : empty);
                      gtk_clist_set_column_auto_resize(GTK_CLIST(l_list1), 0, TRUE);
                      gtk_clist_set_column_auto_resize(GTK_CLIST(l_list1), 1, TRUE);
                      gtk_clist_set_column_auto_resize(GTK_CLIST(l_list1), 2, TRUE);
                      gtk_clist_set_column_auto_resize(GTK_CLIST(l_list1), 3, TRUE);
                      gtk_clist_set_column_auto_resize(GTK_CLIST(l_list1), 4, TRUE);
                      gtk_clist_set_column_auto_resize(GTK_CLIST(l_list1), 5, TRUE);
                      gtk_clist_append(GTK_CLIST(l_list2), (gpointer) row->pdata);
                    }
                  g_ptr_array_free(row, TRUE);
                  count++;
                }
              node = g_list_next(node);
            }
          gtk_clist_thaw(GTK_CLIST(l_list2));
        }
      ui_status_bar_message("%d errors found", count);
    }
}

/* attach a list of errors to the existing one */
GList *
error_add_list (GList *error_list, GList *new_list)
{
  if (new_list == NULL) 
    return (error_list);
  error_list = g_list_concat(error_list, new_list);
  return (error_list);
}

/* free a list of Gda_Error objects */
GList *
error_free_list (GList *error_list)
{
  Gda_Error *error;
  GList *node;
  g_return_val_if_fail(error_list != NULL, NULL);

  while ((node = g_list_first(error_list)) != NULL)
    {
      error = (Gda_Error *) node->data;
      gda_error_free(error);
      error_list = g_list_remove(error_list, node->data);
    }
  return (error_list);
}

/* close the error viewer */
void
error_close_viewer (GtkWidget *w, gpointer data)
{
  if (l_isopen)
    {
      gint current = gtk_notebook_page_num(GTK_NOTEBOOK(ui_get_work_area()),
					   l_tab);
      gtk_notebook_remove_page(GTK_NOTEBOOK(ui_get_work_area()), current);
      l_openconns--;
      l_isopen = FALSE;
    }
}

/* open the error viewer */
void
error_open_viewer (GtkWidget *w, gpointer data)
{
  const gchar *connection_titles[] = { _("Provider"), _("DSN") };
  const gchar *error_titles[] = { _("Description"), _("Number"), _("Source"),
                                  _("Help URL"), _("Sqlstate"), _("Native error") };
  /* open the error viewer if not yet */
  if (!l_isopen)
    {
      l_tab = gtk_table_new(3, 4, FALSE);
      gtk_widget_show(l_tab);
      gtk_notebook_append_page(GTK_NOTEBOOK(ui_get_work_area()), l_tab,
                               gtk_label_new("Error Viewer"));
      l_toolbar = ui_new_toolbar_in_table(l_tab, 0, 0, 4, 1);
      gnome_app_fill_toolbar(GTK_TOOLBAR(l_toolbar), errortoolbar, NULL);
      /* create children */
      l_list1 = ui_new_clist_in_table(l_tab, 2, connection_titles, 0, 1, 1, 3);
      gtk_signal_connect(GTK_OBJECT(l_list1), "select_row",
                         GTK_SIGNAL_FUNC(select_connection_cb), NULL);
      l_list2 = ui_new_clist_in_table(l_tab, 6, error_titles, 1, 1, 4, 3);
      /* get all open connections */
      l_isopen = TRUE;
      error_refresh_viewer(w, data);
      l_openconns++;
    }
  /* activate the window */
  ui_set_notebook_page(GTK_NOTEBOOK(ui_get_work_area()), l_tab);
}

/* refresh the error viewer */
void
error_refresh_viewer (GtkWidget *w, gpointer data)
{
  if (l_isopen)
    {
      gint current_row = 0;
      GPtrArray *row;
      GList *node = g_list_first(l_connections);
      /* clear both lists */
      gtk_clist_clear(GTK_CLIST(l_list1));
      gtk_clist_clear(GTK_CLIST(l_list2));
      /* fill connection list */
      gtk_clist_freeze(GTK_CLIST(l_list1));
      while (node != NULL)
        {
          struct GSQLFE_ConnectionInfo *info = (struct GSQLFE_ConnectionInfo *) node->data;
          row = g_ptr_array_new();
          if (info != NULL)
            {
              g_ptr_array_add(row, (gconstpointer) gda_connection_get_provider(info->db));
              g_ptr_array_add(row, (gconstpointer) gda_connection_get_dsn(info->db));
              gtk_clist_set_column_auto_resize(GTK_CLIST(l_list1), 0, TRUE);
              gtk_clist_set_column_auto_resize(GTK_CLIST(l_list1), 1, TRUE);
              gtk_clist_append(GTK_CLIST(l_list1), (gpointer) row->pdata);
              gtk_clist_set_row_data(GTK_CLIST(l_list1), current_row, (gpointer) info);
              current_row++;
            }
          g_ptr_array_free(row, TRUE);
          /* move to next node */
          node = g_list_next(node);
        }
      gtk_clist_thaw(GTK_CLIST(l_list1));
    }
}
