/* gnome-sql - GUI front-end
 * Copyright (c) 1998 by Rodrigo Moya
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "gsqlfe.h"

/* global variables */
static gchar *grid_cols[] = { "" };

/* private functions */

#if !defined(HAVE_GTKSHEET)
static gint
clist_compare_function (GtkCList *list, gconstpointer p1, gconstpointer p2)
{
  return (strcmp((gchar *) p1, (gchar *) p2));
}

static void
select_column_cb (GtkWidget *w, gint col, gpointer data)
{
  gtk_clist_freeze(GTK_CLIST(w));
  gtk_clist_set_sort_column(GTK_CLIST(w), col);
  gtk_clist_sort(GTK_CLIST(w));
  gtk_clist_thaw(GTK_CLIST(w));
  gtk_clist_set_reorderable(GTK_CLIST(w), TRUE);
}
#endif

void
grid_hide_columns_cb (GtkWidget *w, gpointer data)
{
#if defined(HAVE_GTKSHEET)
  gtk_sheet_hide_column_titles(GTK_SHEET(data));
#else
  gtk_clist_column_titles_hide(GTK_CLIST(data));
#endif
}

void
grid_show_columns_cb (GtkWidget *w, gpointer data)
{
#if defined(HAVE_GTKSHEET)
  gtk_sheet_show_column_titles(GTK_SHEET(data));
#else
  gtk_clist_column_titles_show(GTK_CLIST(data));
#endif
}

void
grid_hide_row_numbers_cb (GtkWidget *w, gpointer data)
{
  return;
}

void
grid_show_row_numbers_cb (GtkWidget *w, gpointer data)
{
  return;
}

GnomeUIInfo gridpopupmenu[] =
{
  { GNOME_APP_UI_ITEM, N_("Refresh grid"), N_("Refresh grid contents"),
    NULL, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_REFRESH, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("Print grid"), N_("Print grid contents"),
    NULL, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_PRINT, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("Show columns"), N_("Show column titles"),
    grid_show_columns_cb, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_TOP, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("Hide columns"), N_("Hide column titles"),
    grid_hide_columns_cb, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_BOTTOM, 0, 0, NULL },
#if defined(HAVE_GTKSHEET) && defined(never_define_this)
  { GNOME_APP_UI_ITEM, N_("Show row numbers"), N_("Show row numbers"),
    grid_show_row_numbers_cb, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_LEFT, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("Hide row numbers"), N_("Hide row numbers"),
    grid_hide_row_numbers, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_RIGHT, 0, 0, NULL },
#endif
  GNOMEUIINFO_SEPARATOR,
  { GNOME_APP_UI_ITEM, N_("Edit current row..."), N_("Edit currently selected row"),
    NULL, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_FONT, 0, 0, NULL },
  GNOMEUIINFO_END
};

static GtkWidget *
create_grid (gint cnt, gchar *titles[], GtkContainer *parent)
{
  GtkWidget *grid, *popup_menu;
  register gint i;
  /* create widget */
#if defined(HAVE_GTKSHEET)
  grid = gtk_sheet_new(1, cnt, "A Title");
  for (i = 0; i < cnt; i++)
    {
      gtk_sheet_set_column_title(GTK_SHEET(grid), i, titles[i]);
      /* FIXME: this may be included in configurable options */
      gtk_sheet_column_set_sensitivity(GTK_SHEET(grid), i, TRUE);
    }
  gtk_sheet_show_column_titles(GTK_SHEET(grid));
  gtk_sheet_show_row_titles(GTK_SHEET(grid));
#else
  grid = gtk_clist_new_with_titles(cnt, titles);
  /* FIXME: this may be included in the configuration settings */
  gtk_clist_column_titles_show(GTK_CLIST(grid));
  gtk_clist_column_titles_active(GTK_CLIST(grid));
  gtk_clist_set_selection_mode(GTK_CLIST(grid), GTK_SELECTION_SINGLE);
  gtk_clist_moveto(GTK_CLIST(grid), 0, 0, 0.0, 0.0);
  /* set grid for sorting */
  gtk_signal_connect(GTK_OBJECT(grid), "click_column",
		     GTK_SIGNAL_FUNC(select_column_cb), NULL);
  gtk_clist_set_compare_func(GTK_CLIST(grid), 
			     (GtkCListCompareFunc) clist_compare_function);
  gtk_clist_set_sort_type(GTK_CLIST(grid), GTK_SORT_ASCENDING);
#endif
  gtk_widget_show(grid);
  if (parent != NULL)
    {
      gtk_container_add(parent, grid);
#if defined (HAVE_GTKSHEET)
      gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(parent),
				     GTK_POLICY_ALWAYS,
				     GTK_POLICY_ALWAYS);
#endif
    }
  /* create popup-menu */
  popup_menu = ui_new_popup_menu(grid, &gridpopupmenu, (gpointer) grid);
  return (grid);
}

/* create new DB grid */
GtkWidget *
grid_new_empty (GtkWidget *old_grid, GtkContainer *parent)
{
  GtkWidget *grid;
  /* destroy old grid */
  if (old_grid != NULL)
    gtk_widget_destroy(old_grid);
  /* create new one */
  grid = create_grid(1, grid_cols, parent);
  ui_status_bar_message("0 rows");
  return (grid);
}

/* populate a grid with all rows in a result set */
GtkWidget *
grid_show_resultset (GtkWidget *old_grid, Gda_Recordset *rowset, 
		     GtkContainer *parent)
{
  GtkWidget *grid = NULL;
  GPtrArray *columns;
  gchar *col_name;
  gboolean first = TRUE;
  GdkFont *font;
  register gint cnt, total_fields, total_rows = 0;
  /* check parameters */
  g_return_val_if_fail(rowset != NULL, old_grid);
  /* destroy the old grid */
  if (old_grid != NULL)
    gtk_widget_destroy(old_grid);
  /* create result set columns array */
  columns = g_ptr_array_new();
  if (columns != NULL)
    {
      gulong position = gda_recordset_move(rowset, 1, 0);
      /* add data to grid */
      while (position != GDA_RECORDSET_INVALID_POSITION &&
             !gda_recordset_eof(rowset))
        {
	  Gda_Field *field;
	  register int col;
#if !defined(HAVE_GTKSHEET)
	  GPtrArray *row = g_ptr_array_new();
#endif
	  total_fields = gda_recordset_rowsize(rowset);
	  /* if first time, set columns */
	  if (first)
	    {
	      for (cnt = 0; cnt < total_fields; cnt++)
		{
		  col_name = gda_field_name(gda_recordset_field_idx(rowset, cnt));
		  if (col_name != NULL)
		    g_ptr_array_add(columns, (gconstpointer) col_name);
		}
	      /* create grid */
	      grid = create_grid(total_fields, (gchar **) columns->pdata, parent);
#if defined(HAVE_GTKSHEET)
              gtk_sheet_freeze(GTK_SHEET(grid));
#else
	      gtk_clist_freeze(GTK_CLIST(grid));
#endif
	      first = FALSE;
	    }
	  /* add row to grid */
#if defined(HAVE_GTKSHEET)
          gtk_sheet_add_row(GTK_SHEET(grid), 1);
#endif
	  for (col = 0; col < total_fields; col++)
	    {
	      field = gda_recordset_field_idx(rowset, col);
	      if (field != NULL)
		{
#if defined(HAVE_GTKSHEET)
                  gtk_sheet_set_cell(GTK_SHEET(grid), total_rows, col, 0, 
                                     gda_stringify_value(0, 0, field));
#else
		  g_ptr_array_add(row, gda_stringify_value(0, 0, field));
		  /* set column justification depending on field type */
		  /*
		  switch (gda_field_cType(field))
		    {
		    case GDA_TypeBigint :
		    case GDA_TypeCurrency :
		    case GDA_TypeDecimal :
		    case GDA_TypeDouble :
		    case GDA_TypeInteger :
		    case GDA_TypeNumeric :
		    case GDA_TypeSingle :
		    case GDA_TypeSmallint :
		    case GDA_TypeTinyint :
		    case GDA_TypeUBigint :
		    case GDA_TypeUSmallint :
		      gtk_clist_set_column_justification(GTK_CLIST(grid), col,
							 GTK_JUSTIFY_LEFT);
		      break;
		    default :
		      gtk_clist_set_column_justification(GTK_CLIST(grid), col,
							 GTK_JUSTIFY_RIGHT);
		      break;
		      }
		  */
		  gtk_clist_set_column_auto_resize(GTK_CLIST(grid), col, TRUE);
#endif
		}
	    }
#if !defined(HAVE_GTKSHEET)
	  gtk_clist_append(GTK_CLIST(grid), (gpointer) row->pdata);
	  g_ptr_array_free(row, TRUE);
#endif
	  total_rows++;
	  position = gda_recordset_move(rowset, 1, 0);
	}
#if defined(HAVE_GTKSHEET)
      gtk_sheet_thaw(GTK_SHEET(grid));
#else
      gtk_clist_thaw(GTK_CLIST(grid));
#endif
      g_ptr_array_free(columns, TRUE);
    }
  /* create grid if not yet */
  if (grid == NULL) grid = grid_new_empty(NULL, parent);
  ui_status_bar_message("%ld %s", total_rows, total_rows == 1 ? _("row") : _("rows"));
  return (grid);
}
