/* 
 * GNOME-DB - GUI front-end
 * Copyright (c) 1998 by Rodrigo Moya
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <config.h>
#include <gnome.h>
#if defined(HAVE_GTKSHEET)
#  include <gtksheet.h>
#endif

#if !defined(_GNOME_SQL_FE_)
#  define _GNOME_SQL_FE_ 0

/* GDA library */
#include <gda-command.h>
#include <gda-connection.h>
#include <gda-error.h>
#include <gda-field.h>
#include <gda-recordset.h>
#include <gda-server.h>

/* 
 * configuration stuff 
 */
#define MAX_COMMAND_LIST 100		/* size of stored commands list */

struct GSQLFE_RecentConnection
{
  gchar *provider;
  gchar *database;
  gchar *login;
};

extern void app_add_recent_connection (const gchar *, const gchar *, const gchar *);
extern void app_edit_config_file (GtkWidget *, gpointer );
extern void app_init_gnome_session (void);
extern void app_load_settings (void);
extern void app_save_settings (GtkWidget *, gpointer );

/* 
 * connections 
 */
struct GSQLFE_ConnectionInfo
{
  /* the GDA_Connection object */
  Gda_Connection *db;
  /* notebook tab widgets */
  GtkWidget      *tab;
  GtkWidget      *toolbar;
  GtkWidget      *cmd_win;
  GtkWidget      *scrolled_window;
  GtkWidget      *grid;
  Gda_Command    *command;
  /* database trace */
  GList          *errors;
  gchar          *logfile;
  gboolean        logging_enabled;
};

extern void db_close_connection (GtkWidget *, gpointer );
extern void db_close_all_connections (GtkWidget *, gpointer );
extern void db_commit (GtkWidget *, gpointer );
extern void db_exec_command (GtkWidget *, gpointer );
extern struct GSQLFE_ConnectionInfo *db_get_current_connection (void);
extern void db_new_connection (Gda_Connection *);
extern void db_open_connection (GtkWidget *, gpointer );
extern void db_rollback (GtkWidget *, gpointer );
extern void db_set_trace (GtkWidget *, gpointer );
extern void db_show_last_error (struct GSQLFE_ConnectionInfo *);
extern void db_start_transaction (GtkWidget *, gpointer );
extern void db_view_trace_file (GtkWidget *, gpointer );

/*
 * object browser
 */
struct GSQLFE_BrowserInfo
{
  Gda_Connection *db;
  GtkWidget      *tab;
  GtkWidget      *toolbar;
  GtkWidget      *combo;
  GtkWidget      *scrolled_window;
  GtkWidget      *list;
  GtkWidget      *grid_scroll1;
  GtkWidget      *grid1;
  GtkWidget      *grid_scroll2;
  GtkWidget      *grid2;
  gboolean        is_closing;
};

extern void browser_close_all (Gda_Connection *);
struct GSQLFE_BrowserInfo *browser_get_current_window (void);
extern void browser_new_window (GtkWidget *, gpointer );

/*
 * SQL builder
 */
struct GSQLFE_SQLBuilderInfo
{
  Gda_Connection *db;
  GtkWidget      *tab;
  GtkWidget      *toolbar;
  GtkWidget      *combo;
  GtkWidget      *editbox;
};

extern void sql_builder_close_all (Gda_Connection *);
extern struct GSQLFE_SQLBuilderInfo *sql_builder_get_current_window (void);
extern gchar *sql_get_last_command (void);
extern void sql_clear_window (GtkWidget *, gpointer );
extern void sql_copy_text (GtkWidget *, gpointer );
extern void sql_cut_text (GtkWidget *, gpointer );
extern void sql_load_script (GtkWidget *, gpointer );
extern void sql_new_builder (GtkWidget *, gpointer );
extern void sql_paste_text (GtkWidget *, gpointer );
extern void sql_refresh_grid (GtkWidget *, gpointer );
extern void sql_run_script (GtkWidget *, gpointer );
extern void sql_save_script (GtkWidget *, gpointer );
extern void sql_select_command (GtkWidget *, gpointer );
extern void sql_store_command (const gchar *);

/* 
 * DB Grid
 */
extern GtkWidget *grid_new_empty (GtkWidget *, GtkContainer *);
extern GtkWidget *grid_show_resultset (GtkWidget *, Gda_Recordset *, GtkContainer *);

/* 
 * UI helper functions
 */
extern void ui_fill_list (GtkList *, GList *);
extern void ui_flash_message (const gchar *, ...);
extern gchar *ui_get_file_name (gchar *);
extern GtkWidget *ui_get_work_area (void);
extern void ui_load_file_in_text (GtkText *, gchar *);
extern void ui_insert_file_into_text (GtkText *, gchar *);
extern GtkWidget *ui_new_clist_in_table (GtkWidget *, gint , gchar *[], gint , gint , gint , gint );
extern GtkWidget *ui_new_combo_in_table (GtkWidget *, gint , gint , gint , gint );
extern GtkWidget *ui_new_entry_in_table (GtkWidget *, gchar *, gchar *, gint ,
                                        gint , gint , gint );
extern GtkWidget *ui_new_label_in_table (GtkWidget *, gchar *, gint ,
                                         gint , gint , gint );
extern GtkWidget *ui_new_popup_menu (GtkWidget *, GnomeUIInfo *, gpointer );
extern GtkWidget *ui_new_text_in_table (GtkWidget *, gint , gint , 
                                        gint , gint );
extern GtkWidget *ui_new_toolbar_in_table (GtkWidget *, gint , gint , 
                                           gint , gint );
extern void ui_set_notebook_page (GtkNotebook *, GtkWidget *);
extern void ui_show_error (const gchar *, ...);
extern void ui_show_file_in_window (const gchar *);
extern void ui_status_bar_message (const gchar *, ...);

/*
 * integrated text editor
 */
extern void editor_close_window (GtkWidget *, gpointer );
extern void editor_open_window (GtkWidget *, gpointer );

/*
 * error viewer
 */
extern GList *error_add_list (GList *, GList *);
extern void   error_close_viewer (GtkWidget *, gpointer );
extern GList *error_free_list (GList *);
extern void   error_open_viewer (GtkWidget *, gpointer );
extern void   error_refresh_viewer (GtkWidget *, gpointer );
                       
/*
 * GDA log viewer
 */
extern void log_close_window (GtkWidget *, gpointer );
extern void log_open_window (GtkWidget *, gpointer );
                 
/* 
 * global variables 
 */
extern GnomeApp  *glb_app;
extern gchar     *glb_list_item_data_key;
extern CORBA_ORB  glb_orb;
extern gint       glb_mwx;                  /* main window's geometry */
extern gint       glb_mwy;
extern gint       glb_mww;
extern gint       glb_mwh;
extern GList     *glb_recent_connections;	/* recent connections list */

#endif

