/* gnome-sql - GUI front-end
 * Copyright (c) 1998 by Rodrigo Moya
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* header files */
#include "gsqlfe.h"

/* global variables */
static GList *l_openwins = NULL;
static gint l_openconns = 0;

/* private functions */
static void
close_current_builder (GtkWidget *w, gpointer data)
{
  struct GSQLFE_SQLBuilderInfo *sql_info = sql_builder_get_current_window();
  if (sql_info != NULL)
    {
      gint current = gtk_notebook_page_num(GTK_NOTEBOOK(ui_get_work_area()),
                                           sql_info->tab);
      gtk_notebook_remove_page(GTK_NOTEBOOK(ui_get_work_area()), current);
      l_openwins = g_list_remove(l_openwins, (gpointer) sql_info);
      g_free((gpointer) sql_info);
      l_openconns--;
    }
}

static void
select_combo_cb (GtkWidget *w, gpointer data)
{
  struct GSQLFE_SQLBuilderInfo *sql_info = (struct GSQLFE_SQLBuilderInfo *) data;
  if (sql_info != NULL)
    {
    }
}

/* close all SQL builder windows related with this connection */
void
sql_builder_close_all (Gda_Connection *gdb)
{
  GList *node = g_list_first(l_openwins);
  while (node != NULL)
    {
      struct GSQLFE_SQLBuilderInfo *info = 
             (struct GSQLFE_SQLBuilderInfo *) node->data;
      /* move to next item in list */
      node = g_list_next(node);
      if (info != NULL && info->db == gdb)
        {
          gint this_one =
              gtk_notebook_page_num(GTK_NOTEBOOK(ui_get_work_area()),
                                    info->tab);
          gtk_notebook_remove_page(GTK_NOTEBOOK(ui_get_work_area()),
                                   this_one);
          /* free all memory */
          l_openwins = g_list_remove(l_openwins, info);
          g_free((gpointer) info);
	  l_openconns--;
        }
    }
}

/* return current SQL builder window */
struct GSQLFE_SQLBuilderInfo *
sql_builder_get_current_window (void)
{
  gint this_one;
  gint current = gtk_notebook_current_page(GTK_NOTEBOOK(ui_get_work_area()));
  if (current >= 0)
    {
      GList *node = g_list_first(l_openwins);
      struct GSQLFE_SQLBuilderInfo *sql_info;
      while (node != NULL)
        {
          sql_info = node->data;
          this_one = gtk_notebook_page_num(GTK_NOTEBOOK(ui_get_work_area()),
                                           sql_info->tab);
          if (current == this_one) 
            return (sql_info);
          node = g_list_next(node);
        }
    }
  return (NULL);
}

/* open a new SQL builder window */
GnomeUIInfo sqlbuildertoolbar[] =
{
  { GNOME_APP_UI_ITEM, N_("Copy"), N_("Copy to clipboard"),
    NULL, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_PIXMAP_COPY, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("New"), N_("Start a new query"),
    NULL, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_PIXMAP_NEW, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("Save"), N_("Save to file"),
    NULL, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_PIXMAP_SAVE, 0, 0, NULL },
  GNOMEUIINFO_SEPARATOR,
  { GNOME_APP_UI_ITEM, N_("Close"), N_("Close this window"),
    close_current_builder, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_PIXMAP_CLOSE, 0, 0, NULL },
  GNOMEUIINFO_END
};

void
sql_new_builder (GtkWidget *w, gpointer data)
{
  gchar *str, label[64];
  Gda_Recordset *rowset = NULL;
  struct GSQLFE_SQLBuilderInfo *sql_info;
  struct GSQLFE_ConnectionInfo *conn_info = db_get_current_connection();
  if (conn_info != NULL)
    {
      /* allocate memory */
      if ((sql_info = (struct GSQLFE_SQLBuilderInfo *) 
	   g_malloc(sizeof(struct GSQLFE_SQLBuilderInfo))))
	{
	  sql_info->db = conn_info->db;
	  /* create browser window */
	  sql_info->tab = gtk_table_new(3, 3, FALSE);
	  str = gda_connection_get_dsn(sql_info->db);
	  sprintf(label, "SQL Builder: %s", str);
	  gtk_notebook_append_page(GTK_NOTEBOOK(ui_get_work_area()), sql_info->tab,
				   gtk_label_new(label));
	  g_free((gpointer) str);
	  /* create toolbar */
	  sql_info->toolbar = gtk_toolbar_new(GTK_ORIENTATION_HORIZONTAL, 
					      GTK_TOOLBAR_ICONS);
	  gnome_app_fill_toolbar(GTK_TOOLBAR(sql_info->toolbar),
				 sqlbuildertoolbar, NULL);
	  gtk_table_attach(GTK_TABLE(sql_info->tab), sql_info->toolbar, 
			   0, 3, 0, 1,
			   GTK_FILL | GTK_SHRINK,
			   GTK_FILL | GTK_SHRINK,
			   3, 3);
	  gtk_widget_show(sql_info->toolbar);
	  /* create tables' combo */
	  sql_info->combo = ui_new_combo_in_table(sql_info->tab,
						  0, 1, 1, 2);
	  rowset = gda_connection_open_schema(sql_info->db,
				    GDA_Connection_GDCN_SCHEMA_TABLES,
				    GDA_Connection_no_CONSTRAINT, NULL);
	  if (rowset != NULL)
	    {
	      gchar bfr[128];
	      gulong position = gda_recordset_move(rowset, 1, 0);
	      /* fill the combo with the table list */
	      while (position != GDA_RECORDSET_INVALID_POSITION &&
		     !gda_recordset_eof(rowset))
		{
		  /* get only object name field */
		  Gda_Field *field = gda_recordset_field_idx(rowset, 2);
		  if (field != NULL)
		    {
		      GtkWidget *li = 
			gtk_list_item_new_with_label(gda_stringify_value(bfr, sizeof(bfr), 
									 field));
		      gtk_container_add(GTK_CONTAINER(
				        GTK_COMBO(sql_info->combo)->list), li);
		      gtk_widget_show(li);
		      gtk_object_set_data(GTK_OBJECT(li), glb_list_item_data_key,
					  (gchar *) gda_stringify_value(bfr, sizeof(bfr),
									field));
		    }
		  /* FETCH next row */
		  position = gda_recordset_move(rowset, 1, 0);
		}
	      /* close the record set */
	      gda_recordset_close(rowset);
	      gda_recordset_free(rowset);
	    }
	  else db_show_last_error(conn_info);
	  gtk_signal_connect(GTK_OBJECT(GTK_COMBO(sql_info->combo)->list),
			     "selection_changed",
			     GTK_SIGNAL_FUNC(select_combo_cb), 
			     (gpointer) sql_info);
          /* create the edit box */
          sql_info->editbox = ui_new_text_in_table(sql_info->tab, 1, 2, 3, 3);
	  /* finally, register this window */
	  l_openwins = g_list_append(l_openwins, (gpointer) sql_info);
	  gtk_widget_show(sql_info->tab);
	  ui_set_notebook_page(GTK_NOTEBOOK(ui_get_work_area()), sql_info->tab);
	  l_openconns++;
	}
      else ui_show_error("Cannot allocate %ld bytes", 
			 sizeof(struct GSQLFE_SQLBuilderInfo));
    }
}






