/* GNOME DB
 * Copyright (C) 1998,1999 Michael Lausch
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __GDA_MYSQL_TYPES_H__
#define __GDA_MYSQL_TYPES_H__

#include <glib.h>
#include "gda.h"
#include <mysql/mysql.h>
#include <mysql/mysql_com.h>

struct _Gda_MYSQL_Recordset;

typedef MYSQL_ROW (*Gda_MYSQL_fix_fields)(struct _Gda_MYSQL_Recordset*,  MYSQL_ROW row);
					  

typedef struct _Gda_MYSQL_Recordset
{
  MYSQL*               mysql;
  MYSQL_RES*           mysql_res;
  GList*               fields;
  gint*                order;
  gint                 order_count;
  Gda_MYSQL_fix_fields fix_fields;
  MYSQL_ROW            array;
}Gda_MYSQL_Recordset;

typedef struct _Gda_MYSQL_Connection
{
  gchar* host;
  gchar* db;
  gchar* user;
  gchar* password;
  gchar* port;
  gchar* unix_socket;
  gchar* flags;
  MYSQL* mysql;
  GList* errors;
}Gda_MYSQL_Connection;

typedef struct _Gda_MYSQL_Command
{
  Gda_MYSQL_Connection* cnc;
  gchar*                cmd;
}Gda_MYSQL_Command;


typedef struct _Gda_MYSQL_Parameter
{
} Gda_MYSQL_Parameter;

typedef struct _Gda_MYSQL_Field
{
  gchar*     name;
  gchar*     def;
  enum enum_field_types      native_type;
  gint       defined_length;
  gint       decimals;
  guint      flags;
  GDA_Value* value;
} Gda_MYSQL_Field;




typedef struct _Gda_MYSQL_Error
{
  gchar* description;
  gint   number;
  gchar* source;
  gchar* sqlstate;
  gchar* native;
  gchar* helpfile;
  gchar* helpctxt;
}Gda_MYSQL_Error;

#endif
