/* gnome-sql - GUI front-end
 * Copyright (c) 1998 by Rodrigo Moya
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "gsqlfe.h"
#include <unistd.h>

/* function prototypes */
static void clear_log_file (GtkWidget *, gpointer );
static void reload_file (GtkWidget *, gpointer );
static void save_log_file (GtkWidget *, gpointer );
static void select_list_cb (GtkWidget *, gpointer );

/* global variables */
extern gint l_openconns;
static gboolean l_isopen = FALSE;
static GtkWidget *l_tab = NULL;
static GtkWidget *l_toolbar = NULL;
static GtkWidget *l_scroll = NULL;
static GtkWidget *l_list = NULL;
static GtkWidget *l_viewer = NULL;
static gchar *l_lastlog = NULL;
static GnomeUIInfo logtoolbar[] =
{
  { GNOME_APP_UI_ITEM, N_("Refresh"), N_("Reload log file"),
    reload_file, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_PIXMAP_REFRESH, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("Clear"), N_("Clear file contents"),
    clear_log_file, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_PIXMAP_TRASH, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("Save As..."), N_("Save log file with another name"),
    save_log_file, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_PIXMAP_SAVE_AS, 0, 0, NULL },
  GNOMEUIINFO_SEPARATOR,
  { GNOME_APP_UI_ITEM, N_("Close"), N_("Close this window"),
    log_close_window, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_PIXMAP_CLOSE, 0, 0, NULL },
  GNOMEUIINFO_END
};

/* private functions */
static void
clear_log_file (GtkWidget *w, gpointer data)
{
  if (l_isopen)
    {
      GtkObject *list_item;
      gchar *server;
      GList *node = g_list_first(GTK_LIST(l_list)->selection);
      if (node != NULL)
	{
	  /* get object name */
	  list_item = GTK_OBJECT(node->data);
	  server = gtk_object_get_data(list_item, glb_list_item_data_key);
	  if (server != NULL)
	    {
	      gchar *logfile = g_strdup_printf("/tmp/%s-srv.log", server);
	      /* truncate file */
	      if (truncate(logfile, 0) != 0)
	        ui_show_error("Could not truncate file %s", logfile);
	      else gtk_editable_delete_text(GTK_EDITABLE(l_viewer), 0,
                                            gtk_text_get_length(GTK_TEXT(l_viewer)));
	      g_free((gpointer) logfile);
	    }
	}
    }
}

static void
reload_file (GtkWidget *w, gpointer data)
{
  select_list_cb(w, data);
}

static void
save_log_file (GtkWidget *w, gpointer data)
{
  if (l_isopen)
    {
      gchar *filename = ui_get_file_name("Save log file");
      if (filename != NULL)
	{
	  ui_save_text_to_file(GTK_TEXT(l_viewer), filename);
	  g_free((gpointer) filename);
	}
    }
}

static void
select_list_cb (GtkWidget *w, gpointer data)
{
  if (l_isopen)
    {
      GtkObject *list_item;
      gchar *server;
      GList *node = g_list_first(GTK_LIST(l_list)->selection);
      if (node != NULL)
	{
	  /* get object name */
	  list_item = GTK_OBJECT(node->data);
	  server = gtk_object_get_data(list_item, glb_list_item_data_key);
	  if (server != NULL)
	    {
	      gchar *logfile = g_strdup_printf("/tmp/%s-srv.log", server);
	      ui_load_file_in_text(GTK_TEXT(l_viewer), logfile);
	      g_free((gpointer) logfile);
	    }
	}
    }
}

/* close the log viewer window */
void
log_close_window (GtkWidget *w, gpointer data)
{
  if (l_isopen)
    {
      gint current = gtk_notebook_page_num(GTK_NOTEBOOK(ui_get_work_area()),
					   l_tab);
      /* free list items memory (see log_open_window() */
      gtk_notebook_remove_page(GTK_NOTEBOOK(ui_get_work_area()), current);
      l_openconns--;
      l_isopen = FALSE;
    }
}

/* open the log viewer window */
void
log_open_window (GtkWidget *w, gpointer data)
{
  /* open the log viewer if not yet */
  if (!l_isopen)
    {
      GList *providers;
      l_tab = gtk_table_new(3, 4, FALSE);
      gtk_widget_show(l_tab);
      gtk_notebook_append_page(GTK_NOTEBOOK(ui_get_work_area()), l_tab,
                               gtk_label_new("Log Viewer"));
      l_toolbar = ui_new_toolbar_in_table(l_tab, 0, 0, 4, 1);
      gnome_app_fill_toolbar(GTK_TOOLBAR(l_toolbar), logtoolbar, NULL);
      /* create children */
      l_scroll = gtk_scrolled_window_new(NULL, NULL);
      gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(l_scroll),
                                     GTK_POLICY_AUTOMATIC,
                                     GTK_POLICY_AUTOMATIC);
      gtk_table_attach(GTK_TABLE(l_tab), l_scroll, 0, 1, 1, 3,
                       GTK_SHRINK | GTK_EXPAND | GTK_FILL,
                       GTK_EXPAND | GTK_FILL,
                       3, 3);
      gtk_widget_show(l_scroll);
      l_list = gtk_list_new();
      gtk_signal_connect(GTK_OBJECT(l_list), "selection_changed",
			 GTK_SIGNAL_FUNC(select_list_cb), 
			 NULL);
      gtk_list_set_selection_mode(GTK_LIST(l_list), 
				  GTK_SELECTION_SINGLE);
      gtk_scrolled_window_add_with_viewport(
					    GTK_SCROLLED_WINDOW(l_scroll), 
					    l_list);
      gtk_widget_show(l_list);
      l_viewer = ui_new_text_in_table(l_tab, 1, 1, 4, 3);
      /* fill the screen list with list of providers */
      providers = gda_server_list();
      if (providers == NULL)
	ui_show_error("No GDA servers available");
      while (providers != NULL)
	{
	  gchar *str;
	  Gda_Server *server = (GoadServer *) providers->data;
	  GtkWidget *li = gtk_list_item_new_with_label(server->name);
	  gtk_container_add(GTK_CONTAINER(l_list), li);
	  gtk_widget_show(li);
	  str = g_strdup(server->name);
	  gtk_object_set_data(GTK_OBJECT(li), glb_list_item_data_key,
			      (gchar *) str);
	  providers = g_list_remove(providers, (gpointer) server);
	  gda_server_free(server);
	}
      l_isopen = TRUE;
      l_openconns++;
    }
  /* activate the window */
  ui_set_notebook_page(GTK_NOTEBOOK(ui_get_work_area()), l_tab);
}
