/* gnome-sql - GUI front-end
 * Copyright (c) 1998 by Rodrigo Moya
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* header files */
#include "gsqlfe.h"

#if !defined(GNOMELOCALEDIR)
#  define GNOMELOCALEDIR "/usr/locale"
#endif

/* global variables */
GnomeApp *glb_app = NULL;
GtkWidget *wContainer = NULL, *wWorkArea = NULL, *wStatusBar = NULL;
CORBA_ORB glb_orb;

/* function definitions */
static void prepare_app (void);

/* CORBA exception handler */
void
Exception (CORBA_Environment *ev)
{
  switch (ev->_major)
    {
    /* FIXME: Michael, can I pop up a dialog box here? */
    case CORBA_SYSTEM_EXCEPTION :
      ui_show_error("CORBA system exception %s", CORBA_exception_id(ev));
      exit(1);
    case CORBA_USER_EXCEPTION :
      ui_show_error("CORBA user exception %s", CORBA_exception_id(ev));
      exit(1);
    default :
      break;
    }
}

gint 
main (gint argc, gchar *argv[])
{
  CORBA_Environment ev;
  /* initialize the i18n stuff */
  bindtextdomain(PACKAGE, GNOMELOCALEDIR);
  textdomain(PACKAGE);
  /* initialize CORBA stuff */
  CORBA_exception_init(&ev);
  glb_orb = gnome_CORBA_init("gsqlfe", "0.1", &argc, argv, 0, &ev);
  Exception(&ev);
  /* load application settings and create main window */
  app_init_gnome_session();
  app_load_settings();
  prepare_app();
  /* main loop */
  gtk_main();
  return (0);
}

/* callbacks */
static void 
about_cb (GtkWidget *w, gpointer data)
{
  const gchar *authors[] = { "Michael Lausch <michael@lausch.at>",
			     "Rodrigo Moya <rmoya@chez.com>",
			     NULL };
  GtkWidget *about = gnome_about_new(_("GNOME-SQL"), _("Front-End"),
	     _("Copyright Rodrigo Moya (C) 1998"),
	     authors,
             _("This program is part of the GNOME project for LINUX.\n"
	       "GNOME Data Access comes with ABSOLUTELY NO WARRANTY.\n"
	       "This is free software, and you are welcome to redistribute\n"
	       "it under the conditions of the GNU General Public Licence."),
	     NULL);
  gtk_widget_show(about);
}

static void
move_next_cb (GtkWidget *w, gpointer data)
{
  gtk_notebook_next_page(GTK_NOTEBOOK(wWorkArea));
}

static void
move_prev_cb (GtkWidget *w, gpointer data)
{
  gtk_notebook_prev_page(GTK_NOTEBOOK(wWorkArea));
}

static void 
quit_cb (GtkWidget *w, gpointer data)
{
  editor_close_window(w, data);
  log_close_window(w, data);
  error_close_viewer(w, data);
  designer_close_window(w, data);
  db_close_all_connections(w, data);
  app_save_settings(w, data);
  gtk_main_quit();
}

/* menu definitions */
GnomeUIInfo filemenu[] =
{
  { GNOME_APP_UI_ITEM, N_("New connection..."), N_("Open a new connection"),
    db_open_connection, NULL, NULL, GNOME_APP_PIXMAP_STOCK, 
    GNOME_STOCK_MENU_LINE_IN, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("Disconnect"), N_("Close current connection"),
    db_close_connection, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_STOP, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("Disconnect All"), N_("Close all connections"),
    db_close_all_connections, NULL, NULL, GNOME_APP_PIXMAP_STOCK, 
    GNOME_STOCK_MENU_STOP, 0, 0, NULL },
  GNOMEUIINFO_SEPARATOR,
  { GNOME_APP_UI_ITEM, N_("Quit"), N_("Exit application"),
    quit_cb, NULL, NULL, GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_QUIT, 
    0, 0, NULL },
  GNOMEUIINFO_END
};
GnomeUIInfo editmenu[] =
{
  { GNOME_APP_UI_ITEM, N_("Cut  \t\tCtl+X"), 
    N_("Cut selected text to clipboard"),
    sql_cut_text, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_CUT, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("Copy\t\tCtl+C"), 
    N_("Copy selected text to clipboard"),
    sql_copy_text, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_COPY, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("Paste\t\tCtl+V"), N_("Paste text from clipboard"),
    sql_paste_text, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_PASTE, 0, 0, NULL },
  GNOMEUIINFO_END
};
GnomeUIInfo sqlmenu[] =
{
  { GNOME_APP_UI_ITEM, N_("Run SQL"), N_("Execute command from SQL window"),
      db_exec_command, NULL, NULL, GNOME_APP_PIXMAP_STOCK, 
      GNOME_STOCK_MENU_EXEC, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("Run as Script"), N_("Run SQL buffer as a script"),
    sql_run_script, NULL, NULL, GNOME_APP_PIXMAP_STOCK, 
    GNOME_STOCK_MENU_EXEC, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("Load Script..."), N_("Load SQL script from disk"),
    sql_load_script, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_OPEN, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("Save to file..."), N_("Save current buffer to file"),
    sql_save_script, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_SAVE, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("Select SQL command..."), 
    N_("Select one of the last executed commands"),
    sql_select_command, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_UP, 0, 0, NULL },
  GNOMEUIINFO_SEPARATOR,
  { GNOME_APP_UI_ITEM, N_("Refresh"), N_("Refresh grid"),
    sql_refresh_grid, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_REFRESH, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("Clear Window"), N_("Clear SQL window"),
    sql_clear_window, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_TRASH, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("Print..."), N_("Print grid"),
    NULL, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_PRINT, 0, 0, NULL },
  GNOMEUIINFO_END
};
GnomeUIInfo databasemenu[] =
{
  { GNOME_APP_UI_ITEM, N_("Object Browser"), N_("Browse database objects"),
    browser_new_window, NULL, NULL, GNOME_APP_PIXMAP_NONE, 
    NULL, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("SQL Builder"), N_("Construct SQL statements"),
    sql_new_builder, NULL, NULL, GNOME_APP_PIXMAP_NONE,
    NULL, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("Database Designer"), N_("Visual Database Designer"),
    designer_open_window, NULL, NULL, GNOME_APP_PIXMAP_NONE,
    NULL, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("Error Viewer"), N_("View all errors in the connection"),
    error_open_viewer, NULL, NULL, GNOME_APP_PIXMAP_NONE,
    NULL, 0, 0, NULL },
  GNOMEUIINFO_SEPARATOR,
  { GNOME_APP_UI_TOGGLEITEM, N_("Start/Stop Server Trace"), 
    N_("Start or stop server trace"),
    db_set_trace, NULL, NULL, GNOME_APP_PIXMAP_NONE,
    NULL, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("View Server Trace"),
    N_("View server trace file"),
    db_view_trace_file, NULL, NULL, GNOME_APP_PIXMAP_NONE,
    NULL, 0, 0, NULL },
  GNOMEUIINFO_SEPARATOR,
  { GNOME_APP_UI_ITEM, N_("Begin Transaction"), N_("Begin new transaction"),
    db_start_transaction, NULL, NULL, GNOME_APP_PIXMAP_STOCK, 
    GNOME_STOCK_MENU_LAST, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("Commit"), N_("Commit changes"),
    db_commit, NULL, NULL, GNOME_APP_PIXMAP_STOCK, 
    GNOME_STOCK_MENU_REDO, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("Rollback"), N_("Discard all changes"),
    db_rollback, NULL, NULL, GNOME_APP_PIXMAP_STOCK, 
    GNOME_STOCK_MENU_REVERT, 0, 0, NULL },
  GNOMEUIINFO_END
};
GnomeUIInfo toolsmenu[] =
{
  { GNOME_APP_UI_ITEM, N_("GDA logs"), N_("View GDA server log files"),
    log_open_window, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_BOOK_RED, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("Text editor"), N_("Open the internal text editor"),
    editor_open_window, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_BOOK_RED, 0, 0, NULL },
  GNOMEUIINFO_END
};
GnomeUIInfo optionsmenu[] =
{
  { GNOME_APP_UI_ITEM, N_("Preferences..."), N_("Configure user preferences"),
    NULL, NULL, NULL, GNOME_APP_PIXMAP_STOCK, 
    GNOME_STOCK_MENU_PREF, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("Data Sources..."), N_("Manage system and user data sources"),
    NULL, NULL, NULL, GNOME_APP_PIXMAP_NONE,
    NULL, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("Edit Config File"), N_("Let you access directly the config file"),
    app_edit_config_file, NULL, NULL, GNOME_APP_PIXMAP_NONE,
    NULL, 0, 0, NULL },
  GNOMEUIINFO_SEPARATOR,
  { GNOME_APP_UI_ITEM, N_("Save Options"), N_("Save current configuration"),
    app_save_settings, NULL, NULL, GNOME_APP_PIXMAP_NONE, 
    NULL, 0, 0, NULL },
  GNOMEUIINFO_END
};
GnomeUIInfo windowmenu[] =
{
  { GNOME_APP_UI_ITEM, N_("Previous window"), N_("Move to previous window on list"),
    move_prev_cb, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_BACK, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("Next window"), N_("Move to next window on list"),
    move_next_cb, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_FORWARD, 0, 0, NULL },
  GNOMEUIINFO_END
};
GnomeUIInfo helpmenu[] =
{
  { GNOME_APP_UI_ITEM, N_("Contents"), N_("Online Help"),
    NULL, NULL, NULL, GNOME_APP_PIXMAP_NONE,
    NULL, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("SQL Reference"), N_("A short but concise SQL reference"),
    NULL, NULL, NULL, GNOME_APP_PIXMAP_NONE,
    NULL, 0, 0, NULL },
  GNOMEUIINFO_SEPARATOR,
  { GNOME_APP_UI_ITEM, N_("About gnome-sql..."), N_("About this program"),
    about_cb, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_ABOUT, 0, 0, NULL },
  GNOMEUIINFO_END
};
GnomeUIInfo mainmenu[] =
{
  GNOMEUIINFO_SUBTREE(N_("File"), filemenu),
  GNOMEUIINFO_SUBTREE(N_("Edit"), editmenu),
  GNOMEUIINFO_SUBTREE(N_("SQL"), sqlmenu),
  GNOMEUIINFO_SUBTREE(N_("Database"), databasemenu),
  GNOMEUIINFO_SUBTREE(N_("Tools"), toolsmenu),
  GNOMEUIINFO_SUBTREE(N_("Options"), optionsmenu),
  GNOMEUIINFO_SUBTREE(N_("Window"), windowmenu),
  GNOMEUIINFO_SUBTREE(N_("Help"), helpmenu),
  GNOMEUIINFO_END
};

/* toolbar */
GnomeUIInfo toolbar[] =
{
  { GNOME_APP_UI_ITEM, N_("Connect"), N_("Open a new connection"),
    db_open_connection, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_LINE_IN, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("Disconnect"), N_("Close current connection"),
    db_close_connection, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_STOP, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("GDA Logs"), N_("View GDA server log files"),
    log_open_window, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_BOOK_RED, 0, 0, NULL },
  GNOMEUIINFO_SEPARATOR,
  { GNOME_APP_UI_ITEM, N_("Previous"), N_("Move to previous window on list"),
    move_prev_cb, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_BACK, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("Next"), N_("Move to next window on list"),
    move_next_cb, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_FORWARD, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("Preferences"), N_("Configure user preferences"),
    NULL, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_PREF, 0, 0, NULL },
  GNOMEUIINFO_SEPARATOR,
  { GNOME_APP_UI_ITEM, N_("Exit"), N_("Exit application"),
    quit_cb, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_EXIT, 0, 0, NULL },
  GNOMEUIINFO_END
};

static void 
prepare_app (void)
{
  /* create main window */
  glb_app = gnome_app_new("gsqlfe", "GNOME-SQL");
  gtk_widget_realize(GTK_WIDGET(glb_app));
  gtk_signal_connect(GTK_OBJECT(glb_app), "delete_event",
		     GTK_SIGNAL_FUNC(quit_cb), NULL);
  gtk_signal_connect(GTK_OBJECT(glb_app), "destroy",
                     GTK_SIGNAL_FUNC(quit_cb), NULL);
  /* set main window position according to saved settings */
  gtk_widget_set_uposition(GTK_WIDGET(glb_app), glb_mwx, glb_mwy);
  gtk_widget_set_usize(GTK_WIDGET(glb_app), glb_mww, glb_mwh);
  /* main window container */
  wContainer = gtk_vbox_new(FALSE, 0);
  /* create work area */
  wWorkArea = gtk_notebook_new();
  gtk_notebook_set_tab_pos(GTK_NOTEBOOK(wWorkArea), GTK_POS_BOTTOM);
  gtk_notebook_set_scrollable(GTK_NOTEBOOK(wWorkArea), TRUE);
  gtk_notebook_popup_enable(GTK_NOTEBOOK(wWorkArea));
  gtk_notebook_set_show_border(GTK_NOTEBOOK(wWorkArea), TRUE);
  gtk_notebook_set_tab_border(GTK_NOTEBOOK(wWorkArea), 3);
  gtk_box_pack_start(GTK_BOX(wContainer), wWorkArea, TRUE, TRUE, 0);
  gtk_widget_show(wWorkArea);
  /* show all the widget hierarchy */
  gnome_app_create_toolbar(glb_app, toolbar);
  gnome_app_set_contents(glb_app, wContainer);
  gnome_app_create_menus(glb_app, mainmenu);
  wStatusBar = gnome_appbar_new(TRUE, TRUE, GNOME_PREFERENCES_USER);
  gnome_appbar_set_default(GNOME_APPBAR(wStatusBar), _("Ready"));
  gnome_app_set_statusbar(GNOME_APP(glb_app), wStatusBar);
  gtk_widget_show(wContainer);
  gtk_widget_show(GTK_WIDGET(glb_app));
}
