#include <odbc_inifile.h>


static GScannerConfig odbc_ini_scanner_config =
{
  (
   " \t"
   )			/* cset_skip_characters */,
  (
   G_CSET_a_2_z
   "/_0123456789"
   G_CSET_A_2_Z
   )			/* cset_identifier_first */,
  (
   G_CSET_a_2_z
   "./_-0123456789"
   G_CSET_A_2_Z
   )			/* cset_identifier_nth */,
  ( "#\n" )		/* cpair_comment_single */,
  
  TRUE			/* case_sensitive */,
  
  TRUE			/* skip_comment_multi */,
  TRUE			/* skip_comment_single */,
  TRUE			/* scan_comment_multi */,
  TRUE			/* scan_identifier */,
  TRUE			/* scan_identifier_1char */,
  FALSE			/* scan_identifier_NULL */,
  TRUE			/* scan_symbols */,
  TRUE			/* scan_binary */,
  TRUE			/* scan_octal */,
  TRUE			/* scan_float */,
  TRUE			/* scan_hex */,
  TRUE			/* scan_hex_dollar */,
  TRUE			/* scan_string_sq */,
  TRUE			/* scan_string_dq */,
  FALSE			/* numbers_2_int */,
  FALSE			/* int_2_float */,
  FALSE			/* identifier_2_string */,
  TRUE			/* char_2_token */,
  TRUE			/* symbol_2_token */,
  FALSE			/* scope_0_fallback */,
};

static GString*
odbc_parse_section(GScanner* scanner)
{
  guint       token;
  int         first = 1;
  GString*    sec_name;

  
  sec_name = g_string_new("");
  
  while ((token = g_scanner_get_next_token(scanner)) != G_TOKEN_RIGHT_BRACE)
    {

      if (token == G_TOKEN_EOF)
	{
	  g_string_free(sec_name, 1);
	  return 0;
	}
      
      if (!first)
	{
	  sec_name = g_string_append(sec_name, " ");
	}
      first = 0;
      sec_name = g_string_append(sec_name, scanner->value.v_string);
    }
  return sec_name;
}
  

static ODBC_ini_value_pair*
odbc_parse_valuepair(GScanner* scanner)
{

  guint           token;
  GString*        key;
  GString*        value;
  gint            first = 1;
  ODBC_ini_value_pair* retval = 0;
  
  
  key = g_string_new(scanner->value.v_string);
  
  for(;;)
    {
      token = g_scanner_get_next_token(scanner);

      if (token == G_TOKEN_EOF)
	{
	  g_string_free(key, 1);
	  return 0;
	}
      if (token == G_TOKEN_EQUAL_SIGN)
	{
	  break;
	}
      key = g_string_append(key, " ");
      key = g_string_append(key, scanner->value.v_string);
    }
  value = g_string_new("");
  first = 1;
  
  for(;;)
    {
      token = g_scanner_get_next_token(scanner);
      if (token == G_TOKEN_EOF)
	{
	  g_string_free(key, 1);
	  g_string_free(value, 1);
	  return 0;
	}
      if (token == '\n')
	break;

      if (first)
	{
	  first = 0;
	  value = g_string_append(value, scanner->value.v_string);
	}
      else
	{
	  value = g_string_append(value, " ");
	  value = g_string_append(value, scanner->value.v_string);
	}
    }
  retval = g_malloc0(sizeof(ODBC_ini_value_pair));
  retval->name = key;
  retval->value = value;
  return retval;
}


ODBC_ini_section*
odbc_ini_find_section(GList* sections, gchar* name)
{
  GList* current = sections;

  while(current)
    {
      if (strcmp(((ODBC_ini_section*)current->data)->name->str, name) == 0)
	{
	  return (ODBC_ini_section*)current->data;
	}
      current = g_list_next(current);
    }
  return 0;
}


GString*
odbc_ini_find_value(ODBC_ini_section* section, gchar* key)
{
  GList* vplist = section->value_pairs;

  while(vplist)
    {
      ODBC_ini_value_pair* vp = vplist->data;
      if (strcmp(vp->name->str, key) == 0)
	return vp->value;
      vplist = vplist->next;
    }
  return 0;
}
  


GList*
odbc_ini_parse(FILE* stream, gchar* name)
{
  GScanner* scanner = g_scanner_new(&odbc_ini_scanner_config);
  int done = 0;
  GList*     sections = 0;
  guint      token;
  
  g_scanner_input_file(scanner, fileno(stream));

  scanner->input_name = name;
  while (!done)
    {
      ODBC_ini_value_pair* vp;
      ODBC_ini_section*    is = 0;
      GString*        section;
      gint            in_section = 0;
      
      while (!done)
	{
	  token = g_scanner_get_next_token(scanner);
	  switch (token)
	    {
	    case G_TOKEN_LEFT_BRACE:
	      {
		section = odbc_parse_section(scanner);
		if (!section)
		  break;
		is = g_malloc0(sizeof(ODBC_ini_section));
		is->name = section;
		in_section = 1;
		break;
	      }
	    case G_TOKEN_IDENTIFIER:
	      {
		if (in_section)
		  {
		    vp = odbc_parse_valuepair(scanner);
		    if (!vp)
		      break;
		    is->value_pairs = g_list_append(is->value_pairs, vp);
		  }
		break;
	      }
	    case G_TOKEN_EOF:
	      done = 1;
	      break;
	    }
	  sections = g_list_append(sections, is);
	}
    }
  return sections;
}  

static void
odbc_ini_valuepair_free(ODBC_ini_value_pair* vp)
{
  if (vp->name)
    g_string_free(vp->name, 1);
  if (vp->value)
    g_string_free(vp->value, 1);
}

static void
odbc_ini_section_free(ODBC_ini_section* s)
{
  GList* ptr;

  if (s->name)
    g_string_free(s->name, 0);

  ptr = s->value_pairs;
  while (ptr)
    {
      ODBC_ini_value_pair* vp;
      vp = ptr->data;
      odbc_ini_valuepair_free(vp);
      ptr = g_list_next(ptr);
    }
  g_list_free(ptr);
}


void
odbc_ini_free_all_sections(GList* ss)
{
  GList* ptr = ss;
  while(ptr)
    {
      ODBC_ini_section* s;
      s = ptr->data;
      odbc_ini_section_free(s);
      ptr = g_list_next(ptr);
    }
  g_list_free(ss);
}
