/* GNOME DB libary
 * Copyright (C) 1998,1999 Michael Lausch
 * Copyright (C) 2000 Rodrigo Moya
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __gda_recordset_h__
#define __gda_recordset_h__ 1

#include <glib.h>
#include <orb/orbit.h>

#include <gda.h>

/* Data Structures and Prototypes for the Gnome DB Access Client
 * Library
 */
typedef struct _Gda_Recordset      Gda_Recordset;
typedef struct _Gda_RecordsetClass Gda_RecordsetClass;

#include <gda-command.h>
#include <gda-field.h>

/* The recordset object. Holds the result from executing a
 * command object. Buffering and updateing data is done thrugh these
 * objects. 
 */

#define GDA_TYPE_RECORDSET            (gda_recordset_get_type())
#define GDA_RECORDSET(obj)            GTK_CHECK_CAST(obj, GDA_TYPE_RECORDSET, Gda_Recordset)
#define GDA_RECORDSET_CLASS(klass)    GTK_CHECK_CLASS_CAST(klass, GDA_TYPE_RECORDSET, Gda_RecordsetClass)
#define IS_GDA_RECORDSET(obj)         GTK_CHECK_TYPE(obj, GDA_TYPE_RECORDSET)
#define IS_GDA_RECORDSET_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), GDA_TYPE_RECORDSET))

#define GDA_RECORDSET_INVALID_POSITION 0xffffffff

struct _Gda_Recordset
{
  GtkAdjustment      object;
  Gda_Command*       external_cmd;
  Gda_Command*       internal_cmd;	/* used for cmd object
                                     * generated by gda_recordset_open */
  CORBA_Object       corba_rs;
  Gda_Connection*    cnc;
  CORBA_ORB          orb;
  GList*             chunks;
  gint               chunks_length;
  GDA_Row*           current_row;
  GDA_RowAttributes* field_attributes;
  /* current index(adjustment->value). 0 means invalid, 1 is the first record */
  gulong             current_index;
  /* max index (adjustment->upper), 0 is invalid */
  gulong             max_index;
  gulong             affected_rows;
  gint               maxrows;
  gint               cachesize;
  gint               open;
  gint               eof;
  gint               bof;
  gint               readonly;
  GDA_CursorLocation cursor_location;
  GDA_CursorType     cursor_type;
  GDA_LockType       lock_type;
  gchar*             name;
};

struct _Gda_RecordsetClass
{
  GtkAdjustmentClass parent_class;
  void              (*error)  (Gda_Recordset*, GList*);
  void              (*warning)(Gda_Recordset*, GList*);
  void              (*eof)    (Gda_Recordset*);
  void              (*bof)    (Gda_Recordset*);
};

guint                gda_recordset_get_type       (void);
GtkObject*           gda_recordset_new            (void);
void                 gda_recordset_free           (Gda_Recordset* rs);
void                 gda_recordset_set_name       (Gda_Recordset* rs, gchar* name);
void                 gda_recordset_get_name       (Gda_Recordset* rs, gchar* name);
void                 gda_recordset_close          (Gda_Recordset* rs);
Gda_Field*           gda_recordset_field_name     (Gda_Recordset* rs, gchar* name);
Gda_Field*           gda_recordset_field_idx      (Gda_Recordset* rs, gint   idx);
gint                 gda_recordset_bof            (Gda_Recordset* rs);
gint                 gda_recordset_eof            (Gda_Recordset* rs);
gulong               gda_recordset_move           (Gda_Recordset* rs, 
                                                   gint count, 
                                                   gpointer bookmark);
gulong               gda_recordset_move_first     (Gda_Recordset* rs);
gulong               gda_recordset_move_last      (Gda_Recordset* rs);
gulong               gda_recordset_move_next      (Gda_Recordset* rs);
gulong               gda_recordset_move_prev      (Gda_Recordset* rs);
gint                 gda_recordset_rowsize        (Gda_Recordset* rs);
gulong               gda_recordset_affected_rows  (Gda_Recordset* rs);
gint                 gda_recordset_open           (Gda_Recordset* rs,
                                                   Gda_Command* cmd, 
                                                   GDA_CursorType cursor_type,
                                                   GDA_LockType lock_type,
                                                   gulong options);
gint                 gda_recordset_open_txt       (Gda_Recordset* rs,
                                                   gchar* txt,
                                                   GDA_CursorType cursor_type,
                                                   GDA_LockType lock_type,
                                                   gulong options);
gint                 gda_recordset_set_connection (Gda_Recordset* rs,
                                                   Gda_Connection* cnc);
Gda_Connection*      gda_recordset_get_connection (Gda_Recordset* rs);
gint                 gda_recordset_add_field      (Gda_Recordset* rs, Gda_Field* field);
gint                 gda_recordset_create         (Gda_Recordset* rs);

GDA_CursorLocation   gda_recordset_get_cursorloc  (Gda_Recordset* rs);
void                 gda_recordset_set_cursorloc  (Gda_Recordset* rs,
                                                   GDA_CursorLocation loc );
GDA_CursorType       gda_recordset_get_cursortype (Gda_Recordset* rs);
void                 gda_recordset_set_cursortype (Gda_Recordset* rs,
                                                   GDA_CursorType type);

#endif
