/* Sample Rolodex Application
 * Copyright (C) 1998,1999 Michael Lausch
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __gda_form_h__
#define __gda_form_h__

#include <gtk/gtkwidget.h>
#include <gtk/gtkvbox.h>
#include <gtk/gtkadjustment.h>
#include <gda-connection.h>

#define GDAFORM(obj)             GTK_CHECK_CAST(obj, gdaform_get_type(), Gdaform)
#define GDAFORM_CLASS(klass)     GTK_CHECK_CLASS_CAST(klass, gdaform_get_type(), GdaformClass)
#define IS_GDAFORM(obj)          GTK_CHECK_TYPE(obj, gdaform_get_type())

typedef struct _Gdaform      Gdaform;
typedef struct _GdaformClass GdaformClass;

struct _Gdaform
{
  GtkVBox        vbox;
  GtkWidget*     table;
  gchar*         tablename;
  Gda_Recordset* recset;
  GPtrArray*     entry_fields;
  GtkObject*     adjust;
};


struct _GdaformClass
{
  GtkVBoxClass parent_class;

  void (*data_changed) (Gdaform* form);
};

guint             gdaform_get_type            (void);
GtkWidget*        gdaform_new                 (void);
GtkWidget*        gdaform_new_with_tablename  (gchar* tablename);
gint              gdaform_set_datasource      (Gdaform* form, Gda_Recordset* rs);

#endif

 
  
