/* GNOME DB libary
 * Copyright (C) 1998,1999 Michael Lausch
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include <stdio.h>


#include <libgnorba/gnorba.h>
#include "gda.h"
#include "gda-connection.h"
#include "gda-command.h"
#include "gda-error.h"
#include "gnome-db-login.h"
#include "gnome-db-error.h"

static void create_main_dialog (GtkWidget*);

gchar* provider = 0;
gchar* database = 0;
gchar* username = 0;
gchar* password = 0;


struct poptOption options[] = {
  { "provider", 's', POPT_ARG_STRING, &provider, 0, N_("database provider"), N_("PROVIDER")},
  { "database", 'd', POPT_ARG_STRING, &database, 0, N_("database name"), N_("DATABASE")},
  { "user",     'u', POPT_ARG_STRING, &username, 0, N_("user name"), N_("USER-NAME")},
  { "password", 'p', POPT_ARG_STRING, &password, 0, N_("password"), N_("PASSWORD")},
  {0, 0, 0, 0, 0, 0, 0}
};




void Exception( CORBA_Environment *ev )
{
  switch( ev->_major )
    {
    case CORBA_SYSTEM_EXCEPTION:
      fprintf( stderr, "CORBA system exception %s.\n",
	       CORBA_exception_id(ev));
      exit ( 1 );
    case CORBA_USER_EXCEPTION:
      fprintf( stderr, "CORBA user exception: %s.\n",
	       CORBA_exception_id( ev ) );
      exit ( 1 );
    default:
      break;
    }
}

gint
cb_prev_error(GtkWidget* button, gpointer data)
{
  GnomeDbError* error = GNOME_DB_ERROR(data);
  g_print("cb_prev_error called\n");
  gnome_db_error_prev(error);
  gtk_signal_emit_stop_by_name(GTK_OBJECT(button), "clicked");
  return 1;
}

gint
cb_next_error(GtkWidget* button, gpointer data)
{
  GnomeDbError* error = GNOME_DB_ERROR(data);
  g_print("cb_next_error called\n");
  gnome_db_error_next(error);
  gtk_signal_emit_stop_by_name(GTK_OBJECT(button), "clicked");
  return 1;
}

void
cb_error(GnomeDbLogin* login, gpointer data)
{
  static GtkWidget *dialog = 0;
  
  GnomeDbError* error = GNOME_DB_ERROR(data);
  
  g_print("cb_error called\n");
  
#if 1
  if (!dialog)
    {
      dialog = gnome_dialog_new("GDA Error Dialg",
				GNOME_STOCK_BUTTON_PREV,
				GNOME_STOCK_BUTTON_NEXT,
				GNOME_STOCK_BUTTON_OK, 
				NULL);
      gtk_box_pack_start(GTK_BOX(GNOME_DIALOG(dialog)->vbox), GTK_WIDGET(error),
			 TRUE, TRUE, GNOME_PAD);
      gtk_window_set_modal(GTK_WINDOW(dialog), TRUE);
      gnome_dialog_close_hides(GNOME_DIALOG(dialog), TRUE);

    }
  gnome_db_error_show(error);

  gnome_dialog_button_connect(GNOME_DIALOG(dialog), 0, GTK_SIGNAL_FUNC(cb_prev_error), error);
  gnome_dialog_button_connect(GNOME_DIALOG(dialog), 1, GTK_SIGNAL_FUNC(cb_next_error), error);
  
  gtk_widget_show(GTK_WIDGET(error));
  gtk_widget_show(dialog);
  gnome_dialog_run_and_close(GNOME_DIALOG(dialog));
  gda_error_list_free(gda_connection_get_errors(login->cnc));
#else
  if (!dialog)
    {
      dialog = gtk_window_new(GTK_WINDOW_TOPLEVEL);
      gtk_window_set_title(GTK_WINDOW(dialog), "Error Dialog");
      gtk_container_add(GTK_CONTAINER(dialog), GTK_WIDGET(error));
      gtk_widget_show(GTK_WIDGET(error));
      gtk_widget_show(dialog);
    }
#endif
}


int
main(int argc, char* argv[])
{

  CORBA_ORB orb;
  CORBA_Environment ev;
  Gda_Connection*    cnc;
  GtkWidget*         login;
  GtkWidget*         error;
  
  CORBA_exception_init(&ev);

  orb = gnome_CORBA_init_with_popt_table("gda-client-test1", /* app_id */
					 "0.1",	/* app_version */
					 &argc,
					 argv,
					 options, /* options */
					 0, /* popt_flags */
					 0, /* return_ctx */
					 0, /* gnorba_flags */
					 &ev);

  Exception(&ev);

  cnc = gda_connection_new(orb);
  g_print("provider = '%s', database = '%s'\n", provider, database);
  login = gnome_db_login_new(cnc, provider, database);
  error = gnome_db_error_new(cnc);
  gtk_signal_connect(GTK_OBJECT(login),"error", GTK_SIGNAL_FUNC(cb_error), error);

  create_main_dialog(login);
  gtk_main();
  return (0);
}

static void
do_login(GtkWidget* button, gpointer data)
{
  GnomeDbLogin* login = GNOME_DB_LOGIN(data);
  gnome_db_login_login(login);
}

static void
create_main_dialog (GtkWidget* login)
{
  GtkWidget *dialog;
  
  dialog = gnome_dialog_new("GDA UI Test 2", GNOME_STOCK_BUTTON_OK,
			    GNOME_STOCK_BUTTON_CANCEL, NULL);
  
  gtk_box_pack_start(GTK_BOX(GNOME_DIALOG(dialog)->vbox), login,
                     TRUE, TRUE, GNOME_PAD);
  gtk_widget_show(login);
  gtk_widget_show(dialog);

  gnome_dialog_button_connect(GNOME_DIALOG(dialog),
			      0,
			      GTK_SIGNAL_FUNC(do_login),
			      login);
}
