/* GNOME-DB - GUI front-end
 * Copyright (c) 1998-2000 by Rodrigo Moya
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "gdafe.h"

#if !defined(GNOMELOCALEDIR)
#  define GNOMELOCALEDIR "/usr/locale"
#endif

/* global variables */
GnomeApp*  glb_App = 0;
GtkWidget* glb_WorkArea = 0;
GtkWidget* glb_StatusBar = 0;
CORBA_ORB  glb_Orb;

static void prepare_app (void);

/* CORBA exception handler */
void
Exception (CORBA_Environment *ev)
{
  switch (ev->_major)
    {
    case CORBA_SYSTEM_EXCEPTION :
      gda_ui_show_error("CORBA system exception %s", CORBA_exception_id(ev));
      exit(1);
    case CORBA_USER_EXCEPTION :
      gda_ui_show_error("CORBA user exception %s", CORBA_exception_id(ev));
      exit(1);
    default :
      break;
    }
}

gint 
main (gint argc, gchar *argv[])
{
  CORBA_Environment ev;

  /* initialize the i18n stuff */
  bindtextdomain(PACKAGE, GNOMELOCALEDIR);
  textdomain(PACKAGE);

  /* initialize CORBA stuff */
  CORBA_exception_init(&ev);
  glb_Orb = gnome_CORBA_init("gdafe", VERSION, &argc, argv, 0, &ev);
  Exception(&ev);

  /* load application settings and create main window */
  fe_init_gnome_session();
  fe_load_settings(NULL, NULL);
  prepare_app();

  /* main loop */
  gtk_main();
  return (0);
}

/* callbacks */
static void 
about_cb (GtkWidget *w, gpointer data)
{
  gda_ui_show_about_dialog(_("GNOME-DB Front End"));
}

static void
close_all_cb (GtkWidget *w, gpointer data)
{
  fe_destroy_all_views();
}

static void
close_current_cb (GtkWidget *w, gpointer data)
{
  GtkWidget *view = fe_get_current_view();
  if (view != NULL)
    fe_destroy_view(view);
}

static void
move_next_cb (GtkWidget *w, gpointer data)
{
  gtk_notebook_next_page(GTK_NOTEBOOK(glb_WorkArea));
}

static void
move_prev_cb (GtkWidget *w, gpointer data)
{
  gtk_notebook_prev_page(GTK_NOTEBOOK(glb_WorkArea));
}

static void 
quit_cb (GtkWidget *w, gpointer data)
{
  if (gnome_config_get_int(FE_CONFIG_GENERAL_SAVE_ON_EXIT) != 0)
    {
      fe_save_settings(0, 0);
    }
  fe_destroy_all_views();
  gtk_main_quit();
}

static void
tabs_to_bottom_cb (GtkWidget *w, gpointer data)
{
  gtk_notebook_set_tab_pos(GTK_NOTEBOOK(glb_WorkArea), GTK_POS_BOTTOM);
  gnome_config_set_int(FE_CONFIG_DOCUMENT_TABS, GTK_POS_BOTTOM);
}

static void
tabs_to_left_cb (GtkWidget *w, gpointer data)
{
  gtk_notebook_set_tab_pos(GTK_NOTEBOOK(glb_WorkArea), GTK_POS_LEFT);
  gnome_config_set_int(FE_CONFIG_DOCUMENT_TABS, GTK_POS_LEFT);
}

static void
tabs_to_right_cb (GtkWidget *w, gpointer data)
{
  gtk_notebook_set_tab_pos(GTK_NOTEBOOK(glb_WorkArea), GTK_POS_RIGHT);
  gnome_config_set_int(FE_CONFIG_DOCUMENT_TABS, GTK_POS_RIGHT);
}

static void
tabs_to_top_cb (GtkWidget *w, gpointer data)
{
  gtk_notebook_set_tab_pos(GTK_NOTEBOOK(glb_WorkArea), GTK_POS_TOP);
  gnome_config_set_int(FE_CONFIG_DOCUMENT_TABS, GTK_POS_TOP);
}

/* menu definitions */
GnomeUIInfo filemenu[] =
{
  { GNOME_APP_UI_ITEM, N_("Open connection..."), N_("Open a new connection"),
    fe_login, NULL, NULL, GNOME_APP_PIXMAP_STOCK, 
    GNOME_STOCK_MENU_CONVERT, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("Close connection"), N_("Close current connection"),
    fe_disconnect, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_STOP, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("Close all connections"), N_("Close all connections"),
    fe_disconnect_all, NULL, NULL, GNOME_APP_PIXMAP_STOCK, 
    GNOME_STOCK_MENU_STOP, 0, 0, NULL },
  GNOMEUIINFO_SEPARATOR,
  GNOMEUIINFO_MENU_PRINT_SETUP_ITEM(gda_ui_print_setup_dlg_cb, NULL),
  GNOMEUIINFO_SEPARATOR,
  { GNOME_APP_UI_ITEM, N_("Quit"), N_("Exit application"),
    quit_cb, NULL, NULL, GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_QUIT,
    0, 0, NULL },
  GNOMEUIINFO_END
};
GnomeUIInfo databasemenu[] =
{
  { GNOME_APP_UI_ITEM, N_("Object Browser"), N_("Browse database objects"),
    fe_open_browser, NULL, NULL, GNOME_APP_PIXMAP_NONE, 
    NULL, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("SQL Builder"), N_("Construct SQL statements"),
    NULL, NULL, NULL, GNOME_APP_PIXMAP_NONE,
    NULL, 0, 0, NULL },
  GNOMEUIINFO_SEPARATOR,
  { GNOME_APP_UI_ITEM, N_("Connection Properties"), N_("View connection properties"),
    fe_show_connection_info, NULL, NULL, GNOME_APP_PIXMAP_NONE,
    NULL, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("Start/Stop Server Trace"), N_("Start or stop server trace"),
    fe_set_server_trace, NULL, NULL, GNOME_APP_PIXMAP_NONE,
    NULL, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("View Server Trace"), N_("View server trace file"),
    fe_view_server_trace, NULL, NULL, GNOME_APP_PIXMAP_NONE,
    NULL, 0, 0, NULL },
  GNOMEUIINFO_SEPARATOR,
  { GNOME_APP_UI_ITEM, N_("Export"), N_("Export Data to Different Formats"),
    fe_open_export, NULL, NULL, GNOME_APP_PIXMAP_NONE,
    NULL, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("Import"), N_("Import Data into the Database"),
    fe_open_import, NULL, NULL, GNOME_APP_PIXMAP_NONE,
    NULL, 0, 0, NULL },
  GNOMEUIINFO_SEPARATOR,
  { GNOME_APP_UI_ITEM, N_("Begin Transaction"), N_("Begin new transaction"),
    fe_begin_transaction, NULL, NULL, GNOME_APP_PIXMAP_STOCK, 
    GNOME_STOCK_MENU_LAST, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("Commit"), N_("Commit changes"),
    fe_commit_transaction, NULL, NULL, GNOME_APP_PIXMAP_STOCK, 
    GNOME_STOCK_MENU_REDO, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("Rollback"), N_("Discard all changes"),
    fe_rollback_transaction, NULL, NULL, GNOME_APP_PIXMAP_STOCK, 
    GNOME_STOCK_MENU_REVERT, 0, 0, NULL },
  GNOMEUIINFO_END
};
GnomeUIInfo toolsmenu[] =
{
  { GNOME_APP_UI_ITEM, N_("Database Designer"), N_("Visual Database Designer"),
    fe_open_designer, NULL, NULL, GNOME_APP_PIXMAP_NONE,
    NULL, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("GDA logs"), N_("View GDA server log files"),
    fe_open_log, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_BOOK_RED, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("Text editor"), N_("Open the internal text editor"),
    fe_open_editor, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_PREF, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("Run shell"), N_("Open shell window"),
    fe_run_shell, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_ATTACH, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("Calculator"), N_("Open desktop calculator"),
    fe_util_calculator, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_SCORES, 0, 0, NULL },
  GNOMEUIINFO_SEPARATOR,
  { GNOME_APP_UI_ITEM, N_("GDA Manager"), N_("The GDA configuration tool"),
    fe_run_app, "gda-mgr", NULL, GNOME_APP_PIXMAP_NONE,
    NULL, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("GDA Builder"), N_("The GDA development environment"),
    fe_run_app, "gda-builder", NULL, GNOME_APP_PIXMAP_NONE,
    NULL, 0, 0, NULL },
  GNOMEUIINFO_END
};
GnomeUIInfo optionsmenu[] =
{
  { GNOME_APP_UI_ITEM, N_("Preferences..."), N_("Configure user preferences"),
    fe_open_config, NULL, NULL, GNOME_APP_PIXMAP_STOCK, 
    GNOME_STOCK_MENU_PREF, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("GDA Configuration..."), N_("GDA Configuration"),
    fe_open_gda_config, NULL, NULL, GNOME_APP_PIXMAP_NONE,
    NULL, 0, 0, NULL },
  GNOMEUIINFO_SEPARATOR,
  { GNOME_APP_UI_ITEM, N_("Save Options"), N_("Save current configuration"),
    fe_save_settings, NULL, NULL, GNOME_APP_PIXMAP_NONE,
    NULL, 0, 0, NULL },
  GNOMEUIINFO_END
};
GnomeUIInfo windowtabsmenu[] =
{
  { GNOME_APP_UI_ITEM, N_("Top"), 0,
    tabs_to_top_cb, NULL, NULL, GNOME_APP_PIXMAP_NONE,
    0, 0, 0, 0 },
  { GNOME_APP_UI_ITEM, N_("Bottom"), 0,
    tabs_to_bottom_cb, NULL, NULL, GNOME_APP_PIXMAP_NONE,
    0, 0, 0, 0 },
  { GNOME_APP_UI_ITEM, N_("Left"), 0,
    tabs_to_left_cb, NULL, NULL, GNOME_APP_PIXMAP_NONE,
    0, 0, 0, 0 },
  { GNOME_APP_UI_ITEM, N_("Right"), 0,
    tabs_to_right_cb, NULL, NULL, GNOME_APP_PIXMAP_NONE,
    0, 0, 0, 0 },
  GNOMEUIINFO_END
};
GnomeUIInfo windowmenu[] =
{
  { GNOME_APP_UI_ITEM, N_("Previous window"), N_("Move to previous window on list"),
    move_prev_cb, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_BACK, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("Next window"), N_("Move to next window on list"),
    move_next_cb, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_FORWARD, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("Close current"), N_("Close active window"),
    close_current_cb, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_CLOSE, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("Close all"), N_("Close all open windows"),
    close_all_cb, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_CLOSE, 0, 0, NULL },
  GNOMEUIINFO_SEPARATOR,
  GNOMEUIINFO_SUBTREE(N_("Tabs position"), windowtabsmenu),
  GNOMEUIINFO_END
};
GnomeUIInfo helpmenu[] =
{
  GNOMEUIINFO_HELP("gnome-db"),
  GNOMEUIINFO_SEPARATOR,
  { GNOME_APP_UI_ITEM, N_("About gnome-db..."), N_("About this program"),
    about_cb, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_ABOUT, 0, 0, NULL },
  GNOMEUIINFO_END
};
GnomeUIInfo mainmenu[] =
{
  GNOMEUIINFO_SUBTREE(N_("File"), filemenu),
  GNOMEUIINFO_SUBTREE(N_("Database"), databasemenu),
  GNOMEUIINFO_SUBTREE(N_("Tools"), toolsmenu),
  GNOMEUIINFO_SUBTREE(N_("Options"), optionsmenu),
  GNOMEUIINFO_SUBTREE(N_("Window"), windowmenu),
  GNOMEUIINFO_SUBTREE(N_("Help"), helpmenu),
  GNOMEUIINFO_END
};

/* toolbar */
GnomeUIInfo toolbar[] =
{
  { GNOME_APP_UI_ITEM, N_("Connect"), N_("Open a new connection"),
    fe_login, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_CONVERT, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("Disconnect"), N_("Close current connection"),
    fe_disconnect, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_STOP, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("GDA Logs"), N_("View GDA server log files"),
    fe_open_log, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_BOOK_RED, 0, 0, NULL },
  GNOMEUIINFO_SEPARATOR,
  { GNOME_APP_UI_ITEM, N_("Previous"), N_("Move to previous window on list"),
    move_prev_cb, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_BACK, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("Next"), N_("Move to next window on list"),
    move_next_cb, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_FORWARD, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("Preferences"), N_("Configure user preferences"),
    fe_open_config, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_PREF, 0, 0, NULL },
  GNOMEUIINFO_SEPARATOR,
  { GNOME_APP_UI_ITEM, N_("Quit"), N_("Exit application"),
    quit_cb, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_EXIT, 0, 0, NULL },
  GNOMEUIINFO_END
};

static void 
prepare_app (void)
{
  /* create main window */
  glb_App = GNOME_APP(gnome_app_new("gdafe", "SQL Front End"));
  gtk_window_set_policy(GTK_WINDOW(glb_App), TRUE, TRUE, FALSE);
  gtk_widget_realize(GTK_WIDGET(glb_App));
  gtk_signal_connect(GTK_OBJECT(glb_App), "delete_event",
		     GTK_SIGNAL_FUNC(quit_cb), NULL);
  gtk_signal_connect(GTK_OBJECT(glb_App), "destroy",
                     GTK_SIGNAL_FUNC(quit_cb), NULL);

  /* create work area */
  glb_WorkArea = gda_ui_new_notebook_widget();
  gtk_notebook_set_tab_pos(GTK_NOTEBOOK(glb_WorkArea),
                           gnome_config_get_int(FE_CONFIG_DOCUMENT_TABS));
  
  /* show all the widget hierarchy */
  gnome_app_create_toolbar(glb_App, toolbar);
  gnome_app_set_contents(glb_App, glb_WorkArea);
  gnome_app_create_menus(glb_App, mainmenu);
  glb_StatusBar = gnome_appbar_new(TRUE, TRUE, GNOME_PREFERENCES_USER);
  gnome_appbar_set_default(GNOME_APPBAR(glb_StatusBar), _("Ready"));
  gnome_app_set_statusbar(GNOME_APP(glb_App), glb_StatusBar);
  gnome_app_install_menu_hints(GNOME_APP(glb_App), mainmenu);

  /* get saved window position */
  gdk_window_move(GTK_WIDGET(glb_App)->window,
                  gnome_config_get_int(FE_CONFIG_MAIN_WINDOW_X),
                  gnome_config_get_int(FE_CONFIG_MAIN_WINDOW_Y));
  gtk_widget_set_usize(GTK_WIDGET(glb_App),
                       gnome_config_get_int(FE_CONFIG_MAIN_WINDOW_WIDTH),
                       gnome_config_get_int(FE_CONFIG_MAIN_WINDOW_HEIGHT));
  gtk_widget_show(GTK_WIDGET(glb_App));
  
  /* open connection dialog if user's preferences say so */
  if (gnome_config_get_int(FE_CONFIG_GENERAL_CONNECT_ON_ENTRY))
    {
      fe_login(0, 0);
    }
}
