/* GNOME DB components provider
 * Copyright (C) 2000 Rodrigo Moya
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gda-components.h>

static void new_connection_cb (Gda_ConnectionPool *pool, Gda_Connection *cnc, gpointer user_data);

static Gda_ConnectionPool* cnc_pool = NULL;

/*
 * Callbacks
 */
static void
error_cb (Gda_Connection *cnc, gpointer user_data)
{
  static GtkWidget* error_dialog = NULL;

  g_return_if_fail(IS_GDA_CONNECTION(cnc));

  if (!error_dialog)
    {
      error_dialog = gnome_db_errordlg_new(cnc, _("Error Viewer"));
    }
  gnome_db_errordlg_show_errors(GNOME_DB_ERRORDLG(error_dialog));
}

static void
new_connection_cb (Gda_ConnectionPool *pool, Gda_Connection *cnc, gpointer user_data)
{
  g_return_if_fail(IS_GDA_CONNECTION_POOL(pool));
  g_return_if_fail(IS_GDA_CONNECTION(cnc));

  gtk_signal_connect(GTK_OBJECT(cnc),
		     "error",
		     GTK_SIGNAL_FUNC(error_cb),
		     NULL);
}

/*
 * Public functions
 */
void
components_connection_init (void)
{
  if (!cnc_pool)
    {
      cnc_pool = gda_connection_pool_new();
      gtk_signal_connect(GTK_OBJECT(cnc_pool),
			 "new_connection",
			 GTK_SIGNAL_FUNC(new_connection_cb),
			 NULL);
    }
}

Gda_Connection *
components_connection_open (const gchar *gda_name, const gchar *username, const gchar *password)
{
  g_return_val_if_fail(gda_name != NULL, NULL);

  return gda_connection_pool_open_connection(cnc_pool, gda_name, username, password);
}
