/* GNOME DB components provider
 * Copyright (C) 2000 Rodrigo Moya
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gda-components.h>

gint
main (gint argc, gchar *argv[])
{
  CORBA_Environment ev;

  /* initialize CORBA/bonobo */
  CORBA_exception_init(&ev);
  gnome_CORBA_init("gda-components", VERSION,
		   &argc, argv,
		   GNORBA_INIT_SERVER_FUNC,
		   &ev);
  
  if (ev._major != CORBA_NO_EXCEPTION)
    g_error(_("Could not initialize CORBA"));
  
  if (!bonobo_init(gnome_CORBA_ORB(), NULL, NULL))
    g_error(_("Could not initialize Bonobo"));

  CORBA_exception_free(&ev);

  /* initialize factories */
  components_connection_init();
  components_factory_init();

  bonobo_main();
  return 0;
}
