/* GNOME-DB - Development Environment
 * Copyright (c) 1998 by Rodrigo Moya
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
 
#if !defined(__gda_builder_h__)
#  define __gda_builder_h__

#if defined(HAVE_CONFIG_H)
#  include <config.h>
#endif
#include <bonobo.h>
#include <gda-ui.h>
#include <gnome-db-container.h>

/*
 * UI callbacks
 */
extern void builder_about_cb           (GtkWidget *w, gpointer data);
extern void builder_browse_database_cb (GtkWidget *w, gpointer data);
extern void builder_quit_cb            (GtkWidget *w, gpointer data);

/*
 * Database interface
 */
extern void builder_database_connect        (GtkWidget *w, gpointer data);
extern void builder_database_disconnect     (GtkWidget *w, gpointer data);
extern void builder_database_browse         (void);
extern void builder_database_import_objects (GtkWidget *w, gpointer data);

/*
 * Project window
 */
extern GtkWidget* builder_project_window_open (void);
extern void       builder_project_window_hide (void);
extern void       builder_project_window_show (void);

/*
 * Help system
 */
extern void builder_help_window_open (void);
extern void builder_help_goto        (const gchar *filename);

/*
 * Global variables (defined in gda-builder-main.c)
 */
extern GnomeDbContainer* glb_Container;
extern GtkWidget*        glb_Notebook;
extern CORBA_ORB         glb_Orb;
extern Gda_Connection*   glb_dbconn;

#endif
