/* GNOME DB Front End
 * Copyright (C) 2000 Rodrigo Moya
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "gda-fe.h"

static GtkWidget* login_dialog = NULL;

/*
 * Callbacks
 */
static void
login_error_cb (Gda_Connection *cnc, gpointer data)
{
  g_return_if_fail(IS_GDA_CONNECTION(cnc));
  fe_connection_show_errors(cnc);
}

static void
login_login_cb (Gda_Connection *cnc, gpointer data)
{
  g_return_if_fail(IS_GDA_CONNECTION(cnc));

  if (gda_connection_is_open(cnc))
    {
      gchar* str;
      GnomeDbLogin* login = GNOME_DB_LOGIN(GNOME_DB_LOGINDLG(login_dialog)->login);

      if (login)
	str = gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(login->gda_dbname)->entry));
      else str = NULL;

      fe_connection_open(str, cnc);
      gnome_db_container_set_status(GNOME_DB_CONTAINER(glb_container),
				    _("Connected to '%s'"), str);
      gnome_dialog_close(GNOME_DIALOG(login_dialog));
      login_dialog = NULL;
    }
}

static void
login_cancel_cb (GnomeDbLoginDlg *dlg, gpointer data)
{
  gnome_dialog_close(GNOME_DIALOG(login_dialog));
  login_dialog = NULL;

  gnome_db_container_set_status(GNOME_DB_CONTAINER(glb_container), _("Ready"));
}

/*
 * Public functions
 */
void
fe_about_cb (GtkWidget *w, gpointer data)
{
  gda_ui_show_about_dialog(_("GNOME-DB Front End"));
}

void
fe_activate_connection_batch_cb (GtkWidget *w, gpointer data)
{
  fe_connection_show_batch_window();
}

void
fe_activate_connection_browser_cb (GtkWidget *w, gpointer data)
{
  fe_connection_show_browser_window();
}

void
fe_activate_connection_sql_cb (GtkWidget *w, gpointer data)
{
  fe_connection_show_sql_window();
}

void
fe_begin_transaction_cb (GtkWidget *w, gpointer data)
{
  fe_connection_begin_transaction();
}

void
fe_close_connection_cb (GtkWidget *w, gpointer data)
{
  fe_connection_disconnect();
}

void
fe_commit_transaction_cb (GtkWidget *w, gpointer data)
{
  fe_connection_commit_transaction();
}

void
fe_open_config_cb (GtkWidget *w, gpointer data)
{
  fe_config_open_dialog();
}

void
fe_open_connection_cb (GtkWidget *w, gpointer data)
{
  Gda_Connection* cnc;
  GnomeDbLogin*   login;

  if (!login_dialog)
    {
      cnc = gda_connection_new(gnome_CORBA_ORB());
      login = gnome_db_login_new(cnc, NULL, NULL);
      login_dialog = gnome_db_logindlg_new(login, _("Open Connection"));

      gtk_signal_connect(GTK_OBJECT(cnc),
			 "error",
			 GTK_SIGNAL_FUNC(login_error_cb),
			 NULL);
      gtk_signal_connect_after(GTK_OBJECT(cnc),
			 "open",
			 GTK_SIGNAL_FUNC(login_login_cb),
			 NULL);
      gtk_signal_connect(GTK_OBJECT(login_dialog),
			 "cancel",
			 GTK_SIGNAL_FUNC(login_cancel_cb),
			 NULL);
      gnome_dialog_close_hides(GNOME_DIALOG(login_dialog), TRUE);
    }

  gnome_db_container_set_status(GNOME_DB_CONTAINER(glb_container), _("Connecting..."));

  /* run the dialog */
  while (gtk_events_pending())
    gtk_main_iteration();
  gnome_db_logindlg_popup(GNOME_DB_LOGINDLG(login_dialog));
}

void
fe_open_designer_cb (GtkWidget *w, gpointer data)
{
  fe_designer_open_window();
}

void
fe_open_dsnconfig_cb (GtkWidget *w, gpointer data)
{
  fe_dsnconfig_open_dialog();
}

void
fe_open_log_cb (GtkWidget *w, gpointer data)
{
  fe_log_open_window();
}

void
fe_open_service_manager_cb (GtkWidget *w, gpointer data)
{
  fe_service_open_window();
}

void
fe_quit_cb (GnomeDbContainer *container, gpointer data)
{
  fe_config_save();
  gtk_main_quit();
}

void
fe_rollback_transaction_cb (GtkWidget *w, gpointer data)
{
  fe_connection_rollback_transaction();
}

void
fe_run_app_cb (GtkWidget *w, const gchar *cmd)
{
  gchar* args[1];

  g_return_if_fail(cmd != NULL);

  args[0] = cmd;
  if (gnome_execute_async(NULL, 1, args) == -1)
    gda_ui_show_error(_("Unable to execute '%s'"), args[0]);
}

void
fe_save_config_cb (GtkWidget *w, gpointer data)
{
  fe_config_save();
  gnome_db_container_set_status(GNOME_DB_CONTAINER(glb_container),
				_("Configuration file saved"));
}

void
fe_open_connection_config_cb (GtkWidget *w, gpointer data)
{
  fe_connection_open_config();
}

void
fe_view_connection_props_cb (GtkWidget *w, gpointer data)
{
  fe_connection_view_properties();
}
