/* GNOME DB Interbase Provider
 * Copyright (C) 2000 Rodrigo Moya
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "gda-interbase.h"

static void
fill_field_values (Gda_ServerImplRecordset *recset)
{
}

gboolean
gda_interbase_recordset_new (Gda_ServerImplRecordset *recset)
{
  INTERBASE_Recordset* ib_recset;

  g_return_val_if_fail(recset != NULL, FALSE);

  ib_recset = g_new0(INTERBASE_Recordset, 1);

  /* allocate sqlda area of default size */
  ib_recset->sqlda = (XSQLDA *) g_malloc0(XSQLDA_LENGTH(3));
  ib_recset->sqlda->sqln = 3;
  ib_recset->sqlda->version = 1;

  gda_server_impl_recordset_set_user_data(recset, (gpointer) ib_recset);
  return TRUE;
}

gint
gda_interbase_recordset_move_next (Gda_ServerImplRecordset *recset)
{
  INTERBASE_Recordset*  ib_recset;
  INTERBASE_Connection* ib_cnc;

  g_return_val_if_fail(recset != NULL, -1);
  g_return_val_if_fail(recset->cnc != NULL, -1);

  ib_recset = (INTERBASE_Recordset *) gda_server_impl_recordset_get_user_data(recset);
  if (ib_recset)
    {
      ib_cnc = (INTERBASE_Connection *) gda_server_impl_connection_get_user_data(recset->cnc);
      if (ib_cnc)
	{
	  glong fetch_stat = isc_dsql_fetch(ib_cnc->status, &ib_recset->ib_cmd, 1, ib_recset->sqlda);
	  if (fetch_stat == 0)
	    {
	      fill_field_values(recset);
	      gda_server_impl_recordset_set_at_begin(recset, FALSE);
	      gda_server_impl_recordset_set_at_end(recset, FALSE);
	      return 0;
	    }
	  else if (fetch_stat == 100L) /* EOF */
	    {
	      gda_server_impl_recordset_set_at_end(recset, TRUE);
	      return 1;
	    }
	  gda_server_error_make(gda_server_impl_error_new(), recset, recset->cnc, __PRETTY_FUNCTION__);
	}
    }
  return -1;
}

gint
gda_interbase_recordset_move_prev (Gda_ServerImplRecordset *recset)
{
  INTERBASE_Recordset* ib_recset;

  g_return_val_if_fail(recset != NULL, -1);
  g_return_val_if_fail(recset->cnc != NULL, -1);

  return -1;
}

gint
gda_interbase_recordset_close (Gda_ServerImplRecordset *recset)
{
  return -1;
}

void
gda_interbase_recordset_free (Gda_ServerImplRecordset *recset)
{
  INTERBASE_Recordset* ib_recset;

  g_return_if_fail(recset != NULL);

  ib_recset = (INTERBASE_Recordset *) gda_server_impl_recordset_get_user_data(recset);
  if (ib_recset)
    {
      if (ib_recset->sqlda) g_free((gpointer) ib_recset->sqlda);
      g_free((gpointer) ib_recset);
    }
}
