/* GNOME DB LDAP Provider
 * Copyright (C) 2000 Rodrigo Moya
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#if !defined(__gda_ldap_h__)
#  define __gda_ldap_h__

#if defined(HAVE_CONFIG_H)
#  include <config.h>
#endif

#include <gda-server.h>
#include <lber.h>
#include <ldap.h>

/*
 * Per-object specific structures
 */
typedef struct
{
  LDAP* ldap;
} LDAP_Connection;

typedef struct
{
} LDAP_Command;

typedef struct
{
  LDAP_Command ld_cmd;
} LDAP_Recordset;

/*
 * Server implementation prototypes
 */
gboolean gda_ldap_connection_new (Gda_ServerImplConnection *cnc);
gint gda_ldap_connection_open (Gda_ServerImplConnection *cnc,
				    const gchar *dsn,
				    const gchar *user,
				    const gchar *password);
void gda_ldap_connection_close (Gda_ServerImplConnection *cnc);
gint gda_ldap_connection_begin_transaction (Gda_ServerImplConnection *cnc);
gint gda_ldap_connection_commit_transaction (Gda_ServerImplConnection *cnc);
gint gda_ldap_connection_rollback_transaction (Gda_ServerImplConnection *cnc);
Gda_ServerImplRecordset* gda_ldap_connection_open_schema (Gda_ServerImplConnection *cnc,
							       Gda_ServerImplError *error,
							       GDA_Connection_QType t,
							       GDA_Connection_Constraint *constraints,
							       gint length);
gint gda_ldap_connection_start_logging (Gda_ServerImplConnection *cnc,
					     const gchar *filename);
gint gda_ldap_connection_stop_logging (Gda_ServerImplConnection *cnc);
gchar* gda_ldap_connection_create_table (Gda_ServerImplConnection *cnc,
					      GDA_RowAttributes *columns);
gboolean gda_ldap_connection_supports (Gda_ServerImplConnection *cnc,
					    GDA_Connection_Feature feature);
GDA_ValueType gda_ldap_connection_get_gda_type (Gda_ServerImplConnection *cnc,
						     gulong sql_type);
gshort gda_ldap_connection_get_c_type (Gda_ServerImplConnection *cnc,
					    GDA_ValueType type);
void gda_ldap_connection_free (Gda_ServerImplConnection *cnc);

gboolean gda_ldap_command_new (Gda_ServerImplCommand *cmd);
Gda_ServerImplRecordset* gda_ldap_command_execute (Gda_ServerImplCommand *cmd,
							Gda_ServerImplError *error,
							const GDA_CmdParameterSeq *params,
							gulong *affected,
							gulong options);
void gda_ldap_command_free (Gda_ServerImplCommand *cmd);

gboolean gda_ldap_recordset_new       (Gda_ServerImplRecordset *recset);
gint     gda_ldap_recordset_move_next (Gda_ServerImplRecordset *recset);
gint     gda_ldap_recordset_move_prev (Gda_ServerImplRecordset *recset);
gint     gda_ldap_recordset_close     (Gda_ServerImplRecordset *recset);
void     gda_ldap_recordset_free      (Gda_ServerImplRecordset *recset);

void gda_ldap_error_make (Gda_ServerImplError *error,
			       Gda_ServerImplRecordset *recset,
			       Gda_ServerImplConnection *cnc,
			       gchar *where);

#endif
