/* GDA Manager
 * Copyright (C) 1998,1999 Michael Lausch
 * Copyright (C) 2000 Rodrigo Moya
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "gda-mgr.h"

#if !defined(GNOMELOCALEDIR)
#  define GNOMELOCALEDIR "/usr/locale"
#endif

static guint prepare_app (void);

/* global variables */
GtkWidget*      glb_App = 0;
GtkWidget*      glb_Notebook = 0;
GtkWidget*      glb_StatusBar = 0;
CORBA_ORB       glb_Orb;

/* menus */
GnomeUIInfo filemenu[] =
{
  { GNOME_APP_UI_ITEM, N_("Close"), N_("Close configurator"),
    manager_close_tab_cb, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_CLOSE, 0, 0, NULL },
  GNOMEUIINFO_SEPARATOR,
  GNOMEUIINFO_MENU_PRINT_SETUP_ITEM(gda_ui_print_setup_dlg_cb, NULL),
  GNOMEUIINFO_SEPARATOR,
  { GNOME_APP_UI_ITEM, N_("Quit"), N_("Exit application"),
    manager_quit_cb, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_QUIT, 0, 0, NULL },
  GNOMEUIINFO_END
};
GnomeUIInfo toolsmenu[] =
{
#if defined(HAVE_BONOBO)
  { GNOME_APP_UI_ITEM, N_("GNOME-DB Front End"), N_("The GNOME-DB front end"),
    manager_run_app_cb, "gda-fe", NULL, GNOME_APP_PIXMAP_NONE,
    NULL, 0, 0, NULL },
#else
  { GNOME_APP_UI_ITEM, N_("SQL Front End"), N_("The SQL front end"),
    manager_run_app_cb, "gdafe", NULL, GNOME_APP_PIXMAP_NONE,
    NULL, 0, 0, NULL },
#endif
  { GNOME_APP_UI_ITEM, N_("GNOME-DB Builder"), N_("The GNOME-DB development environment"),
    manager_run_app_cb, "gda-builder", NULL, GNOME_APP_PIXMAP_NONE,
    NULL, 0, 0, NULL },
  GNOMEUIINFO_END
};
GnomeUIInfo helpmenu[] =
{
#if !defined(HAVE_BONOBO)
  GNOMEUIINFO_HELP("gnome-db"),
#endif
  GNOMEUIINFO_SEPARATOR,
  { GNOME_APP_UI_ITEM, N_("About gnome-db..."), N_("About this program"),
    manager_about_cb, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_ABOUT, 0, 0, NULL },
  GNOMEUIINFO_END
};
GnomeUIInfo mainmenu[] =
{
  GNOMEUIINFO_SUBTREE(N_("File"), filemenu),
  GNOMEUIINFO_SUBTREE(N_("Tools"), toolsmenu),
  GNOMEUIINFO_SUBTREE(N_("Help"), helpmenu),
  GNOMEUIINFO_END
};

/* toolbar */
GnomeUIInfo toolbar[] =
{
  { GNOME_APP_UI_ITEM, N_("Close"), N_("Close configurator"),
    manager_close_tab_cb, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_CLOSE, 0, 0, NULL },
  GNOMEUIINFO_SEPARATOR,
  { GNOME_APP_UI_ITEM, N_("Preferences"), N_("Configure user preferences"),
    NULL, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_PREF, 0, 0, NULL },
  GNOMEUIINFO_SEPARATOR,
  { GNOME_APP_UI_ITEM, N_("Quit"), N_("Exit application"),
    manager_quit_cb, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_EXIT, 0, 0, NULL },
  GNOMEUIINFO_END
};

/* CORBA exception handler */
void
Exception (CORBA_Environment *ev)
{
  switch (ev->_major)
    {
    case CORBA_SYSTEM_EXCEPTION :
      gda_ui_show_error("CORBA system exception %s", CORBA_exception_id(ev));
      exit(1);
    case CORBA_USER_EXCEPTION :
      gda_ui_show_error("CORBA user exception %s", CORBA_exception_id(ev));
      exit(1);
    default :
      break;
    }
}

gint 
main (gint argc, gchar *argv[])
{
  CORBA_Environment ev;

  /* initialize the i18n stuff */
  bindtextdomain(PACKAGE, GNOMELOCALEDIR);
  textdomain(PACKAGE);

  /* initialize CORBA stuff */
  CORBA_exception_init(&ev);
  glb_Orb = gnome_CORBA_init("gda-mgr", VERSION, &argc, argv, 0, &ev);
  Exception(&ev);

  /* load application settings and create main window */
  manager_config_load();
#if defined(HAVE_BONOBO)
  if (bonobo_init (glb_Orb, NULL, NULL) == FALSE)
    g_error ("Could not initialize Bonobo\n");
  
  /*
   * We can't make any CORBA calls unless we're in the main
   * loop.  So we delay creating the container here.
   */
  gtk_idle_add ((GtkFunction) prepare_app, NULL);
  bonobo_main();
#else
  prepare_app();

  /* main loop */
  gtk_main();
#endif

  return (0);
}

static guint
prepare_app (void)
{
#if defined(HAVE_BONOBO)
  BonoboUIHandlerMenuItem* list;
#endif

  glb_App = gnome_app_new("gda-mgr", "GDA Manager");
  gtk_widget_realize(GTK_WIDGET(glb_App));
  gtk_signal_connect(GTK_OBJECT(glb_App), "delete_event",
                     GTK_SIGNAL_FUNC(manager_quit_cb), NULL);
  gtk_signal_connect(GTK_OBJECT(glb_App), "destroy",
                     GTK_SIGNAL_FUNC(manager_quit_cb), NULL);

  /* get saved window position */
  gdk_window_move(GTK_WIDGET(glb_App)->window,
                  gnome_config_get_int(MANAGER_CONFIG_MAIN_WINDOW_X),
                  gnome_config_get_int(MANAGER_CONFIG_MAIN_WINDOW_Y));
  gtk_widget_set_usize(GTK_WIDGET(glb_App),
                       gnome_config_get_int(MANAGER_CONFIG_MAIN_WINDOW_WIDTH),
                       gnome_config_get_int(MANAGER_CONFIG_MAIN_WINDOW_HEIGHT));
  gtk_widget_show(GTK_WIDGET(glb_App));
                  
  /* set main window contents */
  gnome_app_create_toolbar(GNOME_APP(glb_App), toolbar);
  glb_Notebook = gda_ui_new_notebook_widget();
  gnome_app_set_contents(GNOME_APP(glb_App), glb_Notebook);

  /* create menus */
#if defined(HAVE_BONOBO)
  glb_UIHandler = bonobo_ui_handler_new();
  bonobo_ui_handler_set_app(glb_UIHandler, GNOME_APP(glb_App));
  bonobo_ui_handler_create_menubar(glb_UIHandler);

  list = bonobo_ui_handler_menu_parse_uiinfo_list(mainmenu);
  bonobo_ui_handler_menu_add_list(glb_UIHandler, "/", list);
  bonobo_ui_handler_menu_free_list(list);
#else
  gnome_app_create_menus(GNOME_APP(glb_App), mainmenu);
#endif

  /* create status bar */
  glb_StatusBar = gnome_appbar_new(TRUE, TRUE, GNOME_PREFERENCES_USER);
  gnome_appbar_set_default(GNOME_APPBAR(glb_StatusBar), _("Ready"));
  gnome_app_set_statusbar(GNOME_APP(glb_App), glb_StatusBar);
  gnome_app_install_menu_hints(GNOME_APP(glb_App), mainmenu);

  gtk_widget_show(glb_App);

  /* add "GDA Configuration" tab */
  manager_gda_init();

  return FALSE;
}

