/* GDA Manager
 * Copyright (C) 1998,1999 Michael Lausch
 * Copyright (C) 2000 Rodrigo Moya
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#if !defined(__gda_mgr_h__)
#  define __gda_mgr_h__

#include <gda-ui.h>
#include <gnome-db-control-widget.h>
#if defined(HAVE_CONFIG_H)
#  include <config.h>
#endif
#if defined(HAVE_BONOBO)
#  include <bonobo.h>
#endif

#define MANAGER_WIDGET_DATA_CONTAINER "MANAGER_Container"

/*
 * UI callbacks
 */
extern void manager_about_cb          (GtkWidget *w, gpointer data);
extern void manager_close_tab_cb      (GtkWidget *w, gpointer data);
extern void manager_load_component_cb (GtkWidget *w, gpointer data);
extern void manager_quit_cb           (GtkWidget *w, gpointer data);
extern void manager_run_app_cb        (GtkWidget *w, const gchar *cmd);
extern void manager_show_props_cb     (GtkWidget *w, gpointer data);

/*
 * GDA configuration
 */
extern void manager_gda_init (void);

extern void manager_config_load (void);
extern void manager_config_save (void);

/*
 * Container for the configuration components
 */
#define MANAGER_TYPE_CONTAINER    (manager_container_get_type())
#define MANAGER_IS_CONTAINER(obj) GTK_CHECK_TYPE(obj, MANAGER_TYPE_CONTAINER)

typedef struct _MANAGER_Container      MANAGER_Container;
typedef struct _MANAGER_ContainerClass MANAGER_ContainerClass;

struct _MANAGER_Container
{
#if defined(HAVE_BONOBO)
  BonoboObject             bonobo_object;
  BonoboPropertyBagClient* pbc;
#else
  GtkObject                object;
#endif
  gchar*                   module;
  GtkWidget*               widget;
};

struct _MANAGER_ContainerClass
{
#if defined(HAVE_BONOBO)
  BonoboObjectClass parent_class;
#else
  GtkObjectClass    parent_class;
#endif
};

extern GtkType            manager_container_get_type  (void);
extern MANAGER_Container* manager_container_new       (const gchar *module,
						       const gchar *dsn,
						       const gchar *username,
						       const gchar *password);
extern void               manager_container_close     (MANAGER_Container *container);
extern void               manager_container_close_all (void);

extern MANAGER_Container* manager_container_find      (const gchar* module);

/*
 * Global variables
 */
extern GtkWidget*       glb_App;
extern GtkWidget*       glb_Notebook;
extern GtkWidget*       glb_StatusBar;
extern CORBA_ORB        glb_Orb;
#if defined(HAVE_BONOBO)
extern BonoboUIHandler* glb_UIHandler;
#endif

/*
 * Configuration files strings
 */
#define MANAGER_CONFIG_MAIN_WINDOW_X            "/gda-mgr/Placement/x"
#define MANAGER_CONFIG_MAIN_WINDOW_Y            "/gda-mgr/Placement/y"
#define MANAGER_CONFIG_MAIN_WINDOW_WIDTH        "/gda-mgr/Placement/width"
#define MANAGER_CONFIG_MAIN_WINDOW_HEIGHT       "/gda-mgr/Placement/height"
#define MANAGER_CONFIG_DOCUMENT_TABS            "/gda-mgr/Placement/DocTabs"

#endif
