/* GNOME DB
 * Copyright (C) 1999 Michael Lausch
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdlib.h>
#include <stdio.h>
#include <locale.h>
#include "gda-mysql-misc.h"

GDA_ValueType
gda_mysql_sql2gdatype(Gda_MYSQL_Field* field)
{
  fprintf(stderr,"gda_mysql_sql2gdatype: input = %d\n", field->native_type);
  switch (field->native_type)
    {
    case FIELD_TYPE_DECIMAL:
      return GDA_TypeDecimal;
    case FIELD_TYPE_TINY:
      return GDA_TypeTinyint;
    case FIELD_TYPE_SHORT:
      return GDA_TypeSmallint;
    case FIELD_TYPE_LONG:
      return GDA_TypeBigint;
    case FIELD_TYPE_FLOAT:
      return GDA_TypeSingle;
    case FIELD_TYPE_DOUBLE:
      return GDA_TypeDouble;
    case FIELD_TYPE_NULL:
      return GDA_TypeNull;
    case FIELD_TYPE_NEWDATE:
    case FIELD_TYPE_TIMESTAMP:
      return GDA_TypeDbTimestamp;
    case FIELD_TYPE_LONGLONG:
      return GDA_TypeUBigint;
    case FIELD_TYPE_INT24:
      return GDA_TypeBigint;
    case FIELD_TYPE_DATE:
      return GDA_TypeDbDate;
    case FIELD_TYPE_TIME:
      return GDA_TypeDbTime;
    case FIELD_TYPE_DATETIME:
      return GDA_TypeDbTimestamp;
    case FIELD_TYPE_YEAR:
      return GDA_TypeInteger;
    case FIELD_TYPE_ENUM:
      return GDA_TypeVarbin;
    case FIELD_TYPE_SET:
      return GDA_TypeVarbin;
    case FIELD_TYPE_TINY_BLOB:
    case FIELD_TYPE_MEDIUM_BLOB:
      return GDA_TypeVarbin;
    case FIELD_TYPE_LONG_BLOB:
    case FIELD_TYPE_BLOB:
      return GDA_TypeLongvarbin;
    case FIELD_TYPE_VAR_STRING:
    case FIELD_TYPE_STRING:
      return GDA_TypeVarchar;
    }
      return GDA_TypeNull;
}

void
gda_mysql_mysql2gdavalue(gpointer mysql_value, GDA_Field* field, GDA_ValueType requested_type)
{
  
  field->realValue._d = 0;
  switch(requested_type)
    {
    case GDA_TypeBigint:
      field->realValue._u.v._u.ll = strtoll((gchar*)mysql_value, 0, 10);
      break;
    case GDA_TypeUBigint:
      field->realValue._u.v._u.ull = strtoull((gchar*)mysql_value, 0, 10);
      break;
    case GDA_TypeVarchar:
      field->realValue._u.v._u.lvc = CORBA_string_dup((gchar*)mysql_value);
      break;
    default:
      g_error("Unknown GDA type %d in gda_mysql_mysql2gdavalue\n", requested_type);
    }
}


void
gda_mysql_gdavalue2mysql(GString* cmd_string, GDA_FieldValue* value)
{
  setlocale(LC_ALL, "C");
  if (value->_d)
    {
      /* it's a NULL value */      
      g_string_append(cmd_string, " NULL ");
      setlocale(LC_ALL, "");
      return;
    }
  switch(value->_u.v._d)
    {
    case GDA_TypeTinyint:
      g_string_sprintfa(cmd_string, "%d", value->_u.v._u.c);
      break;
    case GDA_TypeBigint:
      g_string_sprintfa(cmd_string, "%Ld", value->_u.v._u.ll);
      break;
    case GDA_TypeBoolean:
      g_string_sprintfa(cmd_string, "%d", value->_u.v._u.b ? 1 : 0);
      break;
    case GDA_TypeDbDate:
      /* FIXME: Should be put some Y2K stuff in here? */
      g_string_sprintfa(cmd_string, "'%d-%d-%d'",value->_u.v._u.dbd.year,value->_u.v._u.dbd.month,value->_u.v._u.dbd.day); /* CHECK ME */
      break;
    case GDA_TypeDate:
      g_error("Date/Time: Conversion from GDA type GDA_Date. Sorry."); /* FIXME */
      break;
    case GDA_TypeDbTime:
      g_string_sprintfa(cmd_string, "'%d:%d:%d'",value->_u.v._u.dbt.hour,value->_u.v._u.dbt.minute,value->_u.v._u.dbt.second); /* CHECK ME */
      break;
    case GDA_TypeDbTimestamp:
      /* FIXME: Should be put some Y2K stuff in here? */
      g_string_sprintfa(cmd_string, "'%d-%d-%d %d:%d:%d'",value->_u.v._u.dbd.year,value->_u.v._u.dbd.month,value->_u.v._u.dbd.day,value->_u.v._u.dbt.hour,value->_u.v._u.dbt.minute,value->_u.v._u.dbt.second); /* CHECK ME */
      break;
    case GDA_TypeDouble:
      g_string_sprintfa(cmd_string, "%g", value->_u.v._u.dp);
      break;
    case GDA_TypeInteger:
      g_string_sprintfa(cmd_string, "%d", value->_u.v._u.i);
      break;
    case GDA_TypeBinary:
    case GDA_TypeVarbin:
    case GDA_TypeVarwchar:
    case GDA_TypeLongvarwchar:
    case GDA_TypeLongvarbin:
      {
	gchar* bfr = g_new(char, value->_u.v._u.lvb._length * 2 + 1);
	mysql_escape_string(bfr, value->_u.v._u.lvb._buffer, value->_u.v._u.lvb._length);
	g_string_append(cmd_string, bfr);
	g_free(bfr);
      }
      break;
    case GDA_TypeFixbin:
    case GDA_TypeFixwchar:
    case GDA_TypeFixchar:
      {
	gchar* bfr = g_new(char, value->_u.v._u.fb._length * 2 + 1);
	mysql_escape_string(bfr, value->_u.v._u.fb._buffer, value->_u.v._u.fb._length);
	g_string_append(cmd_string, bfr);
	g_free(bfr);
      }
      break;
    case GDA_TypeCurrency:
    case GDA_TypeDecimal:
    case GDA_TypeNumeric:
    case GDA_TypeChar:
    case GDA_TypeVarchar:
    case GDA_TypeLongvarchar:

      {
	gchar* bfr = g_new(char, strlen(value->_u.v._u.lvc) * 2 + 1);
	mysql_escape_string(bfr, value->_u.v._u.lvc, strlen(value->_u.v._u.lvc));
	g_string_append(cmd_string, bfr);
	g_free(bfr);
      }
      break;
    case GDA_TypeSingle:
      g_string_sprintfa(cmd_string, "%g", value->_u.v._u.f);
      break;
    case GDA_TypeSmallint:
      g_string_sprintfa(cmd_string, "%dh", value->_u.v._u.si);
      break;
    case GDA_TypeUBigint:
      g_string_sprintfa(cmd_string, "%Lu", value->_u.v._u.ull);
      break;
    case GDA_TypeUSmallint:
      g_string_sprintfa(cmd_string, "%uh", value->_u.v._u.us);
      break;
    default:
      g_error("Default: Conversion from GDA type %d NYI", value->_u.v._d);
    }
  
  setlocale(LC_ALL, "");
}
