/* GNOME DB ODBC Config Component
 * Copyright (C) 2000 Rodrigo Moya
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gnome.h>
#include <libgnorba/gnorba.h>
#include <bonobo.h>
#include <gnome-db-control.h>
#include <odbcconfig.h>
#if defined(HAVE_CONFIG_H)
#  include <config.h>
#endif

static GtkWidget* create_widget_cb (void);
static void       new_instance_cb  (GnomeDbControl *control,
				    GnomeDbControlInstance *control_instance,
				    gpointer user_data);

int
main (int argc, char *argv[])
{
  CORBA_Environment ev;
  GnomeDbControl*   control;

  /* initialize CORBA/bonobo */
  CORBA_exception_init(&ev);
  gnome_CORBA_init("gda-odbc-config", VERSION,
		   &argc, argv,
		   GNORBA_INIT_SERVER_FUNC,
		   &ev);

  if (ev._major != CORBA_NO_EXCEPTION)
    g_error(_("Could not initialize CORBA"));

  if (!bonobo_init(gnome_CORBA_ORB(), NULL, NULL))
    g_error(_("Could not initialize Bonobo"));

  CORBA_exception_free(&ev);

  /* initialize widget factory */
  control = gnome_db_control_new("gda-odbc-config", create_widget_cb);
  gtk_signal_connect(GTK_OBJECT(control),
		     "new_instance",
		     GTK_SIGNAL_FUNC(new_instance_cb),
		     NULL);
  if (!control)
    g_error(_("Could not create GnomeDbControl"));

  bonobo_main();
  return 0;
}

static GtkWidget *
create_widget_cb (void)
{
  GtkWidget* w;

  w = gtk_odbcconfig_new();
  return w;
}

static void
new_instance_cb (GnomeDbControl *control,
		 GnomeDbControlInstance *control_instance,
		 gpointer user_data)
{
  g_print(_("new instance %p created"), control_instance);
}




