#include <stdio.h>

#include "gda.h"
#include "gda-connection.h"
#include "gda-types.h"
#include "gda-error.h"
#include "gda-command.h"
#include "gda-odbc-misc.h"

/*** App-specific servant structures ***/

typedef struct {
   POA_GNOME_GenericFactory servant;
   PortableServer_POA poa;

} impl_POA_GNOME_GenericFactory;

typedef struct {
   POA_GDA_Fieldx servant;
   PortableServer_POA poa;

} impl_POA_GDA_Fieldx;

typedef struct {
   POA_GDA_Parameter servant;
   PortableServer_POA poa;

} impl_POA_GDA_Parameter;

typedef struct {
   POA_GDA_Command servant;
   PortableServer_POA poa;
   CORBA_long attr_cmdTimeout;

   CORBA_boolean attr_prepared;

   CORBA_long attr_state;

   Gda_ODBC_Command*  cmd;
} impl_POA_GDA_Command;

typedef struct {
   POA_GDA_Connection servant;
   PortableServer_POA poa;

   CORBA_long attr_flags;

   CORBA_long attr_cmdTimeout;

   CORBA_long attr_connectTimeout;

   GDA_CursorLocation attr_cursor;

   CORBA_char *attr_version;

   GDA_ErrorSeq attr_errors;

   Gda_ODBC_Connection*  cnc;
} impl_POA_GDA_Connection;

typedef struct {
   POA_GDA_Recordset servant;
   PortableServer_POA poa;

   CORBA_long attr_currentBookmark;

   CORBA_long attr_cachesize;

   GDA_CursorType attr_currentCursorType;

   GDA_LockType attr_lockingMode;

   CORBA_long attr_maxrecords;

   CORBA_long attr_pagecount;

   CORBA_long attr_pagesize;

   CORBA_long attr_recCount;

   CORBA_char *attr_source;

   CORBA_long attr_status;

   Gda_ODBC_Recordset*   rs;
} impl_POA_GDA_Recordset;

typedef struct {
   POA_GDA_ConnectionFactory servant;
   PortableServer_POA poa;

} impl_POA_GDA_ConnectionFactory;

/*** Implementation stub prototypes ***/

static void impl_GNOME_GenericFactory__destroy(impl_POA_GNOME_GenericFactory * servant,
					       CORBA_Environment * ev);

static CORBA_boolean
 impl_GNOME_GenericFactory_supports(impl_POA_GNOME_GenericFactory * servant,
				    CORBA_char * obj_goad_id,
				    CORBA_Environment * ev);

static CORBA_Object
 impl_GNOME_GenericFactory_create_object(impl_POA_GNOME_GenericFactory * servant,
					 CORBA_char * goad_id,
					 GNOME_stringlist * params,
					 CORBA_Environment * ev);

static void impl_GDA_Fieldx__destroy(impl_POA_GDA_Fieldx * servant,
				     CORBA_Environment * ev);
static CORBA_long
 impl_GDA_Fieldx_appendChunk(impl_POA_GDA_Fieldx * servant,
			     GDA_VarBinString * data,
			     CORBA_Environment * ev);

static GDA_VarBinString *
 impl_GDA_Fieldx_getChunk(impl_POA_GDA_Fieldx * servant,
			  CORBA_long amount,
			  CORBA_Environment * ev);

static void impl_GDA_Parameter__destroy(impl_POA_GDA_Parameter * servant,
					CORBA_Environment * ev);

static CORBA_long
 impl_GDA_Parameter_appendChunk(impl_POA_GDA_Parameter * servant,
				GDA_Parameter_VarBinString * data,
				CORBA_Environment * ev);

static void impl_GDA_Command__destroy(impl_POA_GDA_Command * servant,
				      CORBA_Environment * ev);
static CORBA_long
 impl_GDA_Command__get_cmdTimeout(impl_POA_GDA_Command * servant,
				  CORBA_Environment * ev);
static void
 impl_GDA_Command__set_cmdTimeout(impl_POA_GDA_Command * servant,
				  CORBA_long value,
				  CORBA_Environment * ev);

static CORBA_boolean
 impl_GDA_Command__get_prepared(impl_POA_GDA_Command * servant,
				CORBA_Environment * ev);

static CORBA_long
 impl_GDA_Command__get_state(impl_POA_GDA_Command * servant,
			     CORBA_Environment * ev);
static void
 impl_GDA_Command__set_state(impl_POA_GDA_Command * servant,
			     CORBA_long value,
			     CORBA_Environment * ev);

static CORBA_char *
 impl_GDA_Command__get_text(impl_POA_GDA_Command * servant,
			    CORBA_Environment * ev);
static void
 impl_GDA_Command__set_text(impl_POA_GDA_Command * servant,
			    CORBA_char * value,
			    CORBA_Environment * ev);

static CORBA_unsigned_long
 impl_GDA_Command__get_type(impl_POA_GDA_Command * servant,
			    CORBA_Environment * ev);
static void
 impl_GDA_Command__set_type(impl_POA_GDA_Command * servant,
			    CORBA_unsigned_long value,
			    CORBA_Environment * ev);

static GDA_Recordset
 impl_GDA_Command_open(impl_POA_GDA_Command * servant,
		       GDA_CmdParameterSeq * param,
		       GDA_CursorType ct,
		       GDA_LockType lt,
		       CORBA_unsigned_long * affected,
		       CORBA_Environment * ev);

static void impl_GDA_Connection__destroy(impl_POA_GDA_Connection * servant,
					 CORBA_Environment * ev);

static CORBA_long
 impl_GDA_Connection__get_flags(impl_POA_GDA_Connection * servant,
				CORBA_Environment * ev);
static void
 impl_GDA_Connection__set_flags(impl_POA_GDA_Connection * servant,
				CORBA_long value,
				CORBA_Environment * ev);

static CORBA_long
 impl_GDA_Connection__get_cmdTimeout(impl_POA_GDA_Connection * servant,
				     CORBA_Environment * ev);
static void
 impl_GDA_Connection__set_cmdTimeout(impl_POA_GDA_Connection * servant,
				     CORBA_long value,
				     CORBA_Environment * ev);

static CORBA_long
 impl_GDA_Connection__get_connectTimeout(impl_POA_GDA_Connection * servant,
					 CORBA_Environment * ev);
static void
 impl_GDA_Connection__set_connectTimeout(impl_POA_GDA_Connection * servant,
					 CORBA_long value,
					 CORBA_Environment * ev);

static GDA_CursorLocation
 impl_GDA_Connection__get_cursor(impl_POA_GDA_Connection * servant,
				 CORBA_Environment * ev);
static void
 impl_GDA_Connection__set_cursor(impl_POA_GDA_Connection * servant,
				 GDA_CursorLocation value,
				 CORBA_Environment * ev);

static CORBA_char *
 impl_GDA_Connection__get_version(impl_POA_GDA_Connection * servant,
				  CORBA_Environment * ev);

static GDA_ErrorSeq *
 impl_GDA_Connection__get_errors(impl_POA_GDA_Connection * servant,
				 CORBA_Environment * ev);

static CORBA_long
 impl_GDA_Connection_beginTransaction(impl_POA_GDA_Connection * servant,
				      CORBA_Environment * ev);

static CORBA_long
 impl_GDA_Connection_commitTransaction(impl_POA_GDA_Connection * servant,
				       CORBA_Environment * ev);

static CORBA_long
 impl_GDA_Connection_rollbackTransaction(impl_POA_GDA_Connection * servant,
					 CORBA_Environment * ev);

static CORBA_long
 impl_GDA_Connection_close(impl_POA_GDA_Connection * servant,
			   CORBA_Environment * ev);

static CORBA_long
 impl_GDA_Connection_open(impl_POA_GDA_Connection * servant,
			  CORBA_char * dsn,
			  CORBA_char * user,
			  CORBA_char * passwd,
			  CORBA_Environment * ev);

static GDA_Recordset
 impl_GDA_Connection_openSchema(impl_POA_GDA_Connection * servant,
				GDA_Connection_QType t,
				GDA_Connection_ConstraintSeq * constraints,
				CORBA_Environment * ev);

static GDA_Command
 impl_GDA_Connection_createCommand(impl_POA_GDA_Connection * servant,
				   CORBA_Environment * ev);

static GDA_Recordset
 impl_GDA_Connection_createRecordset(impl_POA_GDA_Connection * servant,
				     CORBA_Environment * ev);

static GDA_Connection_DSNlist *
 impl_GDA_Connection_listSources(impl_POA_GDA_Connection * servant,
				 CORBA_Environment * ev);

static CORBA_long
 impl_GDA_Connection_startLogging(impl_POA_GDA_Connection * servant,
				  CORBA_char * filename,
				  CORBA_Environment * ev);

static CORBA_long
 impl_GDA_Connection_stopLogging(impl_POA_GDA_Connection * servant,
				 CORBA_Environment * ev);

static CORBA_char *
 impl_GDA_Connection_createTable(impl_POA_GDA_Connection * servant,
				 CORBA_char * name,
				 GDA_RowAttributes * columns,
				 CORBA_Environment * ev);

static CORBA_boolean
 impl_GDA_Connection_supports (impl_POA_GDA_Connection *servant,
                               GDA_Connection_Feature feature,
                               CORBA_Environment *ev);

static void impl_GDA_Recordset__destroy(impl_POA_GDA_Recordset * servant,
					CORBA_Environment * ev);

static CORBA_long
 impl_GDA_Recordset__get_currentBookmark(impl_POA_GDA_Recordset * servant,
					 CORBA_Environment * ev);
static void
 impl_GDA_Recordset__set_currentBookmark(impl_POA_GDA_Recordset * servant,
					 CORBA_long value,
					 CORBA_Environment * ev);

static CORBA_long
 impl_GDA_Recordset__get_cachesize(impl_POA_GDA_Recordset * servant,
				   CORBA_Environment * ev);
static void
 impl_GDA_Recordset__set_cachesize(impl_POA_GDA_Recordset * servant,
				   CORBA_long value,
				   CORBA_Environment * ev);

static GDA_CursorType
 impl_GDA_Recordset__get_currentCursorType(impl_POA_GDA_Recordset * servant,
					   CORBA_Environment * ev);
static void
 impl_GDA_Recordset__set_currentCursorType(impl_POA_GDA_Recordset * servant,
					   GDA_CursorType value,
					   CORBA_Environment * ev);

static GDA_LockType
 impl_GDA_Recordset__get_lockingMode(impl_POA_GDA_Recordset * servant,
				     CORBA_Environment * ev);
static void
 impl_GDA_Recordset__set_lockingMode(impl_POA_GDA_Recordset * servant,
				     GDA_LockType value,
				     CORBA_Environment * ev);

static CORBA_long
 impl_GDA_Recordset__get_maxrecords(impl_POA_GDA_Recordset * servant,
				    CORBA_Environment * ev);
static void
 impl_GDA_Recordset__set_maxrecords(impl_POA_GDA_Recordset * servant,
				    CORBA_long value,
				    CORBA_Environment * ev);

static CORBA_long
 impl_GDA_Recordset__get_pagecount(impl_POA_GDA_Recordset * servant,
				   CORBA_Environment * ev);

static CORBA_long
 impl_GDA_Recordset__get_pagesize(impl_POA_GDA_Recordset * servant,
				  CORBA_Environment * ev);
static void
 impl_GDA_Recordset__set_pagesize(impl_POA_GDA_Recordset * servant,
				  CORBA_long value,
				  CORBA_Environment * ev);

static CORBA_long
 impl_GDA_Recordset__get_recCount(impl_POA_GDA_Recordset * servant,
				  CORBA_Environment * ev);

static CORBA_char *
 impl_GDA_Recordset__get_source(impl_POA_GDA_Recordset * servant,
				CORBA_Environment * ev);

static CORBA_long
 impl_GDA_Recordset__get_status(impl_POA_GDA_Recordset * servant,
				CORBA_Environment * ev);

static CORBA_long
 impl_GDA_Recordset_cancelBatch(impl_POA_GDA_Recordset * servant,
				CORBA_Environment * ev);

static CORBA_long
 impl_GDA_Recordset_cancelUpdate(impl_POA_GDA_Recordset * servant,
				 CORBA_Environment * ev);

static CORBA_long
 impl_GDA_Recordset_close(impl_POA_GDA_Recordset * servant,
			  CORBA_Environment * ev);

static CORBA_long
 impl_GDA_Recordset_deleteCurrent(impl_POA_GDA_Recordset * servant,
				  CORBA_Environment * ev);

static CORBA_long
 impl_GDA_Recordset_move(impl_POA_GDA_Recordset * servant,
			 CORBA_long count,
			 CORBA_long bookmark,
			 CORBA_Environment * ev);

static CORBA_long
 impl_GDA_Recordset_moveFirst(impl_POA_GDA_Recordset * servant,
			      CORBA_Environment * ev);

static CORBA_long
 impl_GDA_Recordset_moveLast(impl_POA_GDA_Recordset * servant,
			     CORBA_Environment * ev);

static CORBA_long
 impl_GDA_Recordset_reQuery(impl_POA_GDA_Recordset * servant,
			    CORBA_Environment * ev);

static CORBA_long
 impl_GDA_Recordset_reSync(impl_POA_GDA_Recordset * servant,
			   CORBA_Environment * ev);

static CORBA_boolean
 impl_GDA_Recordset_supports(impl_POA_GDA_Recordset * servant,
			     GDA_Option what,
			     CORBA_Environment * ev);

static CORBA_long
 impl_GDA_Recordset_update(impl_POA_GDA_Recordset * servant,
			   CORBA_Environment * ev);

static CORBA_long
 impl_GDA_Recordset_updateBatch(impl_POA_GDA_Recordset * servant,
				CORBA_Environment * ev);

static GDA_Recordset_Chunk *
 impl_GDA_Recordset_fetch(impl_POA_GDA_Recordset * servant,
			  CORBA_long count,
			  CORBA_Environment * ev);

static GDA_RowAttributes *
 impl_GDA_Recordset_describe(impl_POA_GDA_Recordset * servant,
			     CORBA_Environment * ev);

static void impl_GDA_ConnectionFactory__destroy(impl_POA_GDA_ConnectionFactory * servant,
						CORBA_Environment * ev);
static CORBA_Object
 impl_GDA_ConnectionFactory_create_connection(impl_POA_GDA_ConnectionFactory * servant,
					      CORBA_char * goad_id,
					      CORBA_Environment * ev);

static CORBA_boolean
 impl_GDA_ConnectionFactory_supports(impl_POA_GDA_ConnectionFactory * servant,
				     CORBA_char * obj_goad_id,
				     CORBA_Environment * ev);
static CORBA_Object
 impl_GDA_ConnectionFactory_create_object(impl_POA_GDA_ConnectionFactory * servant,
					  CORBA_char * goad_id,
					  GNOME_stringlist * params,
					  CORBA_Environment * ev);

/*** epv structures ***/

static PortableServer_ServantBase__epv impl_GNOME_GenericFactory_base_epv =
{
   NULL,			/* _private data */
   (gpointer) & impl_GNOME_GenericFactory__destroy,	/* finalize routine */
   NULL,			/* default_POA routine */
};
static POA_GNOME_GenericFactory__epv impl_GNOME_GenericFactory_epv =
{
   NULL,			/* _private */

   (gpointer) & impl_GNOME_GenericFactory_supports,

   (gpointer) & impl_GNOME_GenericFactory_create_object,

};

static PortableServer_ServantBase__epv impl_GDA_Fieldx_base_epv =
{
   NULL,			/* _private data */
   (gpointer) & impl_GDA_Fieldx__destroy,	/* finalize routine */
   NULL,			/* default_POA routine */
};
static POA_GDA_Fieldx__epv impl_GDA_Fieldx_epv =
{
   NULL,			/* _private */
   (gpointer) & impl_GDA_Fieldx_appendChunk,

   (gpointer) & impl_GDA_Fieldx_getChunk,

};

static PortableServer_ServantBase__epv impl_GDA_Parameter_base_epv =
{
   NULL,			/* _private data */
   (gpointer) & impl_GDA_Parameter__destroy,	/* finalize routine */
   NULL,			/* default_POA routine */
};
static POA_GDA_Parameter__epv impl_GDA_Parameter_epv =
{
   NULL,			/* _private */

   (gpointer) & impl_GDA_Parameter_appendChunk,

};

static PortableServer_ServantBase__epv impl_GDA_Command_base_epv =
{
   NULL,			/* _private data */
   (gpointer) & impl_GDA_Command__destroy,	/* finalize routine */
   NULL,			/* default_POA routine */
};
static POA_GDA_Command__epv impl_GDA_Command_epv =
{
   NULL,			/* _private */
   (gpointer) & impl_GDA_Command__get_cmdTimeout,
   (gpointer) & impl_GDA_Command__set_cmdTimeout,

   (gpointer) & impl_GDA_Command__get_prepared,

   (gpointer) & impl_GDA_Command__get_state,
   (gpointer) & impl_GDA_Command__set_state,

   (gpointer) & impl_GDA_Command__get_text,
   (gpointer) & impl_GDA_Command__set_text,

   (gpointer) & impl_GDA_Command__get_type,
   (gpointer) & impl_GDA_Command__set_type,

   (gpointer) & impl_GDA_Command_open,

};
static PortableServer_ServantBase__epv impl_GDA_Connection_base_epv =
{
   NULL,			/* _private data */
   (gpointer) & impl_GDA_Connection__destroy,	/* finalize routine */
   NULL,			/* default_POA routine */
};
static POA_GDA_Connection__epv impl_GDA_Connection_epv =
{
   NULL,			/* _private */

   (gpointer) & impl_GDA_Connection__get_flags,
   (gpointer) & impl_GDA_Connection__set_flags,

   (gpointer) & impl_GDA_Connection__get_cmdTimeout,
   (gpointer) & impl_GDA_Connection__set_cmdTimeout,

   (gpointer) & impl_GDA_Connection__get_connectTimeout,
   (gpointer) & impl_GDA_Connection__set_connectTimeout,

   (gpointer) & impl_GDA_Connection__get_cursor,
   (gpointer) & impl_GDA_Connection__set_cursor,

   (gpointer) & impl_GDA_Connection__get_version,

   (gpointer) & impl_GDA_Connection__get_errors,

   (gpointer) & impl_GDA_Connection_beginTransaction,

   (gpointer) & impl_GDA_Connection_commitTransaction,

   (gpointer) & impl_GDA_Connection_rollbackTransaction,

   (gpointer) & impl_GDA_Connection_close,

   (gpointer) & impl_GDA_Connection_open,

   (gpointer) & impl_GDA_Connection_openSchema,

   (gpointer) & impl_GDA_Connection_createCommand,

   (gpointer) & impl_GDA_Connection_createRecordset,

   (gpointer) & impl_GDA_Connection_listSources,

   (gpointer) & impl_GDA_Connection_startLogging,

   (gpointer) & impl_GDA_Connection_stopLogging,

   (gpointer) & impl_GDA_Connection_createTable,

   (gpointer) & impl_GDA_Connection_supports
};

static PortableServer_ServantBase__epv impl_GDA_Recordset_base_epv =
{
   NULL,			/* _private data */
   (gpointer) & impl_GDA_Recordset__destroy,	/* finalize routine */
   NULL,			/* default_POA routine */
};
static POA_GDA_Recordset__epv impl_GDA_Recordset_epv =
{
   NULL,			/* _private */

   (gpointer) & impl_GDA_Recordset__get_currentBookmark,
   (gpointer) & impl_GDA_Recordset__set_currentBookmark,

   (gpointer) & impl_GDA_Recordset__get_cachesize,
   (gpointer) & impl_GDA_Recordset__set_cachesize,

   (gpointer) & impl_GDA_Recordset__get_currentCursorType,
   (gpointer) & impl_GDA_Recordset__set_currentCursorType,

   (gpointer) & impl_GDA_Recordset__get_lockingMode,
   (gpointer) & impl_GDA_Recordset__set_lockingMode,

   (gpointer) & impl_GDA_Recordset__get_maxrecords,
   (gpointer) & impl_GDA_Recordset__set_maxrecords,

   (gpointer) & impl_GDA_Recordset__get_pagecount,

   (gpointer) & impl_GDA_Recordset__get_pagesize,
   (gpointer) & impl_GDA_Recordset__set_pagesize,

   (gpointer) & impl_GDA_Recordset__get_recCount,

   (gpointer) & impl_GDA_Recordset__get_source,

   (gpointer) & impl_GDA_Recordset__get_status,

   (gpointer) & impl_GDA_Recordset_cancelBatch,

   (gpointer) & impl_GDA_Recordset_cancelUpdate,

   (gpointer) & impl_GDA_Recordset_close,

   (gpointer) & impl_GDA_Recordset_deleteCurrent,

   (gpointer) & impl_GDA_Recordset_move,

   (gpointer) & impl_GDA_Recordset_moveFirst,

   (gpointer) & impl_GDA_Recordset_moveLast,

   (gpointer) & impl_GDA_Recordset_reQuery,

   (gpointer) & impl_GDA_Recordset_reSync,

   (gpointer) & impl_GDA_Recordset_supports,

   (gpointer) & impl_GDA_Recordset_update,

   (gpointer) & impl_GDA_Recordset_updateBatch,

   (gpointer) & impl_GDA_Recordset_fetch,

   (gpointer) & impl_GDA_Recordset_describe,

};
static PortableServer_ServantBase__epv impl_GDA_ConnectionFactory_base_epv =
{
   NULL,			/* _private data */
   (gpointer) & impl_GDA_ConnectionFactory__destroy,	/* finalize routine */
   NULL,			/* default_POA routine */
};
static POA_GDA_ConnectionFactory__epv impl_GDA_ConnectionFactory_epv =
{
   NULL,			/* _private */
   (gpointer) & impl_GDA_ConnectionFactory_create_connection,

};
static POA_GNOME_GenericFactory__epv impl_GDA_ConnectionFactory_GNOME_GenericFactory_epv =
{
   NULL,			/* _private */
   (gpointer) & impl_GDA_ConnectionFactory_supports,
   (gpointer) & impl_GDA_ConnectionFactory_create_object,
};

/*** vepv structures ***/

static POA_GNOME_GenericFactory__vepv impl_GNOME_GenericFactory_vepv =
{
   &impl_GNOME_GenericFactory_base_epv,
   &impl_GNOME_GenericFactory_epv,
};

static POA_GDA_Fieldx__vepv impl_GDA_Fieldx_vepv =
{
   &impl_GDA_Fieldx_base_epv,
   &impl_GDA_Fieldx_epv,
};

static POA_GDA_Parameter__vepv impl_GDA_Parameter_vepv =
{
   &impl_GDA_Parameter_base_epv,
   &impl_GDA_Parameter_epv,
};

static POA_GDA_Command__vepv impl_GDA_Command_vepv =
{
   &impl_GDA_Command_base_epv,
   &impl_GDA_Command_epv,
};
static POA_GDA_Connection__vepv impl_GDA_Connection_vepv =
{
   &impl_GDA_Connection_base_epv,
   &impl_GDA_Connection_epv,
};

static POA_GDA_Recordset__vepv impl_GDA_Recordset_vepv =
{
   &impl_GDA_Recordset_base_epv,
   &impl_GDA_Recordset_epv,
};
static POA_GDA_ConnectionFactory__vepv impl_GDA_ConnectionFactory_vepv =
{
   &impl_GDA_ConnectionFactory_base_epv,
   &impl_GDA_ConnectionFactory_GNOME_GenericFactory_epv,
   &impl_GDA_ConnectionFactory_epv,
};

static GDA_Error*
make_errorbuffer(Gda_ODBC_Connection* cnc)
{
  gint          idx;
  GList*        ptr;
  GDA_Error*    rc;

  rc  = CORBA_sequence_GDA_Error_allocbuf(g_list_length(cnc->errors));
  idx = 0;
  ptr = cnc->errors;
  
  while(ptr)
    {
      Gda_ODBC_Error* e = ptr->data;
      rc[idx].description = CORBA_string_dup(e->description);
      rc[idx].number = e->number;
      rc[idx].source = CORBA_string_dup(e->source);
#if 0
      rc->_buffer[idx].helpfile = CORBA_string_dup(e->helpfile);
      rc->_buffer[idx].helpctxt = CORBA_string_dup(e->helpctxt);
#endif
      rc[idx].sqlstate = CORBA_string_dup(e->sqlstate);
      rc[idx].nativeMsg   = CORBA_string_dup(e->native);
      gda_odbc_error_free(e);
      ptr = g_list_next(ptr);
      idx++;
    }
  g_list_free(cnc->errors);
  cnc->errors = 0;
  return rc;
}      

static int
Exception( CORBA_Environment* ev )
{
  switch( ev->_major )
    {
    case CORBA_SYSTEM_EXCEPTION:
      g_warning("CORBA system exception %s.", CORBA_exception_id(ev));
      return -1;
    case CORBA_USER_EXCEPTION:
      g_warning("CORBA user exception: %s.\n", CORBA_exception_id( ev ) );
      return -1;
    default:
      break;
    }
  return 0;
}


/*** Stub implementations ***/

static GDA_Recordset impl_GDA_Recordset__create(PortableServer_POA poa, Gda_ODBC_Recordset* rs, CORBA_Environment * ev);


static GNOME_GenericFactory 
impl_GNOME_GenericFactory__create(PortableServer_POA poa, CORBA_Environment * ev)
{
   GNOME_GenericFactory retval;
   impl_POA_GNOME_GenericFactory *newservant;
   PortableServer_ObjectId *objid;

   newservant = g_new0(impl_POA_GNOME_GenericFactory, 1);
   newservant->servant.vepv = &impl_GNOME_GenericFactory_vepv;
   newservant->poa = poa;
   POA_GNOME_GenericFactory__init((PortableServer_Servant) newservant, ev);
   objid = PortableServer_POA_activate_object(poa, newservant, ev);
   CORBA_free(objid);
   retval = PortableServer_POA_servant_to_reference(poa, newservant, ev);

   return retval;
}

/* You shouldn't call this routine directly without first deactivating the servant... */
static void
impl_GNOME_GenericFactory__destroy(impl_POA_GNOME_GenericFactory * servant, CORBA_Environment * ev)
{

   POA_GNOME_GenericFactory__fini((PortableServer_Servant) servant, ev);
   g_free(servant);
}

CORBA_boolean
impl_GNOME_GenericFactory_supports(impl_POA_GNOME_GenericFactory * servant,
				   CORBA_char * obj_goad_id,
				   CORBA_Environment * ev)
{
   fprintf(stderr,"impl_GNOME_GenericFactory_supports: called with '%s' as obj_goad_id\n", obj_goad_id);
   return !strcmp(obj_goad_id, "gda-odbc");
}

CORBA_Object
impl_GNOME_GenericFactory_create_object(impl_POA_GNOME_GenericFactory * servant,
					CORBA_char * goad_id,
					GNOME_stringlist * params,
					CORBA_Environment * ev)
{
   CORBA_Object retval = CORBA_OBJECT_NIL;
   g_error("%s not implemented", __PRETTY_FUNCTION__);
   return retval;
}

static GDA_Fieldx 
impl_GDA_Fieldx__create(PortableServer_POA poa, CORBA_Environment * ev)
{
   GDA_Fieldx retval;
   impl_POA_GDA_Fieldx *newservant;
   PortableServer_ObjectId *objid;

   g_error("%s not implemented", __PRETTY_FUNCTION__);
   newservant = g_new0(impl_POA_GDA_Fieldx, 1);
   newservant->servant.vepv = &impl_GDA_Fieldx_vepv;
   newservant->poa = poa;
   POA_GDA_Fieldx__init((PortableServer_Servant) newservant, ev);
   objid = PortableServer_POA_activate_object(poa, newservant, ev);
   CORBA_free(objid);
   retval = PortableServer_POA_servant_to_reference(poa, newservant, ev);

   return retval;
}

/* You shouldn't call this routine directly without first deactivating the servant... */
static void
impl_GDA_Fieldx__destroy(impl_POA_GDA_Fieldx * servant, CORBA_Environment * ev)
{

   POA_GDA_Fieldx__fini((PortableServer_Servant) servant, ev);
   g_free(servant);
}

CORBA_long
impl_GDA_Fieldx_appendChunk(impl_POA_GDA_Fieldx * servant,
			    GDA_VarBinString * data,
			    CORBA_Environment * ev)
{
   CORBA_long retval = -1;
   g_error("%s not implemented", __PRETTY_FUNCTION__);

   return retval;
}

GDA_VarBinString *
impl_GDA_Fieldx_getChunk(impl_POA_GDA_Fieldx * servant,
			 CORBA_long amount,
			 CORBA_Environment * ev)
{
   GDA_VarBinString *retval = 0;
   g_error("%s not implemented", __PRETTY_FUNCTION__);

   return retval;
}

static GDA_Parameter 
impl_GDA_Parameter__create(PortableServer_POA poa, CORBA_Environment * ev)
{
   GDA_Parameter retval;
   impl_POA_GDA_Parameter *newservant;
   PortableServer_ObjectId *objid;

   newservant = g_new0(impl_POA_GDA_Parameter, 1);
   newservant->servant.vepv = &impl_GDA_Parameter_vepv;
   newservant->poa = poa;
   POA_GDA_Parameter__init((PortableServer_Servant) newservant, ev);
   objid = PortableServer_POA_activate_object(poa, newservant, ev);
   CORBA_free(objid);
   retval = PortableServer_POA_servant_to_reference(poa, newservant, ev);

   return retval;
}

/* You shouldn't call this routine directly without first deactivating the servant... */
static void
impl_GDA_Parameter__destroy(impl_POA_GDA_Parameter * servant, CORBA_Environment * ev)
{

   POA_GDA_Parameter__fini((PortableServer_Servant) servant, ev);
   g_free(servant);
}

CORBA_long
impl_GDA_Parameter_appendChunk(impl_POA_GDA_Parameter * servant,
			       GDA_Parameter_VarBinString * data,
			       CORBA_Environment * ev)
{
   CORBA_long retval = -1;
   g_error("%s not implemented", __PRETTY_FUNCTION__);

   return retval;
}

static GDA_Command 
impl_GDA_Command__create(PortableServer_POA poa, Gda_ODBC_Command* cmd, CORBA_Environment * ev)
{
   GDA_Command retval;
   impl_POA_GDA_Command *newservant;
   PortableServer_ObjectId *objid;

   newservant = g_new0(impl_POA_GDA_Command, 1);
   newservant->servant.vepv = &impl_GDA_Command_vepv;
   newservant->poa = poa;
   newservant->cmd = cmd;
   POA_GDA_Command__init((PortableServer_Servant) newservant, ev);
   objid = PortableServer_POA_activate_object(poa, newservant, ev);
   CORBA_free(objid);
   retval = PortableServer_POA_servant_to_reference(poa, newservant, ev);
   g_print("%s: New reference at 0x%p\n", __PRETTY_FUNCTION__, retval);
   g_print("    stringifyed: '%s'\n", CORBA_ORB_object_to_string(poa->orb, retval, ev));
   return retval;
}

/* You shouldn't call this routine directly without first deactivating the servant... */
static void
impl_GDA_Command__destroy(impl_POA_GDA_Command * servant, CORBA_Environment * ev)
{

   POA_GDA_Command__fini((PortableServer_Servant) servant, ev);
   g_free(servant);
}

CORBA_long
impl_GDA_Command__get_cmdTimeout(impl_POA_GDA_Command * servant,
				 CORBA_Environment * ev)
{
   CORBA_long retval = -1;
   g_error("%s not implemented", __PRETTY_FUNCTION__);

   return retval;
}

void
impl_GDA_Command__set_cmdTimeout(impl_POA_GDA_Command * servant,
				 CORBA_long value,
				 CORBA_Environment * ev)
{
   g_error("%s not implemented", __PRETTY_FUNCTION__);
}

CORBA_boolean
impl_GDA_Command__get_prepared(impl_POA_GDA_Command * servant,
			       CORBA_Environment * ev)
{
   CORBA_boolean retval = -1;

   g_error("%s not implemented", __PRETTY_FUNCTION__);
   return retval;
}

CORBA_long
impl_GDA_Command__get_state(impl_POA_GDA_Command * servant,
			    CORBA_Environment * ev)
{
   CORBA_long retval = -1;

   g_error("%s not implemented", __PRETTY_FUNCTION__);
   return retval;
}

void
impl_GDA_Command__set_state(impl_POA_GDA_Command * servant,
			    CORBA_long value,
			    CORBA_Environment * ev)
{
   g_error("%s not implemented", __PRETTY_FUNCTION__);
}

static CORBA_char *
impl_GDA_Command__get_text(impl_POA_GDA_Command * servant,
			   CORBA_Environment * ev)
{
   CORBA_char *retval;
   if (!servant->cmd->cmd)
     retval = 0;
   else
     retval = CORBA_string_dup(servant->cmd->cmd);
   return retval;
}

static void
impl_GDA_Command__set_text(impl_POA_GDA_Command * servant,
			   CORBA_char * value,
			   CORBA_Environment * ev)
{
  g_print("%s called, value = '%s'\n", __PRETTY_FUNCTION__, value);
  if (servant->cmd->cmd)
    g_free(servant->cmd->cmd);
  servant->cmd->cmd = g_strdup(value);
}

static CORBA_unsigned_long
impl_GDA_Command__get_type(impl_POA_GDA_Command * servant,
			   CORBA_Environment * ev)
{
  CORBA_unsigned_long retval;
  retval = servant->cmd->type;
  return retval;
}

static void
impl_GDA_Command__set_type(impl_POA_GDA_Command * servant,
			   CORBA_unsigned_long value,
			   CORBA_Environment * ev)
{
  servant->cmd->type = value;
}
static GDA_Recordset
impl_GDA_Command_open(impl_POA_GDA_Command * servant,
		      GDA_CmdParameterSeq * params,
		      GDA_CursorType ct,
		      GDA_LockType lt,
		      CORBA_unsigned_long * affected,
		      CORBA_Environment * ev)
{
  
  Gda_ODBC_Command*        gda_cmd;
  Gda_ODBC_Connection*     gda_connection;
  Gda_ODBC_Recordset*      recset;
  GDA_Recordset            new_recset;
  
  g_print("%s called\n", __PRETTY_FUNCTION__);
  gda_cmd = servant->cmd;
  *affected = 0;
  CORBA_exception_init(ev);
  gda_connection = servant->cmd->cnc;
  recset  = gda_odbc_cmd_execute(gda_cmd, params, (gulong*)affected, 0);
  if (!recset && gda_connection->errors)
    {
      GDA_DriverError*     exception = GDA_DriverError__alloc();
      
      exception->errors._length = g_list_length(gda_connection->errors);
      exception->errors._buffer = make_errorbuffer(gda_connection);
      exception->realcommand = CORBA_string_dup(gda_cmd->cmd);
      CORBA_exception_set(ev, CORBA_USER_EXCEPTION, ex_GDA_DriverError, exception);
    }
  if (!recset)
    return CORBA_OBJECT_NIL;
  new_recset = impl_GDA_Recordset__create(servant->poa, recset, ev);
  return new_recset;
}



static GDA_Connection 
impl_GDA_Connection__create(PortableServer_POA poa, CORBA_Environment * ev)
{
   GDA_Connection retval;
   impl_POA_GDA_Connection *newservant;
   PortableServer_ObjectId *objid;

   newservant = g_new0(impl_POA_GDA_Connection, 1);
   newservant->servant.vepv = &impl_GDA_Connection_vepv;
   newservant->poa = poa;
   newservant->cnc = gda_odbc_connection_new();
   
   POA_GDA_Connection__init((PortableServer_Servant) newservant, ev);
   objid = PortableServer_POA_activate_object(poa, newservant, ev);
   CORBA_free(objid);
   retval = PortableServer_POA_servant_to_reference(poa, newservant, ev);

   return retval;
}

/* You shouldn't call this routine directly without first deactivating the servant... */
static void
impl_GDA_Connection__destroy(impl_POA_GDA_Connection * servant, CORBA_Environment * ev)
{

   POA_GDA_Connection__fini((PortableServer_Servant) servant, ev);
   g_free(servant);
}

CORBA_long
impl_GDA_Connection__get_flags(impl_POA_GDA_Connection * servant,
			       CORBA_Environment * ev)
{
   CORBA_long retval = -1;
   g_error("%s not implemented", __PRETTY_FUNCTION__);

   return retval;
}

void
impl_GDA_Connection__set_flags(impl_POA_GDA_Connection * servant,
			       CORBA_long value,
			       CORBA_Environment * ev)
{
   g_error("%s not implemented", __PRETTY_FUNCTION__);
}

CORBA_long
impl_GDA_Connection__get_cmdTimeout(impl_POA_GDA_Connection * servant,
				    CORBA_Environment * ev)
{
   CORBA_long retval = -1;
   g_error("%s not implemented", __PRETTY_FUNCTION__);

   return retval;
}

void
impl_GDA_Connection__set_cmdTimeout(impl_POA_GDA_Connection * servant,
				    CORBA_long value,
				    CORBA_Environment * ev)
{
   g_error("%s not implemented", __PRETTY_FUNCTION__);
}

CORBA_long
impl_GDA_Connection__get_connectTimeout(impl_POA_GDA_Connection * servant,
					CORBA_Environment * ev)
{
   CORBA_long retval = -1;

   g_error("%s not implemented", __PRETTY_FUNCTION__);
   return retval;
}

void
impl_GDA_Connection__set_connectTimeout(impl_POA_GDA_Connection * servant,
					CORBA_long value,
					CORBA_Environment * ev)
{
   g_error("%s not implemented", __PRETTY_FUNCTION__);
}

CORBA_char *
impl_GDA_Connection__get_dsn(impl_POA_GDA_Connection * servant,
			     CORBA_Environment * ev)
{
   CORBA_char *retval = 0;

   g_error("%s not implemented", __PRETTY_FUNCTION__);
   return retval;
}

GDA_CursorLocation
impl_GDA_Connection__get_cursor(impl_POA_GDA_Connection * servant,
				CORBA_Environment * ev)
{
   GDA_CursorLocation retval = -1;

   g_error("%s not implemented", __PRETTY_FUNCTION__);
   return retval;
}

void
impl_GDA_Connection__set_cursor(impl_POA_GDA_Connection * servant,
				GDA_CursorLocation value,
				CORBA_Environment * ev)
{
   g_error("%s not implemented", __PRETTY_FUNCTION__);
}


CORBA_char *
impl_GDA_Connection__get_version(impl_POA_GDA_Connection * servant,
				 CORBA_Environment * ev)
{
   CORBA_char *retval = 0;

   g_error("%s not implemented", __PRETTY_FUNCTION__);
   return retval;
}

GDA_ErrorSeq *
impl_GDA_Connection__get_errors(impl_POA_GDA_Connection * servant,
				CORBA_Environment * ev)
{
  Gda_ODBC_Connection*   cnc = servant->cnc;
  GDA_ErrorSeq*          rc = GDA_ErrorSeq__alloc();

  rc->_length = g_list_length(cnc->errors);
  rc->_buffer = make_errorbuffer(cnc);
  return rc;
}

CORBA_long
impl_GDA_Connection_beginTransaction(impl_POA_GDA_Connection * servant,
				     CORBA_Environment * ev)
{
   CORBA_long retval = -1;

   g_error("%s not implemented", __PRETTY_FUNCTION__);
   return retval;
}

CORBA_long
impl_GDA_Connection_commitTransaction(impl_POA_GDA_Connection * servant,
				      CORBA_Environment * ev)
{
   CORBA_long retval = -1; 

   g_error("%s not implemented", __PRETTY_FUNCTION__); 
   return retval;
}

CORBA_long
impl_GDA_Connection_rollbackTransaction(impl_POA_GDA_Connection * servant,
					CORBA_Environment * ev)
{
   CORBA_long retval = -1;

   g_error("%s not implemented", __PRETTY_FUNCTION__);
   return retval;
}

CORBA_long
impl_GDA_Connection_close(impl_POA_GDA_Connection * servant,
			  CORBA_Environment * ev)
{
  if (gda_odbc_connection_close(servant->cnc) < 0)
    {
      fprintf(stderr," gda_odbc_connection_close returns an error\n");
      return -1;
    }
  PortableServer_POA_deactivate_object(servant->poa,
				       PortableServer_POA_servant_to_id(servant->poa,servant, ev),
				       ev);
  Exception(ev);
  impl_GDA_Connection__destroy(servant, ev);
  Exception(ev);
  return 0;
}

CORBA_long
impl_GDA_Connection_open(impl_POA_GDA_Connection * servant,
			 CORBA_char * dsn,
			 CORBA_char * user,
			 CORBA_char * passwd,
			 CORBA_Environment * ev)
{
  if (gda_odbc_connection_open(servant->cnc, dsn, user, passwd) < 0)
    {
      GDA_DriverError* exception = GDA_DriverError__alloc();
      exception->errors._length = g_list_length(servant->cnc->errors);
      exception->errors._buffer = make_errorbuffer(servant->cnc);
      exception->realcommand = CORBA_string_dup("Connection Open");
      CORBA_exception_set(ev, CORBA_USER_EXCEPTION, ex_GDA_DriverError, exception);
      return -1;
    }
  return 0;
}

GDA_Recordset
impl_GDA_Connection_openSchema(impl_POA_GDA_Connection * servant,
			       GDA_Connection_QType t,
			       GDA_Connection_ConstraintSeq * constraints,
			       CORBA_Environment * ev)
{
  GDA_Recordset            new_recset;
  Gda_ODBC_Recordset*      recset;
  
  if ((recset = gda_odbc_connection_open_schema(servant->cnc, t, constraints->_buffer, constraints->_length)) == 0)
    {
      gchar bfr[128];
      GDA_NotSupported* exception = GDA_NotSupported__alloc();
      g_snprintf(bfr, sizeof(bfr), "SCHEMA type %d not supported\n", t);
      exception->errormsg = CORBA_string_dup(bfr);
      CORBA_exception_set(ev, CORBA_USER_EXCEPTION, ex_GDA_NotSupported, exception);
      return CORBA_OBJECT_NIL;
    }
  new_recset = impl_GDA_Recordset__create(servant->poa, recset, ev);
  Exception(ev);

  return new_recset;
}

GDA_Command
impl_GDA_Connection_createCommand(impl_POA_GDA_Connection * servant,
				  CORBA_Environment * ev)
{
   GDA_Command retval;
   Gda_ODBC_Command* cmd = gda_odbc_cmd_new();

   retval = impl_GDA_Command__create(servant->poa, cmd, ev);
   if (Exception(ev))
     return CORBA_OBJECT_NIL;

   gda_odbc_cmd_set_connection(cmd, servant->cnc);
   return retval;
}

GDA_Recordset
impl_GDA_Connection_createRecordset(impl_POA_GDA_Connection * servant,
				    CORBA_Environment * ev)
{
   GDA_Recordset retval = 0;
   Gda_ODBC_Recordset* rs = gda_odbc_recset_new();

   g_print("GDA_Connection_createRecordset called\n");
   rs->cnc = servant->cnc;
   retval = impl_GDA_Recordset__create(servant->poa, rs, ev);
   if (Exception(ev))
     return CORBA_OBJECT_NIL;
   return retval;
}


GDA_Connection_DSNlist *
impl_GDA_Connection_listSources(impl_POA_GDA_Connection * servant,
				CORBA_Environment * ev)
{
   GDA_Connection_DSNlist *retval = 0;

   g_error("%s not implemented", __PRETTY_FUNCTION__);
   return retval;
}

CORBA_long
impl_GDA_Connection_startLogging(impl_POA_GDA_Connection * servant,
				 CORBA_char * filename,
				 CORBA_Environment * ev)
{
   CORBA_long retval = -1;

   g_error("%s not implemented", __PRETTY_FUNCTION__);
   return retval;
}

CORBA_long
impl_GDA_Connection_stopLogging(impl_POA_GDA_Connection * servant,
				CORBA_Environment * ev)
{
   CORBA_long retval = -1;

   g_error("%s not implemented", __PRETTY_FUNCTION__);
   return retval;
}

CORBA_char *
impl_GDA_Connection_createTable(impl_POA_GDA_Connection* servant,
				CORBA_char* name,
				GDA_RowAttributes * columns,
				CORBA_Environment * ev)
{
  CORBA_char* retval;

  retval = gda_odbc_connection_create_recset(servant->cnc, columns);
  return retval;
}

static CORBA_boolean
impl_GDA_Connection_supports (impl_POA_GDA_Connection* servant,
                              GDA_Connection_Feature feature,
                              CORBA_Environment *ev)
{
  return gda_odbc_connection_supports(servant->cnc, feature);
}

static GDA_Recordset 
impl_GDA_Recordset__create(PortableServer_POA poa, Gda_ODBC_Recordset* rs, CORBA_Environment * ev)
{
   GDA_Recordset retval;
   impl_POA_GDA_Recordset *newservant;
   PortableServer_ObjectId *objid;

   newservant = g_new0(impl_POA_GDA_Recordset, 1);
   newservant->servant.vepv = &impl_GDA_Recordset_vepv;
   newservant->poa = poa;
   newservant->rs = rs;
   POA_GDA_Recordset__init((PortableServer_Servant) newservant, ev);
   objid = PortableServer_POA_activate_object(poa, newservant, ev);
   CORBA_free(objid);
   retval = PortableServer_POA_servant_to_reference(poa, newservant, ev);

   return retval;
}

/* You shouldn't call this routine directly without first deactivating the servant... */
static void
impl_GDA_Recordset__destroy(impl_POA_GDA_Recordset * servant, CORBA_Environment * ev)
{

   POA_GDA_Recordset__fini((PortableServer_Servant) servant, ev);
   g_free(servant);
}


CORBA_long
impl_GDA_Recordset__get_currentBookmark(impl_POA_GDA_Recordset * servant,
					CORBA_Environment * ev)
{
   CORBA_long retval = 0;

   g_error("%s not implemented", __PRETTY_FUNCTION__);
   return retval;
}

void
impl_GDA_Recordset__set_currentBookmark(impl_POA_GDA_Recordset * servant,
					CORBA_long value,
					CORBA_Environment * ev)
{
   g_error("%s not implemented", __PRETTY_FUNCTION__);
}

CORBA_long
impl_GDA_Recordset__get_cachesize(impl_POA_GDA_Recordset * servant,
				  CORBA_Environment * ev)
{
   CORBA_long retval = -1;

   g_error("%s not implemented", __PRETTY_FUNCTION__);
   return retval;
}

void
impl_GDA_Recordset__set_cachesize(impl_POA_GDA_Recordset * servant,
				  CORBA_long value,
				  CORBA_Environment * ev)
{
   g_error("%s not implemented", __PRETTY_FUNCTION__);
}


GDA_CursorType
impl_GDA_Recordset__get_currentCursorType(impl_POA_GDA_Recordset * servant,
					  CORBA_Environment * ev)
{
   GDA_CursorType retval = -1;

   g_error("%s not implemented", __PRETTY_FUNCTION__);
   return retval;
}

void
impl_GDA_Recordset__set_currentCursorType(impl_POA_GDA_Recordset * servant,
					  GDA_CursorType value,
					  CORBA_Environment * ev)
{
   g_error("%s not implemented", __PRETTY_FUNCTION__);
}

GDA_LockType
impl_GDA_Recordset__get_lockingMode(impl_POA_GDA_Recordset * servant,
				    CORBA_Environment * ev)
{
   GDA_LockType retval = -1;

   g_error("%s not implemented", __PRETTY_FUNCTION__);
   return retval;
}

void
impl_GDA_Recordset__set_lockingMode(impl_POA_GDA_Recordset * servant,
				    GDA_LockType value,
				    CORBA_Environment * ev)
{
   g_error("%s not implemented", __PRETTY_FUNCTION__);
}


CORBA_long
impl_GDA_Recordset__get_maxrecords(impl_POA_GDA_Recordset * servant,
				   CORBA_Environment * ev)
{
   CORBA_long retval = -1;

   g_error("%s not implemented", __PRETTY_FUNCTION__);
   return retval;
}

void
impl_GDA_Recordset__set_maxrecords(impl_POA_GDA_Recordset * servant,
				   CORBA_long value,
				   CORBA_Environment * ev)
{
   g_error("%s not implemented", __PRETTY_FUNCTION__);
}

CORBA_long
impl_GDA_Recordset__get_pagecount(impl_POA_GDA_Recordset * servant,
				  CORBA_Environment * ev)
{
   CORBA_long retval = -1;

   g_error("%s not implemented", __PRETTY_FUNCTION__);
   return retval;
}

CORBA_long
impl_GDA_Recordset__get_pagesize(impl_POA_GDA_Recordset * servant,
				 CORBA_Environment * ev)
{
   CORBA_long retval = -1;

   g_error("%s not implemented", __PRETTY_FUNCTION__);
   return retval;
}

void
impl_GDA_Recordset__set_pagesize(impl_POA_GDA_Recordset * servant,
				 CORBA_long value,
				 CORBA_Environment * ev)
{
   g_error("%s not implemented", __PRETTY_FUNCTION__);
}

CORBA_long
impl_GDA_Recordset__get_recCount(impl_POA_GDA_Recordset * servant,
				 CORBA_Environment * ev)
{
   CORBA_long retval = -1;

   g_error("%s not implemented", __PRETTY_FUNCTION__);
   return retval;
}

CORBA_char *
impl_GDA_Recordset__get_source(impl_POA_GDA_Recordset * servant,
			       CORBA_Environment * ev)
{
   CORBA_char *retval = 0;

   g_error("%s not implemented", __PRETTY_FUNCTION__);
   return retval;
}


CORBA_long
impl_GDA_Recordset__get_status(impl_POA_GDA_Recordset * servant,
			       CORBA_Environment * ev)
{
   CORBA_long retval = -1;

   g_error("%s not implemented", __PRETTY_FUNCTION__);
   return retval;
}


CORBA_long
impl_GDA_Recordset_cancelBatch(impl_POA_GDA_Recordset * servant,
			       CORBA_Environment * ev)
{
   CORBA_long retval = -1;

   g_error("%s not implemented", __PRETTY_FUNCTION__);
   return retval;
}

CORBA_long
impl_GDA_Recordset_cancelUpdate(impl_POA_GDA_Recordset * servant,
				CORBA_Environment * ev)
{
   CORBA_long retval = -1;

   g_error("%s not implemented", __PRETTY_FUNCTION__);
   return retval;
}

CORBA_long
impl_GDA_Recordset_close(impl_POA_GDA_Recordset * servant,
			 CORBA_Environment * ev)
{
   
  if (gda_odbc_recset_close(servant->rs) < 0)
    {
      g_warning("GDA_odbc_recset_close: error during close\n");
      return -1;
    }
  PortableServer_POA_deactivate_object(servant->poa,
				       PortableServer_POA_servant_to_id(servant->poa,servant, ev),
				       ev);
  Exception(ev);
  impl_GDA_Recordset__destroy(servant, ev);
  Exception(ev);
  return 0;
}

CORBA_long
impl_GDA_Recordset_deleteCurrent(impl_POA_GDA_Recordset * servant,
				 CORBA_Environment * ev)
{
   CORBA_long retval = -1;

   g_error("%s not implemented", __PRETTY_FUNCTION__);
   return retval;
}

CORBA_long
impl_GDA_Recordset_move(impl_POA_GDA_Recordset * servant,
			CORBA_long count,
			CORBA_long bookmark,
			CORBA_Environment * ev)
{
   CORBA_long retval = -1;

   g_error("%s not implemented", __PRETTY_FUNCTION__);
   return retval;
}

CORBA_long
impl_GDA_Recordset_moveFirst(impl_POA_GDA_Recordset * servant,
			     CORBA_Environment * ev)
{
   CORBA_long retval = -1;

   g_error("%s not implemented", __PRETTY_FUNCTION__);
   return retval;
}

CORBA_long
impl_GDA_Recordset_moveLast(impl_POA_GDA_Recordset * servant,
			    CORBA_Environment * ev)
{
   CORBA_long retval = -1;

   g_error("%s not implemented", __PRETTY_FUNCTION__);
   return retval;
}



CORBA_long
impl_GDA_Recordset_reQuery(impl_POA_GDA_Recordset * servant,
			   CORBA_Environment * ev)
{
   CORBA_long retval = -1;

   g_error("%s not implemented", __PRETTY_FUNCTION__);
   return retval;
}

CORBA_long
impl_GDA_Recordset_reSync(impl_POA_GDA_Recordset * servant,
			  CORBA_Environment * ev)
{
   CORBA_long retval = -1;

   g_error("%s not implemented", __PRETTY_FUNCTION__);
   return retval;
}

CORBA_boolean
impl_GDA_Recordset_supports(impl_POA_GDA_Recordset * servant,
			    GDA_Option what,
			    CORBA_Environment * ev)
{
   CORBA_boolean retval = 0;

   g_error("%s not implemented", __PRETTY_FUNCTION__);
   return retval;
}

CORBA_long
impl_GDA_Recordset_update(impl_POA_GDA_Recordset * servant,
			  CORBA_Environment * ev)
{
   CORBA_long retval = -1;

   g_error("%s not implemented", __PRETTY_FUNCTION__);
   return retval;
}

CORBA_long
impl_GDA_Recordset_updateBatch(impl_POA_GDA_Recordset * servant,
			       CORBA_Environment * ev)
{
   CORBA_long retval = -1;

   g_error("%s not implemented", __PRETTY_FUNCTION__);
   return retval;
}


GDA_Recordset_Chunk *
impl_GDA_Recordset_fetch(impl_POA_GDA_Recordset * servant,
			 CORBA_long count,
			 CORBA_Environment * ev)
{
  Gda_ODBC_Recordset*    rs = servant->rs;
  GDA_Row*               row;
  GDA_Recordset_Chunk*   chunk;
  GDA_Field*             field;
  Gda_ODBC_Field*        server_field;
  GList*                 ptr;
  gint                   rowidx = 0;
  gint                   colidx;
  gint                   rc;
  GList*                 tmp_rows;
  gint                   rowlength;

  fprintf(stderr,"impl_GDA_Recordset_fetch: enter\n");
  if (!servant->rs)
    return CORBA_OBJECT_NIL;

  tmp_rows = 0;
  rowidx = 0;

  rowlength = g_list_length(rs->fields);
  do {
    
    row = g_new0(GDA_Row, 1);
    row->_buffer = CORBA_sequence_GDA_Field_allocbuf(rowlength);
    row->_length = rowlength;
    row->_maximum = rowlength;

    ptr = rs->fields;
    colidx = 0;

    while(ptr)
	{
	  server_field = ptr->data;
	  
	  server_field->value = &row->_buffer[colidx].realValue._u.v;
	  row->_buffer[colidx].realValue._d = 1;
	  row->_buffer[colidx].shadowValue._d = 1;
	  row->_buffer[colidx].originalValue._d = 1;
	  ptr = g_list_next(ptr);
	  colidx++;
	}

    rc = gda_odbc_recset_move_next(rs);
      
    if (rc !=  0)
      {
	fprintf(stderr,"CORBA_free row->buffer\n");
	CORBA_free(row->_buffer);
	fprintf(stderr,"g_free(row)\n");
	g_free(row);
	break;
      }
    tmp_rows = g_list_append(tmp_rows, row);
    
    ptr = rs->fields;
    field = &row->_buffer[0];
    colidx = 0;
    while(ptr)
	{
	  server_field = ptr->data;
	  field->actualSize   = server_field->actual_length;
	  field->realValue._d = server_field->actual_length == SQL_NULL_DATA;
	  field->shadowValue._d   = 1;
	  field->originalValue._d = 1;
	  fprintf(stderr,"field %d: gdatype = %d, GDA_TypeBinary = %d\n", colidx, field->realValue._u.v._d, GDA_TypeBinary);
	  fprintf(stderr,"field %d: field->actualSize = %d\n", colidx,  field->actualSize);
	  if (!field->realValue._d)
	    {
	      switch (field->realValue._u.v._d)
		{
		case GDA_TypeBinary:
		case GDA_TypeVarbin:
		case GDA_TypeVarwchar:
		case GDA_TypeLongvarwchar:
		case GDA_TypeLongvarbin:
		  fprintf(stderr,"field %d: setting field->realValue._u.v._u.lvb._length to %d\n", colidx, field->actualSize);
		  field->realValue._u.v._u.lvb._length = field->actualSize;
		  break;
		default:
		}
	    }
	  ptr = g_list_next(ptr);
	  field = &row->_buffer[++colidx];
	}
      rowidx++;
  }while (rowidx < count);
  fprintf(stderr,"After fetch loop\n");
  if (rc < 0)
    {
      GDA_DriverError*     exception = GDA_DriverError__alloc();
      Gda_ODBC_Connection* cnc = rs->cnc;
      
      fprintf(stderr,"Ooops an error ocurred while fetching data\n");
      exception->errors._length = g_list_length(cnc->errors);
      exception->errors._buffer = make_errorbuffer(cnc);
      exception->realcommand = CORBA_string_dup("Fetch");
      CORBA_exception_set(ev, CORBA_USER_EXCEPTION, ex_GDA_DriverError, exception);
      return CORBA_OBJECT_NIL;
    }
  chunk = GDA_Recordset_Chunk__alloc();
  if (rowidx)
    chunk->_buffer = CORBA_sequence_GDA_Row_allocbuf(rowidx);
  else
    chunk->_buffer = 0;
  chunk->_length = rowidx;
  for (ptr = tmp_rows, count = 0; count < rowidx; ptr = g_list_next(ptr), count++)
    {
      row = ptr->data;
      chunk->_buffer[count]._length = row->_length;
      chunk->_buffer[count]._buffer = row->_buffer;
      g_free(row);
    }
  g_list_free(tmp_rows);
  return chunk;
}

GDA_RowAttributes *
impl_GDA_Recordset_describe(impl_POA_GDA_Recordset * servant,
			    CORBA_Environment * ev)
{
  Gda_ODBC_Recordset*    rs = servant->rs;
  GDA_RowAttributes*     rc;
  GList*                 ptr;
  Gda_ODBC_Field*        server_field;
  GDA_FieldAttributes*   field;
  gint                   idx;

  rc = GDA_RowAttributes__alloc();
  if (!rs)
    {
      rc->_length = 0;
      rc->_buffer = 0;
      rc->_maximum = 0;
      g_error("This shouldn't happen");
      return rc;
    }
  rc->_length = g_list_length(rs->fields);
  fprintf(stderr,"gda_Recset_describe: length = %d\n", rc->_length);
  rc->_buffer = CORBA_sequence_GDA_FieldAttributes_allocbuf(rc->_length);
  rc->_maximum = 0;

  idx = 0;
  ptr = rs->fields;
  while (ptr)
    {
      field = &rc->_buffer[idx];
      server_field = ptr->data;
      
      field->name        = CORBA_string_dup(server_field->name);
      fprintf(stderr,"gda_Recset_describe: sending field description for '%s'\n", field->name);
      field->definedSize = server_field->defined_length;
      
      field->scale       = server_field->num_scale;
      field->gdaType     = gda_odbc_sql2gdatype(server_field->sql_type);
      field->nativeType  = server_field->sql_type;
      ptr = g_list_next(ptr);
      idx++;
    }
  return rc;
}




GDA_ConnectionFactory 
impl_GDA_ConnectionFactory__create(PortableServer_POA poa, CORBA_Environment * ev)
{
   GDA_ConnectionFactory retval;
   impl_POA_GDA_ConnectionFactory *newservant;
   PortableServer_ObjectId *objid;

   newservant = g_new0(impl_POA_GDA_ConnectionFactory, 1);
   newservant->servant.vepv = &impl_GDA_ConnectionFactory_vepv;
   newservant->poa = poa;
   POA_GDA_ConnectionFactory__init((PortableServer_Servant) newservant, ev);
   objid = PortableServer_POA_activate_object(poa, newservant, ev);
   CORBA_free(objid);
   retval = PortableServer_POA_servant_to_reference(poa, newservant, ev);

   return retval;
}

/* You shouldn't call this routine directly without first deactivating the servant... */
static void
impl_GDA_ConnectionFactory__destroy(impl_POA_GDA_ConnectionFactory * servant, CORBA_Environment * ev)
{

   POA_GDA_ConnectionFactory__fini((PortableServer_Servant) servant, ev);
   g_free(servant);
}

CORBA_Object
impl_GDA_ConnectionFactory_create_connection(impl_POA_GDA_ConnectionFactory * servant,
						 CORBA_char * goad_id,
						 CORBA_Environment * ev)
{
   CORBA_Object retval;
   
   retval = impl_GDA_Connection__create(servant->poa, ev);
   if (Exception(ev))
     {
       g_warning("%s cannot create connection object", __PRETTY_FUNCTION__);
       return CORBA_OBJECT_NIL;
     }
   return retval;
}

CORBA_boolean
impl_GDA_ConnectionFactory_supports(impl_POA_GDA_ConnectionFactory * servant,
					CORBA_char * obj_goad_id,
					CORBA_Environment * ev)
{
   CORBA_boolean retval = 0;

   g_error("%s not implemented", __PRETTY_FUNCTION__); 
   return retval;
}

CORBA_Object
impl_GDA_ConnectionFactory_create_object(impl_POA_GDA_ConnectionFactory * servant,
					     CORBA_char * goad_id,
					     GNOME_stringlist * params,
					     CORBA_Environment * ev)
{
   CORBA_Object retval = CORBA_OBJECT_NIL;
   
   g_error("%s not implemented", __PRETTY_FUNCTION__); 
   return retval;
}
