/* Rolodex
 * Copyright (C) 2000 Alvaro del Castillo
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "gda-rolodex.h"

void
rolodex_error_cb(Gda_Connection* cnc, gpointer data)
{
  static GtkWidget* error_dialog = 0;
  g_print("%s: %d: %s called\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
  if (!error_dialog)
    {
      error_dialog = gnome_db_errordlg_new(cnc, _("UI Test 3 Error"));
    }
  gnome_db_errordlg_show_errors(GNOME_DB_ERRORDLG(error_dialog));
}

void
rolodex_login_cb (Gda_Connection *cnc, gpointer data)
{
  g_return_if_fail(IS_GDA_CONNECTION(cnc));
  g_return_if_fail(GNOME_DB_IS_LOGINDLG(data));

  if (gda_connection_is_open(cnc))
    {
      gchar* str;
      GnomeDbLogin* login = GNOME_DB_LOGIN(GNOME_DB_LOGINDLG(data)->login);

      if (login)
        str = gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(login->gda_dbname)->entry));
      else str = NULL;

      gnome_db_container_set_status(GNOME_DB_CONTAINER(glb_container),
                                    _("Connected to '%s'"), str);
      gnome_dialog_close(GNOME_DIALOG(data));
      data = NULL;
      show_tables(cnc);
    }
}

gint 
rolodex_change_record_cb   (gpointer data) {
  GtkAdjustment* adj = GTK_ADJUSTMENT(data);
  float    value;

  value = adj->value;
  value--;
  gtk_adjustment_set_value(adj, value);

  /* The timer is active */
  return TRUE;
}

	
void rolodex_table_selected_cb (GtkWidget *list, gpointer data) {
  gchar *work_table;

  g_return_if_fail(GNOME_DB_IS_LIST(list)); 
  work_table = gnome_db_list_get_string (list); 
  show_data(cnc,work_table);
}

void
rolodex_login_cancel_cb (GnomeDbLoginDlg *login_dialog, gpointer data)
{
  gnome_dialog_close(GNOME_DIALOG(login_dialog));
  login_dialog = NULL;
}


void
rolodex_quit_cb (GtkWidget *w, gpointer data)
{
  gtk_main_quit();
}


/* This is the way to present the errors in text format */
 void
rolodex_display_errors_cb(GtkWidget* application, GList* errors)
{
  GList* current_error = errors;
  while (current_error)
    {
      Gda_Error* error = current_error->data;

      fprintf(stderr,"error: %s\n", error->description);
      gda_error_free(error);
      current_error = g_list_next(current_error);
    }
  g_list_free(errors);
}

