/* GNOME DB libary
 * Copyright (C) 1999 Rodrigo Moya
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gda-ui.h>

static void gnome_db_designer_init       (GnomeDbDesigner *designer);
static void gnome_db_designer_class_init (GnomeDbDesignerClass *klass);

static void gnome_db_designer_destroy    (GnomeDbDesigner *designer);

/*
 * GnomeDbDesigner widget interface
 */
static void
gnome_db_designer_class_init (GnomeDbDesignerClass *klass)
{
  GtkObjectClass* object_class = GTK_OBJECT_CLASS(klass);

  object_class->destroy = gnome_db_designer_destroy;
}

static void
gnome_db_designer_init (GnomeDbDesigner *designer)
{
  GtkWidget*   table;
  GtkWidget*   frame;
  GtkWidget*   scroll;
  gchar*       ctree_row[2] = { "", "" };
  GnomePixmap* open_pixmap;
  GnomePixmap* closed_pixmap;

  /* load pixmaps */
  open_pixmap = gda_ui_get_pixmap(GNOME_STOCK_MENU_BOOK_OPEN);
  closed_pixmap = gda_ui_get_pixmap(GNOME_STOCK_MENU_BOOK_GREEN);

  /* create main container */
  table = gda_ui_new_table_widget(4, 2, FALSE);
  gtk_box_pack_start(GTK_BOX(designer), table, 1, 1, 0);

  frame = gda_ui_new_frame_widget(NULL);
  gtk_table_attach(GTK_TABLE(table), frame, 0, 1, 0, 2,
		   GTK_SHRINK | GTK_EXPAND | GTK_FILL,
		   GTK_SHRINK | GTK_EXPAND | GTK_FILL,
		   3, 3);
  scroll = gda_ui_new_scrolled_window_widget();
  gtk_container_add(GTK_CONTAINER(frame), scroll);
  designer->object_tree = gda_ui_new_ctree_widget(NULL, 2);
  ctree_row[1] = _("Tables");
  designer->tables_node = gtk_ctree_insert_node(GTK_CTREE(designer->object_tree),
						NULL, NULL,
						ctree_row, 0,
						GNOME_PIXMAP(open_pixmap)->pixmap,
						GNOME_PIXMAP(open_pixmap)->mask,
						GNOME_PIXMAP(closed_pixmap)->pixmap,
						GNOME_PIXMAP(closed_pixmap)->mask,
						FALSE, TRUE);
  ctree_row[1] = _("Views");
  designer->views_node = gtk_ctree_insert_node(GTK_CTREE(designer->object_tree),
					       NULL, NULL,
					       ctree_row, 0,
					       GNOME_PIXMAP(open_pixmap)->pixmap,
					       GNOME_PIXMAP(open_pixmap)->mask,
					       GNOME_PIXMAP(closed_pixmap)->pixmap,
					       GNOME_PIXMAP(closed_pixmap)->mask,
					       FALSE, TRUE);
  gtk_container_add(GTK_CONTAINER(scroll), designer->object_tree);

  /* create detail pane */
  frame = gda_ui_new_frame_widget(NULL);
  gtk_table_attach(GTK_TABLE(table), frame, 1, 4, 0, 2,
		   GTK_SHRINK | GTK_EXPAND | GTK_FILL,
		   GTK_SHRINK | GTK_EXPAND | GTK_FILL,
		   3, 3);

  /* initialize fields */
  designer->xmldb = NULL;
}

GtkType
gnome_db_designer_get_type (void)
{
  static guint db_designer_type = 0;

  if (!db_designer_type)
    {
      GtkTypeInfo db_designer_info =
      {
        "GnomeDbDesigner",
        sizeof (GnomeDbDesigner),
        sizeof (GnomeDbDesignerClass),
        (GtkClassInitFunc) gnome_db_designer_class_init,
        (GtkObjectInitFunc) gnome_db_designer_init,
        (GtkArgSetFunc) NULL,
        (GtkArgGetFunc) NULL
      };
      db_designer_type = gtk_type_unique(gtk_vbox_get_type(), &db_designer_info);
    }
  return (db_designer_type);
}

/**
 * gnome_db_designer_new
 *
 * Create a new #GnomeDbDesigner widget. This widget lets you visually
 * manage a XML database
 */
GtkWidget *
gnome_db_designer_new (void)
{
  GnomeDbDesigner* designer;

  designer = GNOME_DB_DESIGNER(gtk_type_new(gnome_db_designer_get_type()));
  designer->xmldb = gda_xml_database_new();

  return GTK_WIDGET(designer);
}

static void
gnome_db_designer_destroy (GnomeDbDesigner *designer)
{
  g_return_if_fail(GNOME_DB_IS_DESIGNER(designer));

  gda_xml_database_free(designer->xmldb);
}
