/* GNOME DB libary
 * Copyright (C) 1999 Rodrigo Moya
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#if !defined(__gnome_db_designer_h__)
#  define __gnome_db_designer_h__

BEGIN_GNOME_DECLS

#define GNOME_DB_TYPE_DESIGNER            (gnome_db_designer_get_type())
#define GNOME_DB_DESIGNER(obj)            GTK_CHECK_CAST(obj, gnome_db_designer_get_type(), GnomeDbDesigner)
#define GNOME_DB_DESIGNER_CLASS(klass)    GTK_CHECK_CLASS_CAST(klass, gnome_db_designer_get_type(), GnomeDbDesignerClass)
#define GNOME_DB_IS_DESIGNER(obj)         GTK_CHECK_TYPE(obj, gnome_db_designer_get_type())
#define GNOME_DB_IS_DESIGNER_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), GNOME_DB_TYPE_DESIGNER))

typedef struct _GnomeDbDesigner      GnomeDbDesigner;
typedef struct _GnomeDbDesignerClass GnomeDbDesignerClass;

struct _GnomeDbDesigner
{
  GtkVBox          parent;

  /* private fields - DO NOT USE THEM! */
  GtkWidget*       object_tree;
  GtkCTreeNode*    tables_node;
  GtkCTreeNode*    views_node;
  Gda_XmlDatabase* xmldb;
};

struct _GnomeDbDesignerClass
{
  GtkVBoxClass parent_class;
};

GtkType    gnome_db_designer_get_type (void);

GtkWidget* gnome_db_designer_new      (void);

END_GNOME_DECLS

#endif
