/* GNOME DB components provider
 * Copyright (C) 2000 Rodrigo Moya
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gda-components.h>

/* This structure contains the list of controls available in this process. Just
   insert lines at the end to add new components */
struct
{
  const gchar*            id;
  GnomeDbControl*         control;
  GnomeDbControlFunc      create_widget_cb;
  GtkSignalFunc           new_instance_cb;
  GtkSignalFunc           set_property_cb;
} l_components[] = {
  {
#if USING_OAF
    "OAFIID:control-factory:gnome-db-grid:928f45f6-48ba-4b0d-b84b-051b604a722c",
#else
    "control-factory:gnome-db-grid", 
#endif
    NULL, components_grid_new_widget,
    components_grid_new_instance_cb, components_grid_set_property_cb
  },
  {
#if USING_OAF
    "OAFIID:control-factory:gnome-db-browser:e2165a75-3242-4da1-b94e-f252ed916a6c",
#else
    "control-factory:gnome-db-browser",
#endif
    NULL, components_browser_new_widget,
    components_browser_new_instance_cb, components_browser_set_property_cb
  },
};

void
components_factory_init (void)
{
  static gboolean initialized = FALSE;

  if (!initialized)
    {
      register gint cnt;

      for (cnt = 0; cnt < sizeof(l_components) / sizeof(l_components[0]); cnt++)
	{
	  l_components[cnt].control = gnome_db_control_new(l_components[cnt].id,
							   l_components[cnt].create_widget_cb);
	  if (!GNOME_DB_CONTROL(l_components[cnt].control))
	    {
	      g_error(_("Could not initialize %s component"), l_components[cnt].id);
	    }
	  gtk_signal_connect(GTK_OBJECT(l_components[cnt].control),
			     "new_instance",
			     l_components[cnt].new_instance_cb,
			     NULL);
	  gtk_signal_connect(GTK_OBJECT(l_components[cnt].control),
			     "set_property",
			     l_components[cnt].set_property_cb,
			     NULL);
	}
      initialized = TRUE;
    }
}
